/*
 * Decompiled with CFR 0.152.
 */
package apmon.host;

import apmon.ApMonMonitoringConstants;
import apmon.host.Parser;
import apmon.host.cmdExec;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ProcReader {
    static int cnt = 0;
    private HashMap hm = null;
    private cmdExec exec = null;
    private Parser parser = null;
    private String[] netInterfaces = null;
    private String hwAddress = null;
    private String cpuUsr = null;
    private long dcpuUsr = 0L;
    private String cpuNice = null;
    private long dcpuNice = 0L;
    private String cpuSys = null;
    private long dcpuSys = 0L;
    private String cpuIdle = null;
    private long dcpuIdle = 0L;
    private String cpuUsage = null;
    private String pagesIn = null;
    private long dpagesIn = 0L;
    private String pagesOut = null;
    private long dpagesOut = 0L;
    private String memUsage = null;
    private String memTotal = null;
    private String memUsed = null;
    private String memFree = null;
    private String swapTotal = null;
    private String swapFree = null;
    private String swapUsed = null;
    private String swapUsage = null;
    private String diskIO = null;
    private long ddiskIO = 0L;
    private long dblkRead = 0L;
    private long dblkWrite = 0L;
    private String diskTotal = null;
    private String diskUsed = null;
    private String diskFree = null;
    private String diskUsage = null;
    private String processesNo = null;
    private String load1 = null;
    private String load5 = null;
    private String load15 = null;
    private Hashtable netIn = new Hashtable();
    private Hashtable dnetIn = new Hashtable();
    private Hashtable netOut = new Hashtable();
    private Hashtable dnetOut = new Hashtable();
    private Hashtable states = null;
    private Hashtable netSockets = null;
    private Hashtable netTcpDetails = null;
    private long lastCall = 0L;

    public ProcReader() {
        this.exec = new cmdExec();
        this.parser = new Parser();
        this.states = new Hashtable();
        this.netSockets = new Hashtable();
        this.netTcpDetails = new Hashtable();
        this.update();
    }

    public static void main(String[] args) {
        ProcReader reader = new ProcReader();
        while (true) {
            reader.update();
            System.out.println("");
            System.out.println("CPU Sys: " + reader.getCPUSys());
            System.out.println("CPU Usr: " + reader.getCPUUsr());
            System.out.println("CPU Nice: " + reader.getCPUNice());
            System.out.println("CPU Idle: " + reader.getCPUIdle());
            System.out.println("CPU Usage: " + reader.getCPUUsage());
            System.out.println("");
            System.out.println("Pages in: " + reader.getPagesIn());
            System.out.println("Pages out: " + reader.getPagesOut());
            System.out.println("");
            System.out.println("Mem usage: " + reader.getMemUsage());
            System.out.println("Mem used: " + reader.getMemUsed());
            System.out.println("Mem free: " + reader.getMemFree());
            System.out.println("");
            System.out.println("Disk total: " + reader.getDiskTotal());
            System.out.println("Disk used: " + reader.getDiskUsed());
            System.out.println("Disk free: " + reader.getDiskFree());
            System.out.println("Disk usage: " + reader.getDiskUsage());
            System.out.println("Disk IO: " + reader.getDiskIO());
            System.out.println("");
            System.out.println("Processes: " + reader.getNoProcesses());
            System.out.println("Load1: " + reader.getLoad1());
            System.out.println("Load5: " + reader.getLoad5());
            System.out.println("Load15: " + reader.getLoad15());
            System.out.println("");
            System.out.println("MAC: " + reader.getMacAddress());
            System.out.println("Net IFS");
            String[] netIfs = reader.getNetInterfaces();
            if (netIfs != null) {
                int i;
                for (i = 0; i < netIfs.length; ++i) {
                    System.out.print(netIfs[i] + " ");
                }
                System.out.println("");
                System.out.println("Net in");
                for (i = 0; i < netIfs.length; ++i) {
                    System.out.print(reader.getNetIn(netIfs[i]) + " ");
                }
                System.out.println("");
                System.out.println("Net out");
                for (i = 0; i < netIfs.length; ++i) {
                    System.out.print(reader.getNetOut(netIfs[i]) + " ");
                }
                System.out.println("");
            }
            System.out.println("");
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
            }
        }
    }

    private void addNetInterface(String netInterface) {
        if (netInterface == null || netInterface.equals("")) {
            return;
        }
        netInterface = netInterface.trim();
        if (this.netInterfaces == null) {
            this.netInterfaces = new String[1];
            this.netInterfaces[0] = netInterface;
            return;
        }
        for (int i = 0; i < this.netInterfaces.length; ++i) {
            if (!netInterface.equals(this.netInterfaces[i])) continue;
            return;
        }
        String[] tmpNetInterfaces = new String[this.netInterfaces.length + 1];
        System.arraycopy(this.netInterfaces, 0, tmpNetInterfaces, 0, this.netInterfaces.length);
        tmpNetInterfaces[this.netInterfaces.length] = netInterface;
        this.netInterfaces = tmpNetInterfaces;
    }

    public synchronized void update() {
        int i;
        ++cnt;
        long newCall = System.currentTimeMillis();
        double diffCall = (double)(newCall - this.lastCall) / 1000.0;
        String str = null;
        String output = "";
        String line = "";
        if (this.hwAddress == null) {
            output = this.exec.executeCommandReality("ifconfig -a", "b");
            if (this.exec.isError()) {
                output = null;
            }
            if (output != null && !output.equals("")) {
                this.netInterfaces = null;
                this.parser.parse(output);
                line = this.parser.nextLine();
                this.hwAddress = null;
                while (line != null) {
                    if (line != null && (line.startsWith(" ") || line.startsWith("\t"))) {
                        line = this.parser.nextLine();
                        continue;
                    }
                    if (line == null) break;
                    this.parser.parseAux(line);
                    String netName = this.parser.nextAuxToken(" \t\n");
                    if (netName != null && !netName.equals("")) {
                        this.addNetInterface(netName);
                    }
                    if ((str = this.parser.getTextAfterToken(line, "HWaddr ")) != null) {
                        this.hwAddress = str;
                    }
                    line = this.parser.nextLine();
                }
            }
        }
        this.pagesOut = null;
        this.pagesIn = null;
        this.diskIO = null;
        this.cpuSys = null;
        this.cpuNice = null;
        this.cpuIdle = null;
        this.cpuUsr = null;
        this.cpuUsage = null;
        this.parser.parseFromFile("/proc/stat");
        line = this.parser.nextLine();
        while (line != null) {
            if (line.startsWith("page")) {
                line = this.parser.getTextAfterToken(line, "page ");
                this.parser.parseAux(line);
                this.pagesIn = this.parser.nextAuxToken();
                this.pagesOut = this.parser.nextAuxToken();
                long dpIn = 0L;
                long dpOut = 0L;
                try {
                    dpIn = Long.parseLong(this.pagesIn);
                }
                catch (Exception e) {
                    dpIn = -1L;
                }
                try {
                    dpOut = Long.parseLong(this.pagesOut);
                }
                catch (Exception e) {
                    dpOut = -1L;
                }
                if (dpIn >= 0L) {
                    this.pagesIn = "" + (double)this.diffWithOverflowCheck(dpIn, this.dpagesIn) / diffCall;
                    this.dpagesIn = dpIn;
                }
                if (dpOut >= 0L) {
                    this.pagesOut = "" + (double)this.diffWithOverflowCheck(dpOut, this.dpagesOut) / diffCall;
                    this.dpagesOut = dpOut;
                }
            }
            if (line.startsWith("cpu") && this.cpuUsr == null) {
                line = this.parser.getTextAfterToken(line, "cpu ");
                this.parser.parseAux(line);
                long dcUsr = 0L;
                long dcSys = 0L;
                long dcNice = 0L;
                long dcIdle = 0L;
                line = this.parser.nextAuxToken();
                try {
                    dcUsr = Long.parseLong(line);
                }
                catch (Exception e) {
                    dcUsr = -1L;
                }
                line = this.parser.nextAuxToken();
                try {
                    dcNice = Long.parseLong(line);
                }
                catch (Exception e) {
                    dcNice = -1L;
                }
                line = this.parser.nextAuxToken();
                try {
                    dcSys = Long.parseLong(line);
                }
                catch (Exception e) {
                    dcSys = -1L;
                }
                line = this.parser.nextAuxToken();
                try {
                    dcIdle = Long.parseLong(line);
                }
                catch (Exception e) {
                    dcIdle = -1L;
                }
                double tmpUsr = (double)this.diffWithOverflowCheck(dcUsr, this.dcpuUsr) / diffCall;
                double tmpSys = (double)this.diffWithOverflowCheck(dcSys, this.dcpuSys) / diffCall;
                double tmpIdle = (double)this.diffWithOverflowCheck(dcIdle, this.dcpuIdle) / diffCall;
                double tmpNice = (double)this.diffWithOverflowCheck(dcNice, this.dcpuNice) / diffCall;
                if (tmpUsr >= 0.0 && tmpSys >= 0.0 && tmpIdle >= 0.0 && tmpNice >= 0.0) {
                    this.dcpuUsr = dcUsr;
                    this.dcpuSys = dcSys;
                    this.dcpuNice = dcNice;
                    this.dcpuIdle = dcIdle;
                    double dcTotalP = tmpUsr + tmpSys + tmpNice;
                    double dcTotal = dcTotalP + tmpIdle;
                    this.cpuUsr = "" + 100.0 * tmpUsr / dcTotal;
                    this.cpuSys = "" + 100.0 * tmpSys / dcTotal;
                    this.cpuNice = "" + 100.0 * tmpNice / dcTotal;
                    this.cpuIdle = "" + 100.0 * tmpIdle / dcTotal;
                    this.cpuUsage = "" + 100.0 * dcTotalP / dcTotal;
                }
            }
            line = this.parser.nextLine();
        }
        output = this.exec.executeCommandReality(System.getProperty("user.home") + "/iostat -k", "L");
        if (this.exec.isError()) {
            output = null;
        }
        if (output != null && !output.equals("")) {
            this.parser.parse(output);
            line = this.parser.nextLine();
            while (line != null && line.indexOf("avg-cpu") == -1) {
                line = this.parser.nextLine();
            }
            if (line != null && this.cpuUsr == null) {
                str = this.parser.nextToken(" \t\n");
                if (str != null) {
                    this.cpuUsr = str;
                }
                if ((str = this.parser.nextToken(" \t\n")) != null) {
                    this.cpuNice = str;
                }
                if ((str = this.parser.nextToken(" \t\n")) != null) {
                    this.cpuSys = str;
                }
                str = this.parser.nextToken(" \t\n");
                str = this.parser.nextToken(" \t\n");
                if (str != null) {
                    this.cpuIdle = str;
                }
                double dcUsr = 0.0;
                double dcSys = 0.0;
                double dcNice = 0.0;
                double dcIdle = 0.0;
                double d = -1.0;
                try {
                    d = Double.parseDouble(this.cpuUsr);
                }
                catch (Exception e) {
                    d = -1.0;
                }
                if (d >= 0.0) {
                    dcUsr = d;
                }
                try {
                    d = Double.parseDouble(this.cpuSys);
                }
                catch (Exception e) {
                    d = -1.0;
                }
                if (d >= 0.0) {
                    dcSys = d;
                }
                try {
                    d = Double.parseDouble(this.cpuIdle);
                }
                catch (Exception e) {
                    d = -1.0;
                }
                if (d >= 0.0) {
                    dcIdle = d;
                }
                try {
                    d = Double.parseDouble(this.cpuNice);
                }
                catch (Exception e) {
                    d = -1.0;
                }
                if (d >= 0.0) {
                    dcNice = d;
                }
                if (dcUsr + dcSys + dcNice + dcIdle != 0.0) {
                    this.cpuUsage = "" + (dcUsr + dcSys + dcNice);
                }
                str = this.parser.nextToken(" \t\n");
                while (str != null && str.indexOf("Device:") == -1) {
                    str = this.parser.nextToken(" \t\n");
                }
                if (str != null) {
                    for (int i2 = 0; i2 < 5 && str != null; ++i2) {
                        str = this.parser.nextToken(" \t\n");
                    }
                    long blkRead = 0L;
                    long blkWrite = 0L;
                    while ((str = this.parser.nextToken(" \t\n")) != null) {
                        str = this.parser.nextToken(" \t\n");
                        str = this.parser.nextToken(" \t\n");
                        str = this.parser.nextToken(" \t\n");
                        str = this.parser.nextToken(" \t\n");
                        long l = 0L;
                        try {
                            l = Long.parseLong(str);
                        }
                        catch (Exception e) {
                            l = -1L;
                        }
                        if (l >= 0L) {
                            blkRead += l;
                        }
                        str = this.parser.nextToken(" \t\n");
                        l = 0L;
                        try {
                            l = Long.parseLong(str);
                        }
                        catch (Exception e) {
                            l = -1L;
                        }
                        if (!((double)l >= 0.0)) continue;
                        blkWrite += l;
                    }
                    double dRead = (double)this.diffWithOverflowCheck(blkRead, this.dblkRead) / diffCall;
                    double dWrite = (double)this.diffWithOverflowCheck(blkWrite, this.dblkWrite) / diffCall;
                    this.diskIO = "" + (dRead + dWrite);
                    this.dblkRead = blkRead;
                    this.dblkWrite = blkWrite;
                }
            } else if (line != null) {
                str = this.parser.nextToken(" \t\n");
                while (str != null && str.indexOf("Device:") == -1) {
                    str = this.parser.nextToken(" \t\n");
                }
                if (str != null) {
                    for (int i3 = 0; i3 < 5 && str != null; ++i3) {
                        str = this.parser.nextToken(" \t\n");
                    }
                    long blkRead = 0L;
                    long blkWrite = 0L;
                    while ((str = this.parser.nextToken(" \t\n")) != null) {
                        str = this.parser.nextToken(" \t\n");
                        str = this.parser.nextToken(" \t\n");
                        str = this.parser.nextToken(" \t\n");
                        str = this.parser.nextToken(" \t\n");
                        long l = 0L;
                        try {
                            l = Long.parseLong(str);
                        }
                        catch (Exception e) {
                            l = -1L;
                        }
                        if (l >= 0L) {
                            blkRead += l;
                        }
                        str = this.parser.nextToken(" \t\n");
                        l = 0L;
                        try {
                            l = Long.parseLong(str);
                        }
                        catch (Exception e) {
                            l = -1L;
                        }
                        if (l < 0L) continue;
                        blkWrite += l;
                    }
                    double dRead = (double)this.diffWithOverflowCheck(blkRead, this.dblkRead) / diffCall;
                    double dWrite = (double)this.diffWithOverflowCheck(blkWrite, this.dblkWrite) / diffCall;
                    this.diskIO = "" + (dRead + dWrite);
                    this.ddiskIO = blkRead + blkWrite;
                    this.dblkRead = blkRead;
                    this.dblkWrite = blkWrite;
                }
            }
        }
        this.memUsed = null;
        this.memFree = null;
        this.memUsage = null;
        this.swapTotal = null;
        this.swapFree = null;
        this.parser.parseFromFile("/proc/meminfo");
        line = this.parser.nextLine();
        double dmemTotal = 0.0;
        double dmemFree = 0.0;
        while (line != null) {
            double d;
            if (line.startsWith("MemTotal")) {
                line = this.parser.getTextAfterToken(line, "MemTotal:");
                this.parser.parseAux(line);
                this.memTotal = this.parser.nextAuxToken();
                d = 0.0;
                try {
                    d = Double.parseDouble(this.memTotal);
                }
                catch (Exception e) {
                    d = -1.0;
                }
                if (d >= 0.0) {
                    dmemTotal = d;
                }
            } else if (line.startsWith("MemFree")) {
                line = this.parser.getTextAfterToken(line, "MemFree:");
                this.parser.parseAux(line);
                this.memFree = this.parser.nextAuxToken();
                d = 0.0;
                try {
                    d = Double.parseDouble(this.memFree);
                }
                catch (Exception e) {
                    d = -1.0;
                }
                if (d >= 0.0) {
                    dmemFree = d;
                }
            } else if (line.startsWith("SwapTotal")) {
                line = this.parser.getTextAfterToken(line, "SwapTotal:");
                this.parser.parseAux(line);
                this.swapTotal = this.parser.nextAuxToken();
            } else if (line.startsWith("SwapFree")) {
                line = this.parser.getTextAfterToken(line, "SwapFree:");
                this.parser.parseAux(line);
                this.swapFree = this.parser.nextAuxToken();
            }
            line = this.parser.nextLine();
        }
        double dst = Double.valueOf(this.swapTotal);
        double dsf = Double.valueOf(this.swapFree);
        double dsu = dst - dsf;
        this.swapUsed = "" + dsu;
        this.swapUsage = "" + (1.0 - dsu / dst) * 100.0;
        this.memFree = "" + dmemFree / 1024.0;
        this.memUsed = "" + (dmemTotal - dmemFree) / 1024.0;
        this.memUsage = "" + 100.0 * (dmemTotal - dmemFree) / dmemTotal;
        output = this.exec.executeCommandReality("df -B 1024", "o");
        if (this.exec.isError()) {
            output = null;
        }
        double size = 0.0;
        double used = 0.0;
        double available = 0.0;
        double usage = 0.0;
        if (output != null && output != "") {
            this.parser.parse(output);
            line = this.parser.nextToken(" \t\n");
            int nr = 0;
            for (i = 0; i < 6 && line != null; ++i) {
                line = this.parser.nextToken(" \t\n");
            }
            while ((line = this.parser.nextToken(" \t\n")) != null) {
                line = this.parser.nextToken(" \t\n");
                double d = 0.0;
                try {
                    d = Double.parseDouble(line);
                }
                catch (Exception e) {
                    d = -1.0;
                }
                if (d < 0.0) break;
                size += d;
                line = this.parser.nextToken(" \t\n");
                d = 0.0;
                try {
                    d = Double.parseDouble(line);
                }
                catch (Exception e) {
                    d = -1.0;
                }
                if (d < 0.0) break;
                used += d;
                line = this.parser.nextToken(" \t\n");
                d = 0.0;
                try {
                    d = Double.parseDouble(line);
                }
                catch (Exception e) {
                    d = -1.0;
                }
                if (d < 0.0) break;
                available += d;
                line = this.parser.nextToken(" \t\n");
                line = this.parser.getTextBeforeToken(line, "%");
                d = 0.0;
                try {
                    d = Double.parseDouble(line);
                }
                catch (Exception e) {
                    d = -1.0;
                }
                if (d < 0.0) break;
                usage += d;
                ++nr;
                line = this.parser.nextToken(" \t\n");
                if (line != null) continue;
                break;
            }
            this.diskTotal = "" + size / 1048576.0;
            this.diskUsed = "" + used / 1048576.0;
            this.diskFree = "" + available / 1048576.0;
            this.diskUsage = "" + usage * 1.0 / (double)nr;
        } else {
            String[] files = this.parser.listFiles("/proc/ide");
            if (files != null && files.length != 0) {
                for (i = 0; i < files.length; ++i) {
                    if (!files[i].startsWith("hd")) continue;
                    this.parser.parseFromFile("/proc/ide/" + files[i] + "/capacity");
                    line = this.parser.nextLine();
                    double d = 0.0;
                    try {
                        d = Double.parseDouble(line);
                    }
                    catch (Exception e) {
                        d = -1.0;
                    }
                    if (!(d >= 0.0)) continue;
                    size += d;
                }
            }
            this.diskFree = this.diskTotal = "" + size / 1048576.0;
        }
        output = this.exec.executeCommandReality("ps -e -A -o state", "");
        if (output != null && !output.equals("")) {
            this.parser.parse(output);
            line = this.parser.nextLine();
            this.processesNo = null;
            int pNo = 0;
            this.states.put("D", new Integer(0));
            this.states.put("R", new Integer(0));
            this.states.put("S", new Integer(0));
            this.states.put("T", new Integer(0));
            this.states.put("Z", new Integer(0));
            while (line != null) {
                if (line != null && (line.startsWith(" ") || line.startsWith("\t"))) {
                    line = this.parser.nextLine();
                    continue;
                }
                Enumeration e = this.states.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (!line.startsWith(key)) continue;
                    int value = (Integer)this.states.get(key);
                    ++pNo;
                    this.states.put(key, new Integer(++value));
                }
                line = this.parser.nextLine();
            }
            this.processesNo = "" + pNo;
        }
        if ((output = this.exec.executeCommandReality("netstat -an", "")) != null && !output.equals("")) {
            this.parser.parse(output);
            line = this.parser.nextLine();
            this.netSockets.put("tcp", new Integer(0));
            this.netSockets.put("udp", new Integer(0));
            this.netSockets.put("unix", new Integer(0));
            this.netSockets.put("icm", new Integer(0));
            this.netTcpDetails.put("ESTABLISHED", new Integer(0));
            this.netTcpDetails.put("SYN_SENT", new Integer(0));
            this.netTcpDetails.put("SYN_RECV", new Integer(0));
            this.netTcpDetails.put("FIN_WAIT1", new Integer(0));
            this.netTcpDetails.put("FIN_WAIT2", new Integer(0));
            this.netTcpDetails.put("TIME_WAIT", new Integer(0));
            this.netTcpDetails.put("CLOSED", new Integer(0));
            this.netTcpDetails.put("CLOSE_WAIT", new Integer(0));
            this.netTcpDetails.put("LAST_ACK", new Integer(0));
            this.netTcpDetails.put("LISTEN", new Integer(0));
            this.netTcpDetails.put("CLOSING", new Integer(0));
            this.netTcpDetails.put("UNKNOWN", new Integer(0));
            try {
                String key = null;
                int value = 0;
                while (line != null) {
                    if (line != null && (line.startsWith(" ") || line.startsWith("\t"))) {
                        line = this.parser.nextLine();
                        continue;
                    }
                    if (line.startsWith("tcp")) {
                        key = "tcp";
                        value = (Integer)this.netSockets.get(key);
                        this.netSockets.put(key, new Integer(++value));
                        StringTokenizer st = new StringTokenizer(line, " []");
                        while (st.hasMoreTokens()) {
                            String element;
                            key = element = st.nextToken();
                            if (!this.netTcpDetails.containsKey(element)) continue;
                            value = (Integer)this.netTcpDetails.get(key);
                            this.netTcpDetails.put(key, new Integer(++value));
                        }
                    }
                    if (line.startsWith("udp")) {
                        key = "udp";
                        value = (Integer)this.netSockets.get(key);
                        this.netSockets.put(key, new Integer(++value));
                    }
                    if (line.startsWith("unix")) {
                        key = "unix";
                        value = (Integer)this.netSockets.get(key);
                        this.netSockets.put(key, new Integer(++value));
                    }
                    if (line.startsWith("icm")) {
                        key = "icm";
                        value = (Integer)this.netSockets.get(key);
                        this.netSockets.put(key, new Integer(++value));
                    }
                    line = this.parser.nextLine();
                }
            }
            catch (Exception key) {
                // empty catch block
            }
        }
        this.parser.parseFromFile("/proc/loadavg");
        this.load15 = null;
        this.load5 = null;
        this.load1 = null;
        line = this.parser.nextToken(" \t\n");
        if (line != null) {
            double d = 0.0;
            try {
                d = Double.parseDouble(line);
            }
            catch (Exception e) {
                d = -1.0;
            }
            if (d >= 0.0) {
                this.load1 = "" + d;
            }
            line = this.parser.nextToken(" \t\n");
            d = 0.0;
            try {
                d = Double.parseDouble(line);
            }
            catch (Exception e) {
                d = -1.0;
            }
            if (d >= 0.0) {
                this.load5 = "" + d;
            }
            line = this.parser.nextToken(" \t\n");
            d = 0.0;
            try {
                d = Double.parseDouble(line);
            }
            catch (Exception e) {
                d = -1.0;
            }
            if (d >= 0.0) {
                this.load15 = "" + d;
            }
        }
        this.parser.parseFromFile("/proc/net/dev");
        if (this.netInterfaces == null) {
            while ((line = this.parser.nextToken(":\n\t ")) != null) {
                if (!line.startsWith("eth") && !line.startsWith("lo")) continue;
                this.addNetInterface(line);
                String name = line;
                line = this.parser.nextToken(" \t\n");
                long d = 0L;
                long oldReceived = 0L;
                if (this.dnetIn.containsKey(name)) {
                    try {
                        oldReceived = (Long)this.dnetIn.get(name);
                    }
                    catch (Exception e) {
                        oldReceived = -1L;
                    }
                    try {
                        d = Long.parseLong(line);
                    }
                    catch (Exception e) {
                        d = -1L;
                    }
                    if (oldReceived >= 0L && d >= 0L) {
                        double in = (double)this.diffWithOverflowCheck(d, oldReceived) / diffCall;
                        oldReceived = d;
                        this.netIn.put(name, "" + (in /= 1048576.0));
                        this.dnetIn.put(name, new Long(oldReceived));
                    }
                } else {
                    d = 0L;
                    try {
                        d = Long.parseLong(line);
                    }
                    catch (Exception e) {
                        d = -1L;
                    }
                    if (d >= 0L) {
                        this.netIn.put(name, "" + d);
                        this.dnetIn.put(name, new Long(d));
                    }
                }
                line = this.parser.nextToken(" \t\n");
                for (int i4 = 0; i4 < 6; ++i4) {
                    line = this.parser.nextToken(" \t\n");
                }
                line = this.parser.nextToken(" \t\n");
                d = 0L;
                long oldSent = 0L;
                if (this.dnetOut.containsKey(name)) {
                    try {
                        oldSent = (Long)this.dnetOut.get(name);
                    }
                    catch (Exception e) {
                        oldSent = -1L;
                    }
                    try {
                        d = Long.parseLong(line);
                    }
                    catch (Exception e) {
                        d = -1L;
                    }
                    if (oldSent >= 0L && d >= 0L) {
                        double out = (double)this.diffWithOverflowCheck(d, oldSent) / diffCall;
                        oldSent = d;
                        this.netOut.put(name, "" + (out /= 1048576.0));
                        this.dnetOut.put(name, new Long(oldSent));
                    }
                } else {
                    d = 0L;
                    try {
                        d = Long.parseLong(line);
                    }
                    catch (Exception e) {
                        d = -1L;
                    }
                    if (d >= 0L) {
                        this.netOut.put(name, "" + d);
                        this.dnetOut.put(name, new Long(d));
                    }
                }
                line = this.parser.nextToken(" \t\n");
            }
        } else {
            while ((line = this.parser.nextToken(":\n\t ")) != null) {
                boolean found = false;
                for (i = 0; i < this.netInterfaces.length; ++i) {
                    if (!line.equals(this.netInterfaces[i])) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                String name = line;
                line = this.parser.nextToken(" \t\n:");
                long d = 0L;
                long oldReceived = 0L;
                if (this.dnetIn.containsKey(name)) {
                    try {
                        oldReceived = (Long)this.dnetIn.get(name);
                    }
                    catch (Exception e) {
                        oldReceived = -1L;
                    }
                    try {
                        d = Long.parseLong(line);
                    }
                    catch (Exception e) {
                        d = -1L;
                    }
                    if (oldReceived >= 0L && d >= 0L) {
                        double in = (double)this.diffWithOverflowCheck(d, oldReceived) / diffCall;
                        oldReceived = d;
                        this.netIn.put(name, "" + (in /= 1048576.0));
                        this.dnetIn.put(name, new Long(oldReceived));
                    }
                } else {
                    d = 0L;
                    try {
                        d = Long.parseLong(line);
                    }
                    catch (Exception e) {
                        d = -1L;
                    }
                    if (d >= 0L) {
                        this.netIn.put(name, "" + d);
                        this.dnetIn.put(name, new Long(d));
                    }
                }
                line = this.parser.nextToken(" \t\n");
                for (int i5 = 0; i5 < 6; ++i5) {
                    line = this.parser.nextToken(" \t\n");
                }
                line = this.parser.nextToken(" \t\n");
                d = 0L;
                long oldSent = 0L;
                if (this.dnetOut.containsKey(name)) {
                    try {
                        oldSent = (Long)this.dnetOut.get(name);
                    }
                    catch (Exception e) {
                        oldSent = -1L;
                    }
                    try {
                        d = Long.parseLong(line);
                    }
                    catch (Exception e) {
                        d = -1L;
                    }
                    if (oldSent >= 0L && d >= 0L) {
                        double out = (double)this.diffWithOverflowCheck(d, oldSent) / diffCall;
                        oldSent = d;
                        this.netOut.put(name, "" + (out /= 1048576.0));
                        this.dnetOut.put(name, new Long(oldSent));
                    }
                } else {
                    d = 0L;
                    try {
                        d = Long.parseLong(line);
                    }
                    catch (Exception e) {
                        d = -1L;
                    }
                    if (d >= 0L) {
                        this.netOut.put(name, "" + d);
                        this.dnetOut.put(name, new Long(d));
                    }
                }
                line = this.parser.nextToken(" \t\n");
            }
        }
        this.hm = new HashMap();
        this.hm.put(ApMonMonitoringConstants.LSYS_LOAD1, this.load1);
        this.hm.put(ApMonMonitoringConstants.LSYS_LOAD5, this.load5);
        this.hm.put(ApMonMonitoringConstants.LSYS_LOAD15, this.load15);
        this.hm.put(ApMonMonitoringConstants.LSYS_CPU_USR, this.cpuUsr);
        this.hm.put(ApMonMonitoringConstants.LSYS_CPU_NICE, this.cpuNice);
        this.hm.put(ApMonMonitoringConstants.LSYS_CPU_SYS, this.cpuSys);
        this.hm.put(ApMonMonitoringConstants.LSYS_CPU_IDLE, this.cpuIdle);
        this.hm.put(ApMonMonitoringConstants.LSYS_CPU_USAGE, this.cpuUsage);
        this.hm.put(ApMonMonitoringConstants.LSYS_MEM_FREE, this.memFree);
        this.hm.put(ApMonMonitoringConstants.LSYS_MEM_USED, this.memUsed);
        this.hm.put(ApMonMonitoringConstants.LSYS_MEM_USAGE, this.memUsage);
        this.hm.put(ApMonMonitoringConstants.LSYS_PAGES_IN, this.pagesIn);
        this.hm.put(ApMonMonitoringConstants.LSYS_PAGES_OUT, this.pagesOut);
        this.hm.put(ApMonMonitoringConstants.LSYS_SWAP_FREE, this.swapFree);
        this.hm.put(ApMonMonitoringConstants.LSYS_SWAP_USED, this.swapUsed);
        this.hm.put(ApMonMonitoringConstants.LSYS_SWAP_USAGE, this.swapUsage);
        this.hm.put(ApMonMonitoringConstants.LSYS_PROCESSES, this.processesNo);
        this.lastCall = newCall;
    }

    public synchronized HashMap getHashedValues() {
        return this.hm;
    }

    public synchronized String getMacAddress() {
        if (this.hwAddress != null) {
            this.hwAddress = this.hwAddress.trim();
        }
        return this.hwAddress;
    }

    public synchronized String getCPUUsage() {
        if (this.cpuUsage != null) {
            this.cpuUsage = this.cpuUsage.trim();
        }
        return this.cpuUsage;
    }

    public synchronized String getCPUUsr() {
        if (this.cpuUsr != null) {
            this.cpuUsr = this.cpuUsr.trim();
        }
        return this.cpuUsr;
    }

    public synchronized String getCPUSys() {
        if (this.cpuSys != null) {
            this.cpuSys = this.cpuSys.trim();
        }
        return this.cpuSys;
    }

    public synchronized String getCPUNice() {
        if (this.cpuNice != null) {
            this.cpuNice = this.cpuNice.trim();
        }
        return this.cpuNice;
    }

    public synchronized String getCPUIdle() {
        if (this.cpuIdle != null) {
            this.cpuIdle = this.cpuIdle.trim();
        }
        return this.cpuIdle;
    }

    public synchronized String getPagesIn() {
        if (this.pagesIn != null) {
            this.pagesIn = this.pagesIn.trim();
        }
        return this.pagesIn;
    }

    public synchronized String getPagesOut() {
        if (this.pagesOut != null) {
            this.pagesOut = this.pagesOut.trim();
        }
        return this.pagesOut;
    }

    public synchronized String getMemUsage() {
        if (this.memUsage != null) {
            this.memUsage = this.memUsage.trim();
        }
        return this.memUsage;
    }

    public synchronized String getMemTotal() {
        if (this.memTotal != null) {
            this.memTotal = this.memTotal.trim();
        }
        return this.memTotal;
    }

    public synchronized String getMemUsed() {
        if (this.memUsed != null) {
            this.memUsed = this.memUsed.trim();
        }
        return this.memUsed;
    }

    public synchronized String getMemFree() {
        if (this.memFree != null) {
            this.memFree = this.memFree.trim();
        }
        return this.memFree;
    }

    public synchronized String getSwapTotal() {
        if (this.swapTotal != null) {
            this.swapTotal = this.swapTotal.trim();
        }
        return this.swapTotal;
    }

    public synchronized String getSwapFree() {
        if (this.swapTotal != null) {
            this.swapTotal = this.swapTotal.trim();
        }
        return this.swapTotal;
    }

    public synchronized String getDiskIO() {
        if (this.diskIO != null) {
            this.diskIO = this.diskIO.trim();
        }
        return this.diskIO;
    }

    public synchronized String getDiskTotal() {
        if (this.diskTotal != null) {
            this.diskTotal = this.diskTotal.trim();
        }
        return this.diskTotal;
    }

    public synchronized String getDiskUsed() {
        if (this.diskUsed != null) {
            this.diskUsed = this.diskUsed.trim();
        }
        return this.diskUsed;
    }

    public synchronized String getDiskFree() {
        if (this.diskFree != null) {
            this.diskFree = this.diskFree.trim();
        }
        return this.diskFree;
    }

    public synchronized String getDiskUsage() {
        if (this.diskUsage != null) {
            this.diskUsage = this.diskUsage.trim();
        }
        return this.diskUsage;
    }

    public synchronized String getNoProcesses() {
        if (this.processesNo != null) {
            this.processesNo = this.processesNo.trim();
        }
        return this.processesNo;
    }

    public synchronized String getLoad1() {
        if (this.load1 != null) {
            this.load1 = this.load1.trim();
        }
        return this.load1;
    }

    public synchronized String getLoad5() {
        if (this.load5 != null) {
            this.load5 = this.load5.trim();
        }
        return this.load5;
    }

    public synchronized Hashtable getProcessesState() {
        return this.states;
    }

    public synchronized Hashtable getNetSockets() {
        return this.netSockets;
    }

    public synchronized Hashtable getTcpDetails() {
        return this.netTcpDetails;
    }

    public synchronized String getLoad15() {
        if (this.load15 != null) {
            this.load15 = this.load15.trim();
        }
        return this.load15;
    }

    public synchronized String[] getNetInterfaces() {
        return this.netInterfaces;
    }

    public synchronized String getNetIn(String netInterface) {
        if (this.netIn.containsKey(netInterface)) {
            String str = (String)this.netIn.get(netInterface);
            if (str != null) {
                str = str.trim();
            }
            return str;
        }
        return null;
    }

    public synchronized String getNetOut(String netInterface) {
        if (this.netOut.containsKey(netInterface)) {
            String str = (String)this.netOut.get(netInterface);
            if (str != null) {
                str = str.trim();
            }
            return str;
        }
        return null;
    }

    public void stopIt() {
        this.exec.stopIt();
    }

    public long diffWithOverflowCheck(long newVal, long oldVal) {
        if (newVal >= oldVal) {
            return newVal - oldVal;
        }
        long p32 = 0x100000000L;
        long p64 = 1L;
        long vmax = oldVal < p32 ? p32 : p64;
        return newVal - oldVal + vmax;
    }
}

