/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.globusonlinetool.myswingutils;

import com.sshtools.common.globusonlinetool.GOHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class JTreeNodeDynamic {

    public static class MyTreeNode
    extends DefaultMutableTreeNode
    implements PropertyChangeListener {
        private boolean loaded = false;
        private int depth;
        private boolean isUncertain = false;
        private final int index;
        private String endpoint;
        private boolean isLeaf;
        private Map fileDetails;
        private PropertyChangeListener progressListener;
        private JProgressBar bar;

        public MyTreeNode(int index, int depth, String dir, String endpoint, boolean allowChildren) {
            this.index = index;
            this.depth = depth;
            this.endpoint = endpoint;
            this.isLeaf = !allowChildren;
            this.add(new MyTreeNode("Loading...", false));
            this.setAllowsChildren(allowChildren);
            this.setUserObject(dir);
            this.bar = new JProgressBar();
        }

        public MyTreeNode(Object userObject, boolean allowsChildren) {
            super(new DefaultMutableTreeNode(userObject, allowsChildren));
            this.isLeaf = !allowsChildren;
            this.index = 0;
        }

        public MyTreeNode(int index, int depth, String dir, String endpoint, Map fileDetails, boolean allowChildren) {
            this.index = index;
            this.depth = depth;
            this.endpoint = endpoint;
            this.fileDetails = fileDetails;
            this.isLeaf = !allowChildren;
            this.add(new MyTreeNode("Loading...", false));
            this.setAllowsChildren(allowChildren);
            this.setUserObject(dir);
            this.bar = new JProgressBar();
        }

        private void setChildren(List<DefaultMutableTreeNode> children) {
            this.removeAllChildren();
            this.setAllowsChildren(children.size() > 0);
            for (MutableTreeNode mutableTreeNode : children) {
                this.add(mutableTreeNode);
            }
            this.loaded = true;
        }

        public String getNodeName() {
            String name = "";
            TreePath path = new TreePath(this.getPath());
            name = name + path.getLastPathComponent();
            return name;
        }

        public String getFullPath() {
            String fullPath = "";
            TreePath path = new TreePath(this.getPath());
            for (int i = 0; i < path.getPathCount(); ++i) {
                if (i != 0) {
                    fullPath = fullPath + "/";
                }
                fullPath = fullPath + path.getPathComponent(i);
            }
            return fullPath;
        }

        public Map getNodeFileDetails() {
            return this.fileDetails;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public boolean isLeaf() {
            return this.isLeaf;
        }

        public void loadChildren(final DefaultTreeModel model, final String endpoint, final String dir) {
            if (this.loaded) {
                return;
            }
            SwingWorker<List<DefaultMutableTreeNode>, Void> worker = new SwingWorker<List<DefaultMutableTreeNode>, Void>(){

                @Override
                protected List<DefaultMutableTreeNode> doInBackground() throws Exception {
                    this.setProgress(0);
                    ArrayList<DefaultMutableTreeNode> children = new ArrayList<DefaultMutableTreeNode>();
                    List<Map> allDir = GOHelper.displayLs(endpoint, dir);
                    for (int i = 0; i < allDir.size(); ++i) {
                        HashMap<String, String> filedetails = new HashMap<String, String>();
                        filedetails.put("size", allDir.get(i).get("size").toString());
                        filedetails.put("group", allDir.get(i).get("group").toString());
                        filedetails.put("last_modified", allDir.get(i).get("last_modified").toString());
                        filedetails.put("permissions", allDir.get(i).get("permissions").toString());
                        filedetails.put("type", allDir.get(i).get("type").toString());
                        filedetails.put("user", allDir.get(i).get("user").toString());
                        filedetails.put("link_target", allDir.get(i).get("link_target").toString());
                        if (allDir.get(i).get("type").toString().equals("dir")) {
                            children.add(new MyTreeNode(i + 1, MyTreeNode.this.depth + 1, allDir.get(i).get("name").toString(), endpoint, filedetails, true));
                        } else {
                            children.add(new MyTreeNode(i + 1, MyTreeNode.this.depth + 1, allDir.get(i).get("name").toString(), endpoint, filedetails, false));
                        }
                        this.setProgress((i + 1) * (100 / allDir.size()));
                    }
                    this.setProgress(0);
                    return children;
                }

                @Override
                protected void done() {
                    try {
                        MyTreeNode.this.setChildren((List)this.get());
                        model.nodeStructureChanged(MyTreeNode.this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    super.done();
                }
            };
            if (this.progressListener != null) {
                worker.getPropertyChangeSupport().addPropertyChangeListener("progress", this.progressListener);
            }
            worker.execute();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.bar.setValue((Integer)evt.getNewValue());
        }

        public void setLoaded(boolean loaded) {
            this.loaded = loaded;
        }

        public boolean isLoaded() {
            return this.loaded;
        }

        public boolean isUncertain() {
            return this.isUncertain;
        }

        public void setUncertain(boolean isUncertain) {
            this.isUncertain = isUncertain;
        }
    }
}

