/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.NumericTextField;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.ui.XTextField;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClientFactory;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.GSIConstants;

public class SshToolsConnectionHostTab
extends JPanel
implements SshToolsConnectionTab {
    public static final int DEFAULT_PORT = 2222;
    public static final String CONNECT_ICON = "largeserveridentity.png";
    public static final String AUTH_ICON = "largelock.png";
    public static final String SHOW_AVAILABLE = "<Show available methods>";
    protected XTextField jTextHostname = new XTextField();
    protected NumericTextField jTextPort = new NumericTextField(new Integer(0), new Integer(65535), new Integer(2222));
    protected XTextField jTextUsername = new XTextField();
    protected JList jListAuths = new JList();
    protected List methods = new ArrayList();
    protected SshToolsConnectionProfile profile;
    protected JCheckBox allowAgentForwarding;
    protected JComboBox delegationOption;
    protected JComboBox proxyOption;
    protected NumericTextField proxyLength = new NumericTextField(new Integer(1), new Integer(240), new Integer(12));
    protected JCheckBox proxySave;
    protected JCheckBox vomsSupport;
    protected Log log = LogFactory.getLog(SshToolsConnectionHostTab.class);

    public SshToolsConnectionHostTab() {
        JPanel mainConnectionDetailsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 2, 2, 2);
        gbc.weightx = 1.0;
        UIUtil.jGridBagAdd(mainConnectionDetailsPanel, new JLabel("Hostname"), gbc, 0);
        gbc.fill = 2;
        UIUtil.jGridBagAdd(mainConnectionDetailsPanel, this.jTextHostname, gbc, 0);
        gbc.fill = 0;
        UIUtil.jGridBagAdd(mainConnectionDetailsPanel, new JLabel("Port"), gbc, 0);
        UIUtil.jGridBagAdd(mainConnectionDetailsPanel, this.jTextPort, gbc, 0);
        UIUtil.jGridBagAdd(mainConnectionDetailsPanel, new JLabel("Username"), gbc, 0);
        gbc.fill = 2;
        gbc.weighty = 1.0;
        UIUtil.jGridBagAdd(mainConnectionDetailsPanel, this.jTextUsername, gbc, 0);
        gbc.fill = 0;
        IconWrapperPanel iconMainConnectionDetailsPanel = new IconWrapperPanel(new ResourceIcon(SshToolsConnectionHostTab.class, CONNECT_ICON), mainConnectionDetailsPanel);
        JPanel authMethodsPanel = new JPanel(new GridBagLayout());
        authMethodsPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.fill = 2;
        gbc2.anchor = 18;
        gbc2.insets = new Insets(2, 2, 2, 2);
        gbc2.weightx = 1.0;
        gbc2.weighty = 0.0;
        gbc2.gridx = 0;
        gbc2.gridy = 1;
        gbc2.gridwidth = 2;
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.fill = 2;
        gbc3.anchor = 18;
        gbc3.insets = new Insets(2, 2, 2, 2);
        gbc3.weightx = 1.0;
        gbc3.weighty = 0.0;
        gbc3.gridx = 0;
        gbc3.gridy = 2;
        gbc3.gridwidth = 2;
        GridBagConstraints gbc4 = new GridBagConstraints();
        gbc4.fill = 2;
        gbc4.anchor = 18;
        gbc4.insets = new Insets(26, 2, 2, 2);
        gbc4.weightx = 0.0;
        gbc4.weighty = 0.0;
        gbc4.gridx = 0;
        gbc4.gridy = 3;
        gbc4.gridwidth = 1;
        GridBagConstraints gbc5 = new GridBagConstraints();
        gbc5.fill = 0;
        gbc5.anchor = 17;
        gbc5.insets = new Insets(26, 2, 2, 2);
        gbc5.weightx = 1.0;
        gbc5.weighty = 0.0;
        gbc5.gridx = 1;
        gbc5.gridy = 3;
        gbc5.gridwidth = 1;
        GridBagConstraints gbc6 = new GridBagConstraints();
        gbc6.fill = 2;
        gbc6.anchor = 18;
        gbc6.insets = new Insets(12, 2, 2, 2);
        gbc6.weightx = 0.0;
        gbc6.weighty = 0.0;
        gbc6.gridx = 0;
        gbc6.gridy = 4;
        gbc6.gridwidth = 1;
        GridBagConstraints gbc7 = new GridBagConstraints();
        gbc7.fill = 0;
        gbc7.anchor = 17;
        gbc7.insets = new Insets(12, 2, 2, 2);
        gbc7.weightx = 1.0;
        gbc7.weighty = 0.0;
        gbc7.gridx = 1;
        gbc7.gridy = 4;
        gbc7.gridwidth = 1;
        GridBagConstraints gbc8 = new GridBagConstraints();
        gbc8.fill = 2;
        gbc8.anchor = 18;
        gbc8.insets = new Insets(12, 2, 2, 2);
        gbc8.weightx = 0.0;
        gbc8.weighty = 0.0;
        gbc8.gridx = 0;
        gbc8.gridy = 5;
        gbc8.gridwidth = 1;
        GridBagConstraints gbc9 = new GridBagConstraints();
        gbc9.fill = 0;
        gbc9.anchor = 17;
        gbc9.insets = new Insets(12, 2, 2, 2);
        gbc9.weightx = 1.0;
        gbc9.weighty = 0.0;
        gbc9.gridx = 1;
        gbc9.gridy = 5;
        gbc9.gridwidth = 1;
        GridBagConstraints gbc10 = new GridBagConstraints();
        gbc10.fill = 2;
        gbc10.anchor = 18;
        gbc10.insets = new Insets(26, 2, 2, 2);
        gbc10.weightx = 1.0;
        gbc10.weighty = 0.0;
        gbc10.gridx = 0;
        gbc10.gridy = 6;
        gbc10.gridwidth = 2;
        GridBagConstraints gbc11 = new GridBagConstraints();
        gbc11.fill = 2;
        gbc11.anchor = 18;
        gbc11.insets = new Insets(26, 2, 2, 2);
        gbc11.weightx = 1.0;
        gbc11.weighty = 0.0;
        gbc11.gridx = 0;
        gbc11.gridy = 7;
        gbc11.gridwidth = 2;
        authMethodsPanel.add((Component)new JLabel("Authentication Methods"), gbc);
        this.jListAuths.setVisibleRowCount(5);
        authMethodsPanel.add((Component)new JScrollPane(this.jListAuths), gbc2);
        this.allowAgentForwarding = new JCheckBox("Allow agent forwarding");
        authMethodsPanel.add((Component)this.allowAgentForwarding, gbc3);
        String[] options = new String[]{"Full", "Limited", "None"};
        this.delegationOption = new JComboBox<String>(options);
        this.delegationOption.setSelectedIndex(0);
        authMethodsPanel.add((Component)new JLabel("Delegation Type:"), gbc4);
        authMethodsPanel.add((Component)this.delegationOption, gbc5);
        String[] optionsP = new String[]{"Pre-RFC Impersonation", "RFC Impersonation", "Legacy"};
        this.proxyOption = new JComboBox<String>(optionsP);
        this.proxyOption.setSelectedIndex(0);
        authMethodsPanel.add((Component)new JLabel("Proxy Type:"), gbc6);
        authMethodsPanel.add((Component)this.proxyOption, gbc7);
        authMethodsPanel.add((Component)new JLabel("Proxy Lifetime (hours):"), gbc8);
        this.proxyLength.setColumns(5);
        authMethodsPanel.add((Component)this.proxyLength, gbc9);
        gbc.gridx = 0;
        this.proxySave = new JCheckBox("Save Grid Proxies to Disk");
        authMethodsPanel.add((Component)this.proxySave, gbc10);
        this.vomsSupport = new JCheckBox("Enable VOMS Support");
        authMethodsPanel.add((Component)this.vomsSupport, gbc11);
        IconWrapperPanel iconAuthMethodsPanel = new IconWrapperPanel(new ResourceIcon(SshToolsConnectionHostTab.class, AUTH_ICON), authMethodsPanel);
        JPanel mine = new JPanel();
        mine.setLayout(new GridBagLayout());
        mine.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        mine.add((Component)iconMainConnectionDetailsPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(20, 2, 2, 2);
        mine.add((Component)iconAuthMethodsPanel, gbc);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add((Component)mine, "North");
        this.addAuthenticationMethods();
    }

    @Override
    public void setConnectionProfile(SshToolsConnectionProfile profile) {
        this.profile = profile;
        this.jTextHostname.setText(profile == null ? "" : profile.getHost());
        this.jTextUsername.setText(profile == null ? "" : profile.getUsername());
        int port = PreferencesStore.getInt("apps.connection.lastPort", 2222);
        port = profile.getApplicationPropertyInt("apps.connection.lastPort", port);
        this.jTextPort.setValue(port);
        if (System.getProperty("sshtools.agent") == null) {
            this.allowAgentForwarding.setSelected(false);
            this.allowAgentForwarding.setEnabled(false);
        } else {
            this.allowAgentForwarding.setEnabled(true);
            this.allowAgentForwarding.setSelected(profile != null && profile.getAllowAgentForwarding());
        }
        String cur = PreferencesStore.get("sshterm.proxyType", Integer.toString(GSIConstants.CertificateType.GSI_4_IMPERSONATION_PROXY.getCode()));
        cur = profile.getApplicationProperty("sshterm.proxyType", cur);
        if (cur.equals(Integer.toString(GSIConstants.CertificateType.GSI_2_PROXY.getCode())) || cur.equals("prerfc")) {
            this.proxyOption.setSelectedIndex(0);
        } else if (cur.equals(Integer.toString(GSIConstants.CertificateType.GSI_4_IMPERSONATION_PROXY.getCode())) || cur.equals("rfc")) {
            this.proxyOption.setSelectedIndex(1);
        }
        if (cur.equals(Integer.toString(GSIConstants.CertificateType.GSI_2_PROXY.getCode())) || cur.equals("legacy")) {
            this.proxyOption.setSelectedIndex(2);
        }
        cur = PreferencesStore.get("sshterm.delegationType", "full");
        if ((cur = profile.getApplicationProperty("sshterm.delegationType", cur)).equals("full")) {
            this.delegationOption.setSelectedIndex(0);
        } else if (cur.equals("limited")) {
            this.delegationOption.setSelectedIndex(1);
        } else if (cur.equals("none")) {
            this.delegationOption.setSelectedIndex(2);
        }
        cur = PreferencesStore.get("sshterm.proxyLength", "12");
        cur = profile.getApplicationProperty("sshterm.proxyLength", cur);
        Integer t = new Integer(12);
        try {
            Integer tt = Integer.parseInt(cur);
            if (tt <= 240 && tt >= 1) {
                t = tt;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.proxyLength.setValue(t);
        boolean saveProxy = PreferencesStore.getBoolean("sshterm.proxy.save", false);
        saveProxy = profile.getApplicationPropertyBoolean("sshterm.proxy.save", saveProxy);
        this.proxySave.setSelected(saveProxy);
        boolean supportVOMS = PreferencesStore.getBoolean("sshterm.voms.support", false);
        supportVOMS = profile.getApplicationPropertyBoolean("sshterm.voms.support", supportVOMS);
        this.vomsSupport.setSelected(supportVOMS);
        Map auths = profile == null ? new HashMap() : profile.getAuthenticationMethods();
        Iterator it = auths.entrySet().iterator();
        int[] selectionarray = new int[auths.values().size()];
        int count = 0;
        ListModel model = this.jListAuths.getModel();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String authmethod = (String)entry.getKey();
            for (int i = 0; i < model.getSize(); ++i) {
                if (!model.getElementAt(i).equals(authmethod)) continue;
                selectionarray[count++] = i;
                break;
            }
            this.jListAuths.clearSelection();
            this.jListAuths.setSelectedIndices(selectionarray);
        }
    }

    @Override
    public SshToolsConnectionProfile getConnectionProfile() {
        return this.profile;
    }

    private void addAuthenticationMethods() {
        ArrayList<String> methods = new ArrayList<String>();
        methods.add(SHOW_AVAILABLE);
        methods.addAll(SshAuthenticationClientFactory.getSupportedMethods());
        this.jListAuths.setListData(methods.toArray());
        this.jListAuths.setSelectedIndex(2);
    }

    @Override
    public String getTabContext() {
        return "Connection";
    }

    @Override
    public Icon getTabIcon() {
        return null;
    }

    @Override
    public String getTabTitle() {
        return "Host";
    }

    @Override
    public String getTabToolTipText() {
        return "The main host connection details.";
    }

    @Override
    public int getTabMnemonic() {
        return 104;
    }

    @Override
    public Component getTabComponent() {
        return this;
    }

    @Override
    public boolean validateTab() {
        if (this.jTextHostname.getText().equals("") || this.jTextPort.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Please enter all details!", "Connect", 0);
            return false;
        }
        List chosen = this.getChosenAuth();
        if (chosen != null) {
            for (String method : chosen) {
                try {
                    SshAuthenticationClient auth = SshAuthenticationClientFactory.newInstance(method, this.profile);
                }
                catch (AlgorithmNotSupportedException anse) {
                    JOptionPane.showMessageDialog(this, method + " is not supported!");
                    return false;
                }
            }
        }
        return true;
    }

    private List getChosenAuth() {
        Object[] auths = this.jListAuths.getSelectedValues();
        ArrayList<String> l = new ArrayList<String>();
        if (auths != null) {
            for (int i = 0; i < auths.length; ++i) {
                String a = (String)auths[i];
                if (a.equals(SHOW_AVAILABLE)) {
                    return null;
                }
                l.add(a);
            }
        } else {
            return null;
        }
        return l;
    }

    @Override
    public void applyTab() {
        this.profile.setHost(this.jTextHostname.getText());
        this.profile.setPort(Integer.valueOf(this.jTextPort.getText()));
        this.profile.setUsername(this.jTextUsername.getText());
        this.profile.setAllowAgentForwarding(this.allowAgentForwarding.getModel().isSelected());
        this.profile.setApplicationProperty("sshterm.delegationType", ((String)this.delegationOption.getSelectedItem()).toLowerCase());
        String proxy = Integer.toString(14);
        switch (this.proxyOption.getSelectedIndex()) {
            case 0: {
                proxy = Integer.toString(14);
                break;
            }
            case 1: {
                proxy = Integer.toString(18);
                break;
            }
            case 2: {
                proxy = Integer.toString(10);
            }
        }
        this.profile.setApplicationProperty("sshterm.proxyType", proxy);
        proxy = this.proxyLength.getText();
        this.profile.setApplicationProperty("sshterm.proxyLength", proxy);
        this.profile.setApplicationProperty("sshterm.proxy.save", this.proxySave.isSelected());
        this.profile.setApplicationProperty("sshterm.voms.support", this.vomsSupport.isSelected());
        List chosen = this.getChosenAuth();
        this.profile.removeAuthenticationMethods();
        if (chosen != null) {
            for (String method : chosen) {
                try {
                    SshAuthenticationClient auth = SshAuthenticationClientFactory.newInstance(method, this.profile);
                    auth.setUsername(this.jTextUsername.getText());
                    this.profile.addAuthenticationMethod(auth);
                }
                catch (AlgorithmNotSupportedException anse) {
                    this.log.error("This should have been caught by validateTab()?", anse);
                }
            }
        }
    }

    @Override
    public void tabSelected() {
    }
}

