/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelDataWindow;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.connection.ChannelFactory;
import com.sshtools.j2ssh.connection.ChannelState;
import com.sshtools.j2ssh.connection.GlobalRequestHandler;
import com.sshtools.j2ssh.connection.GlobalRequestResponse;
import com.sshtools.j2ssh.connection.InvalidChannelException;
import com.sshtools.j2ssh.connection.SshMsgChannelClose;
import com.sshtools.j2ssh.connection.SshMsgChannelData;
import com.sshtools.j2ssh.connection.SshMsgChannelEOF;
import com.sshtools.j2ssh.connection.SshMsgChannelExtendedData;
import com.sshtools.j2ssh.connection.SshMsgChannelFailure;
import com.sshtools.j2ssh.connection.SshMsgChannelOpen;
import com.sshtools.j2ssh.connection.SshMsgChannelOpenConfirmation;
import com.sshtools.j2ssh.connection.SshMsgChannelOpenFailure;
import com.sshtools.j2ssh.connection.SshMsgChannelRequest;
import com.sshtools.j2ssh.connection.SshMsgChannelSuccess;
import com.sshtools.j2ssh.connection.SshMsgChannelWindowAdjust;
import com.sshtools.j2ssh.connection.SshMsgGlobalRequest;
import com.sshtools.j2ssh.connection.SshMsgRequestFailure;
import com.sshtools.j2ssh.connection.SshMsgRequestSuccess;
import com.sshtools.j2ssh.transport.AsyncService;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionProtocol
extends AsyncService {
    private static Log log = LogFactory.getLog(ConnectionProtocol.class);
    private HashSet reusableChannels = new HashSet();
    private Map activeChannels = new HashMap();
    private Map allowedChannels = new HashMap();
    private Map globalRequests = new HashMap();
    private long nextChannelId = 0L;
    private Map unopenedChannels = new HashMap();

    public ConnectionProtocol() {
        super("ssh-connection");
    }

    public void addChannelFactory(String channelName, ChannelFactory cf) throws IOException {
        this.allowedChannels.put(channelName, cf);
    }

    public void removeChannelFactory(String channelName) {
        this.allowedChannels.remove(channelName);
    }

    public boolean containsChannelFactory(String channelName) {
        return this.allowedChannels.containsKey(channelName);
    }

    public void allowGlobalRequest(String requestName, GlobalRequestHandler handler) {
        this.globalRequests.put(requestName, handler);
    }

    @Override
    public void onStart() {
    }

    public boolean openChannel(Channel channel) throws IOException {
        return this.openChannel(channel, null);
    }

    public boolean isConnected() {
        return (this.transport.getState().getValue() == 4 || this.transport.getState().getValue() == 3) && this.getState().getValue() == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getChannelId() {
        Map map = this.activeChannels;
        synchronized (map) {
            if (this.reusableChannels.size() <= 0) {
                return new Long(this.nextChannelId++);
            }
            return (Long)this.reusableChannels.iterator().next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMsgChannelOpenConfirmation(SshMsgChannelOpenConfirmation conf) {
        UnopenedChannel uoc = null;
        Long id = new Long(conf.getRecipientChannel());
        Map map = this.unopenedChannels;
        synchronized (map) {
            uoc = (UnopenedChannel)this.unopenedChannels.get(id);
        }
        if (uoc == null) {
            log.warn("SshMessageChannelOpenConfirmation recieved for unknown channel: dropping");
        } else {
            uoc.completeConnection(conf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMsgChannelOpenFailure(SshMsgChannelOpenFailure fail) {
        UnopenedChannel uoc = null;
        Long id = new Long(fail.getRecipientChannel());
        Map map = this.unopenedChannels;
        synchronized (map) {
            uoc = (UnopenedChannel)this.unopenedChannels.get(id);
        }
        if (uoc == null) {
            log.warn("SshMessageChannelOpenFailure recieved for unknown channel: dropping");
        } else {
            uoc.connectionFailure(fail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openChannel(Channel channel, ChannelEventListener eventListener) throws IOException {
        UnopenedChannel uoc = null;
        Map map = this.unopenedChannels;
        synchronized (map) {
            Long channelId = this.getChannelId();
            SshMsgChannelOpen msg = new SshMsgChannelOpen(channel.getChannelType(), channelId, channel.getLocalWindow().getWindowSpace(), channel.getLocalPacketSize(), channel.getChannelOpenData());
            this.transport.sendMessage(msg, this);
            uoc = new UnopenedChannel(channelId, channel, eventListener);
            this.unopenedChannels.put(channelId, uoc);
        }
        try {
            boolean b = uoc.tail();
            log.info("Channel opened successfully.");
            return b;
        }
        catch (InterruptedException e) {
            throw new SshException("The thread was interrupted whilst waiting for a connection protocol message");
        }
    }

    @Override
    protected void onStop() {
        log.info("Closing all active channels");
        try {
            for (Channel channel : this.activeChannels.values()) {
                if (channel == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Closing " + channel.getName() + " id=" + String.valueOf(channel.getLocalChannelId()));
                }
                channel.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.activeChannels.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendChannelData(Channel channel, byte[] data) throws IOException {
        ChannelState channelState = channel.getState();
        synchronized (channelState) {
            int block;
            if (log.isDebugEnabled()) {
                log.debug("Sending " + String.valueOf(data.length) + " bytes for channel id " + String.valueOf(channel.getLocalChannelId()));
            }
            ChannelDataWindow window = channel.getRemoteWindow();
            for (int sent = 0; sent < data.length; sent += block) {
                int remaining = data.length - sent;
                long max = window.getWindowSpace() < channel.getRemotePacketSize() && window.getWindowSpace() > 0L ? window.getWindowSpace() : channel.getRemotePacketSize();
                block = max < (long)remaining ? (int)max : remaining;
                channel.remoteWindow.consumeWindowSpace(block);
                byte[] buffer = new byte[block];
                System.arraycopy(data, sent, buffer, 0, block);
                SshMsgChannelData msg = new SshMsgChannelData(channel.getRemoteChannelId(), buffer);
                this.transport.sendMessage(msg, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendChannelEOF(Channel channel) throws IOException {
        Map map = this.activeChannels;
        synchronized (map) {
            if (!this.activeChannels.containsValue(channel)) {
                throw new IOException("Attempt to send EOF for a non existent channel " + String.valueOf(channel.getLocalChannelId()));
            }
            log.info("Local computer has set channel " + String.valueOf(channel.getLocalChannelId()) + " to EOF [" + channel.getName() + "]");
            SshMsgChannelEOF msg = new SshMsgChannelEOF(channel.getRemoteChannelId());
            this.transport.sendMessage(msg, this);
        }
    }

    public synchronized void sendChannelExtData(Channel channel, int extendedType, byte[] data) throws IOException {
        int block;
        channel.getRemoteWindow().consumeWindowSpace(data.length);
        ChannelDataWindow window = channel.getRemoteWindow();
        for (int sent = 0; sent < data.length; sent += block) {
            int remaining = data.length - sent;
            long max = window.getWindowSpace() < channel.getRemotePacketSize() && window.getWindowSpace() > 0L ? window.getWindowSpace() : channel.getRemotePacketSize();
            block = max < (long)remaining ? (int)max : remaining;
            channel.remoteWindow.consumeWindowSpace(block);
            byte[] buffer = new byte[block];
            System.arraycopy(data, sent, buffer, 0, block);
            SshMsgChannelExtendedData msg = new SshMsgChannelExtendedData(channel.getRemoteChannelId(), extendedType, buffer);
            this.transport.sendMessage(msg, this);
        }
    }

    public synchronized boolean sendChannelRequest(Channel channel, String requestType, boolean wantReply, byte[] requestData) throws IOException {
        boolean success = true;
        log.debug("Sending " + requestType + " request for the " + channel.getChannelType() + " channel");
        SshMsgChannelRequest msg = new SshMsgChannelRequest(channel.getRemoteChannelId(), requestType, wantReply, requestData);
        this.transport.sendMessage(msg, this);
        if (wantReply) {
            int[] messageIdFilter = new int[]{99, 100};
            log.debug("Waiting for channel request reply");
            try {
                SshMessage reply = this.transport.getMessageStore().getMessage(messageIdFilter);
                switch (reply.getMessageId()) {
                    case 99: {
                        log.debug("Channel request succeeded");
                        success = true;
                        break;
                    }
                    case 100: {
                        log.debug("Channel request failed");
                        success = false;
                    }
                }
            }
            catch (InterruptedException ex) {
                throw new SshException("The thread was interrupted whilst waiting for a connection protocol message");
            }
        }
        return success;
    }

    public void sendChannelRequestFailure(Channel channel) throws IOException {
        SshMsgChannelFailure msg = new SshMsgChannelFailure(channel.getRemoteChannelId());
        this.transport.sendMessage(msg, this);
    }

    public void sendChannelRequestSuccess(Channel channel) throws IOException {
        SshMsgChannelSuccess msg = new SshMsgChannelSuccess(channel.getRemoteChannelId());
        this.transport.sendMessage(msg, this);
    }

    public void sendChannelWindowAdjust(Channel channel, long bytesToAdd) throws IOException {
        log.debug("Increasing window size by " + String.valueOf(bytesToAdd) + " bytes");
        SshMsgChannelWindowAdjust msg = new SshMsgChannelWindowAdjust(channel.getRemoteChannelId(), bytesToAdd);
        this.transport.sendMessage(msg, this);
    }

    public synchronized byte[] sendGlobalRequest(String requestName, boolean wantReply, byte[] requestData) throws IOException {
        boolean success = true;
        SshMsgGlobalRequest msg = new SshMsgGlobalRequest(requestName, true, requestData);
        this.transport.sendMessage(msg, this);
        if (wantReply) {
            int[] messageIdFilter = new int[]{81, 82};
            log.debug("Waiting for global request reply");
            try {
                SshMessage reply = this.transport.getMessageStore().getMessage(messageIdFilter);
                switch (reply.getMessageId()) {
                    case 81: {
                        log.debug("Global request succeeded");
                        return ((SshMsgRequestSuccess)reply).getRequestData();
                    }
                    case 82: {
                        log.debug("Global request failed");
                        throw new SshException("The request failed");
                    }
                }
            }
            catch (InterruptedException ex) {
                throw new SshException("The thread was interrupted whilst waiting for a connection protocol message");
            }
        }
        return null;
    }

    protected void closeChannel(Channel channel) throws IOException {
        SshMsgChannelClose msg = new SshMsgChannelClose(channel.getRemoteChannelId());
        log.info("Local computer has closed channel " + String.valueOf(channel.getLocalChannelId()) + "[" + channel.getName() + "]");
        this.transport.sendMessage(msg, this);
    }

    protected void onGlobalRequest(String requestName, boolean wantReply, byte[] requestData) throws IOException {
        log.debug("Processing " + requestName + " global request");
        if (!this.globalRequests.containsKey(requestName)) {
            this.sendGlobalRequestFailure();
        } else {
            GlobalRequestHandler handler = (GlobalRequestHandler)this.globalRequests.get(requestName);
            GlobalRequestResponse response = handler.processGlobalRequest(requestName, requestData);
            if (wantReply) {
                if (response.hasSucceeded()) {
                    this.sendGlobalRequestSuccess(response.getResponseData());
                } else {
                    this.sendGlobalRequestFailure();
                }
            }
        }
    }

    @Override
    public void onMessageReceived(SshMessage msg) throws IOException {
        switch (msg.getMessageId()) {
            case 80: {
                this.onMsgGlobalRequest((SshMsgGlobalRequest)msg);
                break;
            }
            case 90: {
                this.onMsgChannelOpen((SshMsgChannelOpen)msg);
                break;
            }
            case 97: {
                this.onMsgChannelClose((SshMsgChannelClose)msg);
                break;
            }
            case 96: {
                this.onMsgChannelEOF((SshMsgChannelEOF)msg);
                break;
            }
            case 94: {
                this.onMsgChannelData((SshMsgChannelData)msg);
                break;
            }
            case 95: {
                this.onMsgChannelExtendedData((SshMsgChannelExtendedData)msg);
                break;
            }
            case 98: {
                this.onMsgChannelRequest((SshMsgChannelRequest)msg);
                break;
            }
            case 93: {
                this.onMsgChannelWindowAdjust((SshMsgChannelWindowAdjust)msg);
                break;
            }
            case 91: {
                this.onMsgChannelOpenConfirmation((SshMsgChannelOpenConfirmation)msg);
                break;
            }
            case 92: {
                this.onMsgChannelOpenFailure((SshMsgChannelOpenFailure)msg);
                break;
            }
            default: {
                log.debug("Message not handled");
                throw new IOException("Unregistered message received!");
            }
        }
    }

    @Override
    protected void onServiceAccept() {
    }

    @Override
    protected void onServiceInit(int startMode) throws IOException {
        log.info("Registering connection protocol messages");
        this.transport.getMessageStore().registerMessage(91, SshMsgChannelOpenConfirmation.class, this);
        this.transport.getMessageStore().registerMessage(92, SshMsgChannelOpenFailure.class, this);
        this.transport.getMessageStore().registerMessage(90, SshMsgChannelOpen.class, this);
        this.transport.getMessageStore().registerMessage(97, SshMsgChannelClose.class, this);
        this.transport.getMessageStore().registerMessage(96, SshMsgChannelEOF.class, this);
        this.transport.getMessageStore().registerMessage(94, SshMsgChannelData.class, this);
        this.transport.getMessageStore().registerMessage(95, SshMsgChannelExtendedData.class, this);
        this.transport.getMessageStore().registerMessage(100, SshMsgChannelFailure.class);
        this.transport.getMessageStore().registerMessage(98, SshMsgChannelRequest.class, this);
        this.transport.getMessageStore().registerMessage(99, SshMsgChannelSuccess.class);
        this.transport.getMessageStore().registerMessage(93, SshMsgChannelWindowAdjust.class, this);
        this.transport.getMessageStore().registerMessage(80, SshMsgGlobalRequest.class, this);
        this.transport.getMessageStore().registerMessage(82, SshMsgRequestFailure.class);
        this.transport.getMessageStore().registerMessage(81, SshMsgRequestSuccess.class);
    }

    @Override
    protected void onServiceRequest() {
    }

    protected void sendChannelFailure(Channel channel) throws IOException {
        SshMsgChannelFailure msg = new SshMsgChannelFailure(channel.getRemoteChannelId());
        this.transport.sendMessage(msg, this);
    }

    protected void sendChannelOpenConfirmation(Channel channel) throws IOException {
        SshMsgChannelOpenConfirmation msg = new SshMsgChannelOpenConfirmation(channel.getRemoteChannelId(), channel.getLocalChannelId(), channel.getLocalWindow().getWindowSpace(), channel.getLocalPacketSize(), channel.getChannelConfirmationData());
        this.transport.sendMessage(msg, this);
    }

    protected void sendChannelOpenFailure(long remoteChannelId, long reasonCode, String additionalInfo, String languageTag) throws IOException {
        SshMsgChannelOpenFailure msg = new SshMsgChannelOpenFailure(remoteChannelId, reasonCode, additionalInfo, languageTag);
        this.transport.sendMessage(msg, this);
    }

    protected void sendGlobalRequestFailure() throws IOException {
        SshMsgRequestFailure msg = new SshMsgRequestFailure();
        this.transport.sendMessage(msg, this);
    }

    protected void sendGlobalRequestSuccess(byte[] requestData) throws IOException {
        SshMsgRequestSuccess msg = new SshMsgRequestSuccess(requestData);
        this.transport.sendMessage(msg, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel getChannel(long channelId) throws IOException {
        Map map = this.activeChannels;
        synchronized (map) {
            Long l = new Long(channelId);
            if (!this.activeChannels.containsKey(l)) {
                throw new IOException("Non existent channel " + l.toString() + " requested");
            }
            return (Channel)this.activeChannels.get(l);
        }
    }

    private void onMsgChannelClose(SshMsgChannelClose msg) throws IOException {
        Channel channel = this.getChannel(msg.getRecipientChannel());
        if (channel == null) {
            throw new IOException("Remote computer tried to close a non existent channel " + String.valueOf(msg.getRecipientChannel()));
        }
        log.info("Remote computer has closed channel " + String.valueOf(channel.getLocalChannelId()) + "[" + channel.getName() + "]");
        if (channel.getState().getValue() != 3) {
            channel.remoteClose();
        }
    }

    private void onMsgChannelData(SshMsgChannelData msg) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Received " + String.valueOf(msg.getChannelData().length) + " bytes of data for channel id " + String.valueOf(msg.getRecipientChannel()));
        }
        Channel channel = this.getChannel(msg.getRecipientChannel());
        channel.processChannelData(msg);
    }

    private void onMsgChannelEOF(SshMsgChannelEOF msg) throws IOException {
        Channel channel = this.getChannel(msg.getRecipientChannel());
        try {
            log.info("Remote computer has set channel " + String.valueOf(msg.getRecipientChannel()) + " to EOF [" + channel.getName() + "]");
            channel.setRemoteEOF();
        }
        catch (IOException ioe) {
            log.info("Failed to close the ChannelInputStream after EOF event");
        }
    }

    private void onMsgChannelExtendedData(SshMsgChannelExtendedData msg) throws IOException {
        Channel channel = this.getChannel(msg.getRecipientChannel());
        if (channel == null) {
            throw new IOException("Remote computer sent data for non existent channel");
        }
        channel.getLocalWindow().consumeWindowSpace(msg.getChannelData().length);
        channel.processChannelData(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMsgChannelOpen(SshMsgChannelOpen msg) throws IOException {
        Map map = this.activeChannels;
        synchronized (map) {
            log.info("Request for " + msg.getChannelType() + " channel recieved");
            ChannelFactory cf = (ChannelFactory)this.allowedChannels.get(msg.getChannelType());
            if (cf == null) {
                this.sendChannelOpenFailure(msg.getSenderChannelId(), 2L, "The channel type is not supported", "");
                log.info("Request for channel type " + msg.getChannelType() + " refused");
                return;
            }
            try {
                log.info("Creating channel " + msg.getChannelType());
                Channel channel = cf.createChannel(msg.getChannelType(), msg.getChannelData());
                log.info("Initiating channel");
                Long channelId = this.getChannelId();
                channel.init(this, channelId, msg.getSenderChannelId(), msg.getInitialWindowSize(), msg.getMaximumPacketSize());
                this.activeChannels.put(channelId, channel);
                log.info("Sending channel open confirmation");
                this.sendChannelOpenConfirmation(channel);
                channel.open();
            }
            catch (InvalidChannelException ice) {
                log.debug(ice);
                this.sendChannelOpenFailure(msg.getSenderChannelId(), 2L, ice.getMessage(), "");
            }
        }
    }

    private void onMsgChannelRequest(SshMsgChannelRequest msg) throws IOException {
        Channel channel = this.getChannel(msg.getRecipientChannel());
        if (channel == null) {
            log.warn("Remote computer tried to make a request for a non existence channel!");
        }
        channel.onChannelRequest(msg.getRequestType(), msg.getWantReply(), msg.getChannelData());
    }

    private void onMsgChannelWindowAdjust(SshMsgChannelWindowAdjust msg) throws IOException {
        Channel channel = this.getChannel(msg.getRecipientChannel());
        if (channel == null) {
            throw new IOException("Remote computer tried to increase window space for non existent channel " + String.valueOf(msg.getRecipientChannel()));
        }
        channel.getRemoteWindow().increaseWindowSpace(msg.getBytesToAdd());
        if (log.isDebugEnabled()) {
            log.debug(String.valueOf(msg.getBytesToAdd()) + " bytes added to remote window");
            log.debug("Remote window space is " + String.valueOf(channel.getRemoteWindow().getWindowSpace()));
        }
    }

    private void onMsgGlobalRequest(SshMsgGlobalRequest msg) throws IOException {
        this.onGlobalRequest(msg.getRequestName(), msg.getWantReply(), msg.getRequestData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freeChannel(Channel channel) {
        Map map = this.activeChannels;
        synchronized (map) {
            log.info("Freeing channel " + String.valueOf(channel.getLocalChannelId()) + " [" + channel.getName() + "]");
            Long channelId = new Long(channel.getLocalChannelId());
            this.activeChannels.remove(channelId);
        }
    }

    private class UnopenedChannel {
        private Channel channel;
        private ChannelEventListener eventListener;
        private Long channelId;
        private boolean result = false;
        private boolean done = false;

        public UnopenedChannel(Long channelId, Channel channel, ChannelEventListener eventListener) {
            this.channel = channel;
            this.eventListener = eventListener;
            this.channelId = channelId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completeConnection(SshMsgChannelOpenConfirmation conf) {
            try {
                Map map = ConnectionProtocol.this.activeChannels;
                synchronized (map) {
                    ConnectionProtocol.this.activeChannels.put(this.channelId, this.channel);
                    log.debug("Initiating channel");
                    this.channel.init(ConnectionProtocol.this, this.channelId, conf.getSenderChannel(), conf.getInitialWindowSize(), conf.getMaximumPacketSize(), this.eventListener);
                    this.channel.open();
                    log.info("Channel " + String.valueOf(this.channel.getLocalChannelId()) + " is open [" + this.channel.getName() + "]");
                    this.setResult(true);
                }
            }
            catch (IOException e) {
                log.warn("Problem opening channel: " + e);
                this.setResult(false);
            }
        }

        public void connectionFailure(SshMsgChannelOpenFailure fail) {
            this.channel.getState().setValue(3);
            this.setResult(false);
        }

        private synchronized void setResult(boolean b) {
            this.result = b;
            this.done = true;
            this.notifyAll();
        }

        public synchronized boolean tail() throws InterruptedException {
            while (!this.done) {
                this.wait(2000L);
            }
            return this.result;
        }
    }
}

