/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.forwarding;

import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import com.sshtools.j2ssh.forwarding.ForwardingConfiguration;
import com.sshtools.j2ssh.forwarding.ForwardingConfigurationException;
import com.sshtools.j2ssh.forwarding.ForwardingSocketChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ForwardingListener
extends ForwardingConfiguration
implements Runnable {
    private static Log log = LogFactory.getLog(ForwardingListener.class);
    private ConnectionProtocol connection;
    private ServerSocket server;
    private Thread thread;
    private boolean listening;

    public ForwardingListener(String name, ConnectionProtocol connection, String addressToBind, int portToBind, String hostToConnect, int portToConnect) {
        super(name, addressToBind, portToBind, hostToConnect, portToConnect);
        log.info("Creating forwarding listener named '" + name + "'");
        this.connection = connection;
        if (log.isDebugEnabled()) {
            log.debug("Address to bind: " + this.getAddressToBind());
            log.debug("Port to bind: " + String.valueOf(this.getPortToBind()));
            log.debug("Host to connect: " + hostToConnect);
            log.debug("Port to connect: " + portToConnect);
        }
    }

    public ForwardingListener(ConnectionProtocol connection, String addressToBind, int portToBind) {
        this(addressToBind + ":" + String.valueOf(portToBind), connection, addressToBind, portToBind, "[Specified by connecting computer]", -1);
    }

    public int getLocalPort() {
        return this.server == null ? -1 : this.server.getLocalPort();
    }

    public boolean isListening() {
        return this.listening;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            log.info("Starting forwarding listener thread for '" + this.name + "'");
            while (this.state.getValue() == 1) {
                this.listening = true;
                Socket socket = this.server.accept();
                if (this.state.getValue() == 2) break;
                if (socket == null) {
                    break;
                }
                log.info("Connection accepted, creating forwarding channel");
                try {
                    ForwardingSocketChannel channel = this.createChannel(this.hostToConnect, this.portToConnect, socket);
                    channel.bindSocket(socket);
                    if (this.connection.openChannel(channel)) {
                        log.info("Forwarding channel for '" + this.name + "' is open");
                        continue;
                    }
                    log.warn("Failed to open forwarding chanel " + this.name);
                    socket.close();
                }
                catch (Exception ex) {
                    log.warn("Failed to open forwarding chanel " + this.name, ex);
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (IOException ioe) {
            if (this.state.getValue() == 1) {
                log.warn("Local forwarding listener to " + this.hostToConnect + ":" + String.valueOf(this.portToConnect) + " has failed", ioe);
            }
        }
        finally {
            this.stop();
        }
    }

    public boolean isRunning() {
        return this.thread != null && this.thread.isAlive();
    }

    @Override
    public void start() throws IOException {
        super.start();
        try {
            this.server = new ServerSocket(this.getPortToBind(), 50, InetAddress.getByName(this.getAddressToBind()));
        }
        catch (IOException ioe) {
            super.stop();
            throw ioe;
        }
        this.thread = new SshThread(this, "Forwarding listener", true);
        this.thread = new SshThread(this, "Forwarding listener", true);
        this.thread.start();
    }

    @Override
    public void stop() {
        super.stop();
        try {
            if (this.server != null) {
                this.server.close();
            }
        }
        catch (IOException ioe) {
            log.warn("Forwarding listener failed to stop", ioe);
        }
        this.thread = null;
        this.listening = false;
    }

    protected abstract ForwardingSocketChannel createChannel(String var1, int var2, Socket var3) throws ForwardingConfigurationException;
}

