/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.io.UnsignedInteger64;
import com.sshtools.j2ssh.sftp.MessageRequestId;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import java.io.IOException;

public class SshFxpWrite
extends SubsystemMessage
implements MessageRequestId {
    public static final int SSH_FXP_WRITE = 6;
    private UnsignedInteger32 id;
    private byte[] handle;
    private UnsignedInteger64 offset;
    private byte[] data;

    public SshFxpWrite() {
        super(6);
    }

    public SshFxpWrite(UnsignedInteger32 id, byte[] handle, UnsignedInteger64 offset, byte[] data, int off, int len) {
        super(6);
        this.id = id;
        this.handle = handle;
        this.offset = offset;
        this.data = new byte[len];
        System.arraycopy(data, off, this.data, 0, len);
    }

    @Override
    public UnsignedInteger32 getId() {
        return this.id;
    }

    public byte[] getHandle() {
        return this.handle;
    }

    public UnsignedInteger64 getOffset() {
        return this.offset;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public void constructMessage(ByteArrayReader bar) throws IOException, InvalidMessageException {
        this.id = bar.readUINT32();
        this.handle = bar.readBinaryString();
        this.offset = bar.readUINT64();
        this.data = bar.readBinaryString();
    }

    @Override
    public String getMessageName() {
        return "SSH_FXP_WRITE";
    }

    @Override
    public void constructByteArray(ByteArrayWriter baw) throws IOException, InvalidMessageException {
        baw.writeUINT32(this.id);
        baw.writeBinaryString(this.handle);
        baw.writeUINT64(this.offset);
        baw.writeBinaryString(this.data);
    }
}

