/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import com.sshtools.j2ssh.transport.cipher.SshCipherFactory;
import com.sshtools.j2ssh.transport.compression.SshCompressionFactory;
import com.sshtools.j2ssh.transport.hmac.SshHmacFactory;
import com.sshtools.j2ssh.transport.kex.SshKeyExchangeFactory;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;

public class SshMsgKexInit
extends SshMessage {
    protected static final int SSH_MSG_KEX_INIT = 20;
    private List supportedCompCS;
    private List supportedCompSC;
    private List supportedEncryptCS;
    private List supportedEncryptSC;
    private List supportedKex;
    private List supportedLangCS;
    private List supportedLangSC;
    private List supportedMacCS;
    private List supportedMacSC;
    private List supportedPK;
    private byte[] cookie;
    private boolean firstKexFollows;

    public SshMsgKexInit() {
        super(20);
    }

    public SshMsgKexInit(SshConnectionProperties props) {
        this(props, true);
    }

    public SshMsgKexInit(SshConnectionProperties props, boolean firstExch) {
        super(20);
        this.cookie = new byte[16];
        SecureRandom r = ConfigurationLoader.getRND();
        ((Random)r).nextBytes(this.cookie);
        String pref1 = props.getPrefKex();
        this.supportedKex = SshKeyExchangeFactory.getSupportedKeyExchanges(firstExch);
        this.supportedKex = this.supportedKex.contains(pref1) ? this.sortAlgorithmList(SshKeyExchangeFactory.getSupportedKeyExchanges(firstExch), props.getPrefKex()) : this.sortAlgorithmList(SshKeyExchangeFactory.getSupportedKeyExchanges(firstExch), SshKeyExchangeFactory.getDefaultKeyExchange(firstExch));
        this.supportedPK = this.sortAlgorithmList(SshKeyPairFactory.getSupportedKeys(), props.getPrefPublicKey());
        this.supportedEncryptCS = this.sortAlgorithmList(SshCipherFactory.getSupportedCiphers(), props.getPrefCSEncryption());
        this.supportedEncryptSC = this.sortAlgorithmList(SshCipherFactory.getSupportedCiphers(), props.getPrefSCEncryption());
        this.supportedMacCS = this.sortAlgorithmList(SshHmacFactory.getSupportedMacs(), props.getPrefCSMac());
        this.supportedMacSC = this.sortAlgorithmList(SshHmacFactory.getSupportedMacs(), props.getPrefSCMac());
        this.supportedCompCS = this.sortAlgorithmList(SshCompressionFactory.getSupportedCompression(), props.getPrefCSComp());
        this.supportedCompSC = this.sortAlgorithmList(SshCompressionFactory.getSupportedCompression(), props.getPrefSCComp());
        this.supportedLangCS = new ArrayList();
        this.supportedLangSC = new ArrayList();
        this.firstKexFollows = false;
    }

    @Override
    public String getMessageName() {
        return "SSH_MSG_KEX_INIT";
    }

    public boolean firstPacketFollows() {
        return this.firstKexFollows;
    }

    public List getSupportedCSComp() {
        return this.supportedCompCS;
    }

    public List getSupportedCSEncryption() {
        return this.supportedEncryptCS;
    }

    public List getSupportedCSMac() {
        return this.supportedMacCS;
    }

    public List getSupportedKex() {
        return this.supportedKex;
    }

    public void setSupportedPK(List pks) {
        this.supportedPK.clear();
        this.supportedPK.addAll(pks);
        this.sortAlgorithmList(this.supportedPK, SshKeyPairFactory.getDefaultPublicKey());
    }

    public List getSupportedPublicKeys() {
        return this.supportedPK;
    }

    public List getSupportedSCComp() {
        return this.supportedCompSC;
    }

    public List getSupportedSCEncryption() {
        return this.supportedEncryptSC;
    }

    public List getSupportedSCMac() {
        return this.supportedMacSC;
    }

    public String createDelimString(List list) {
        String sep = "";
        String ret = "";
        Iterator it = list.iterator();
        while (it.hasNext()) {
            ret = ret + sep + (String)it.next();
            sep = ",";
        }
        return ret;
    }

    public String toString() {
        String ret = "SshMsgKexInit:\n";
        ret = ret + "Supported Kex " + this.supportedKex.toString() + "\n";
        ret = ret + "Supported Public Keys " + this.supportedPK.toString() + "\n";
        ret = ret + "Supported Encryption Client->Server " + this.supportedEncryptCS.toString() + "\n";
        ret = ret + "Supported Encryption Server->Client " + this.supportedEncryptSC.toString() + "\n";
        ret = ret + "Supported Mac Client->Server " + this.supportedMacCS.toString() + "\n";
        ret = ret + "Supported Mac Server->Client " + this.supportedMacSC.toString() + "\n";
        ret = ret + "Supported Compression Client->Server " + this.supportedCompCS.toString() + "\n";
        ret = ret + "Supported Compression Server->Client " + this.supportedCompSC.toString() + "\n";
        ret = ret + "Supported Languages Client->Server " + this.supportedLangCS.toString() + "\n";
        ret = ret + "Supported Languages Server->Client " + this.supportedLangSC.toString() + "\n";
        ret = ret + "First Kex Packet Follows [" + (this.firstKexFollows ? "TRUE]" : "FALSE]");
        return ret;
    }

    @Override
    protected void constructByteArray(ByteArrayWriter baw) throws InvalidMessageException {
        try {
            baw.write(this.cookie);
            baw.writeString(this.createDelimString(this.supportedKex));
            baw.writeString(this.createDelimString(this.supportedPK));
            baw.writeString(this.createDelimString(this.supportedEncryptCS));
            baw.writeString(this.createDelimString(this.supportedEncryptSC));
            baw.writeString(this.createDelimString(this.supportedMacCS));
            baw.writeString(this.createDelimString(this.supportedMacSC));
            baw.writeString(this.createDelimString(this.supportedCompCS));
            baw.writeString(this.createDelimString(this.supportedCompSC));
            baw.writeString(this.createDelimString(this.supportedLangCS));
            baw.writeString(this.createDelimString(this.supportedLangSC));
            baw.write(this.firstKexFollows ? 1 : 0);
            baw.writeInt(0);
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Error writing message data: " + ioe.getMessage());
        }
    }

    @Override
    protected void constructMessage(ByteArrayReader bar) throws InvalidMessageException {
        try {
            this.cookie = new byte[16];
            bar.read(this.cookie);
            this.supportedKex = this.loadListFromString(bar.readString());
            this.supportedPK = this.loadListFromString(bar.readString());
            this.supportedEncryptCS = this.loadListFromString(bar.readString());
            this.supportedEncryptSC = this.loadListFromString(bar.readString());
            this.supportedMacCS = this.loadListFromString(bar.readString());
            this.supportedMacSC = this.loadListFromString(bar.readString());
            this.supportedCompCS = this.loadListFromString(bar.readString());
            this.supportedCompSC = this.loadListFromString(bar.readString());
            this.supportedLangCS = this.loadListFromString(bar.readString());
            this.supportedLangSC = this.loadListFromString(bar.readString());
            this.firstKexFollows = bar.read() != 0;
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Error reading message data: " + ioe.getMessage());
        }
    }

    private List loadListFromString(String str) {
        StringTokenizer tok = new StringTokenizer(str, ",");
        ArrayList<Object> ret = new ArrayList<Object>();
        while (tok.hasMoreElements()) {
            ret.add(tok.nextElement());
        }
        return ret;
    }

    private List sortAlgorithmList(List list, String pref) {
        if (list.contains(pref)) {
            list.remove(pref);
            list.add(0, pref);
        }
        return list;
    }
}

