/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.cipher;

import com.sshtools.j2ssh.transport.AlgorithmOperationException;
import com.sshtools.j2ssh.transport.cipher.SshCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;

public class TripleDesCbc
extends SshCipher {
    protected static String algorithmName = "3des-cbc";
    Cipher cipher;

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public void init(int mode, byte[] iv, byte[] keydata) throws AlgorithmOperationException {
        try {
            this.cipher = Cipher.getInstance("DESede/CBC/NoPadding");
            byte[] actualKey = new byte[24];
            System.arraycopy(keydata, 0, actualKey, 0, 24);
            DESedeKeySpec keyspec = new DESedeKeySpec(actualKey);
            SecretKey key = SecretKeyFactory.getInstance("DESede").generateSecret(keyspec);
            this.cipher.init(mode == 0 ? 1 : 2, (Key)key, new IvParameterSpec(iv, 0, this.cipher.getBlockSize()));
        }
        catch (NoSuchPaddingException nspe) {
            throw new AlgorithmOperationException("Padding not supported");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new AlgorithmOperationException("Algorithm not supported");
        }
        catch (InvalidKeyException ike) {
            throw new AlgorithmOperationException("Invalid encryption key");
        }
        catch (InvalidKeySpecException ispe) {
            throw new AlgorithmOperationException("Invalid encryption key specification");
        }
        catch (InvalidAlgorithmParameterException ape) {
            throw new AlgorithmOperationException("Invalid algorithm parameter");
        }
    }

    @Override
    public byte[] transform(byte[] data, int offset, int len) throws AlgorithmOperationException {
        return this.cipher.update(data, offset, len);
    }
}

