/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshterm;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.NumericTextField;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.j2ssh.authentication.ExampleFileFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import uk.ac.rl.esc.browser.Browser;

public class GSIAuthTab
extends JPanel
implements SshToolsConnectionTab,
ActionListener {
    protected SshToolsConnectionProfile profile;
    private JPanel jContentPane = null;
    private JPanel usePanel = null;
    private JList useList = null;
    private JList dontUseList = null;
    private JLabel dontUseLabel = null;
    private JLabel useLabel = null;
    private JButton upButton = null;
    private JButton downButton = null;
    private JButton stopUseButton = null;
    private JButton useButton = null;
    private JPanel mpPanel = null;
    private JLabel myProxyLabel = null;
    private JLabel mpHostLabel = null;
    private JLabel mpPortLabel = null;
    private JLabel mpUsernameLabel = null;
    private JLabel mpVOnameLabel = null;
    private JTextField mpHostTextField = null;
    private JTextField mpPortTextField = null;
    private JTextField mpUsernameTextField = null;
    private JTextField mpVOnameTextField = null;
    private JPanel authsPanel = null;
    private JPanel browserPanel = null;
    private JLabel browserLabel = null;
    private JComboBox bBrowserComboBox = null;
    private JLabel browserBrowserLabel = null;
    private JLabel dNLabel = null;
    private JTextField bDNTextField = null;
    private JPanel pkcs12Panel = null;
    private JLabel pkcs12Label = null;
    private JLabel pkcs12FileLabel = null;
    private JTextField pkcs12FileTextField = null;
    private JButton pkcs12Button = null;
    private String[] ALL_AUTHS = new String[]{"param", "proxy", "other", "cert", "browser", "krb"};
    private String[] AUTHNAMES = new String[]{"Applet Param", "Disk Proxy", "Other Methods", ".pem/usercred.p12", "Browser", "SSO"};
    private String DEFAULT_ORDER = "param,proxy,cert,other";

    public GSIAuthTab() {
        this.add(this.getJContentPane());
        this.setAvailableActions();
    }

    private void setAvailableActions() {
    }

    @Override
    public void applyTab() {
        this.profile.setApplicationProperty("sshterm.myproxy.defaults.hostname", this.mpHostTextField.getText());
        this.profile.setApplicationProperty("sshterm.myproxy.defaults.username", this.mpUsernameTextField.getText());
        this.profile.setApplicationProperty("sshterm.myproxy.defaults.port", this.mpPortTextField.getText());
        this.profile.setApplicationProperty("sshterm.myproxy.voname", this.mpVOnameTextField.getText());
        this.profile.setApplicationProperty("sshterm.browser.dn", this.bDNTextField.getText());
        this.profile.setApplicationProperty("sshterm.pkcs12.defaults.file", this.pkcs12FileTextField.getText());
        String bprofile = Browser.getCurrentBrowser();
        String[] profiles = null;
        try {
            profiles = Browser.getBrowserList();
        }
        catch (IOException e) {
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        if (bprofile == null && profiles != null && profiles.length > 0) {
            this.profile.setApplicationProperty("sshterm.browser.profile", (String)this.bBrowserComboBox.getSelectedItem());
        }
        DefaultListModel lm = (DefaultListModel)this.useList.getModel();
        String auths = "";
        for (int i = 0; i < lm.getSize(); ++i) {
            String item = (String)lm.get(i);
            for (int j = 0; j < this.ALL_AUTHS.length; ++j) {
                if (!this.AUTHNAMES[j].equals(item)) continue;
                auths = auths + this.ALL_AUTHS[j] + ",";
            }
        }
        if (auths.charAt(auths.length() - 1) == ',') {
            auths = auths.substring(0, auths.length() - 1);
        }
        this.profile.setApplicationProperty("sshterm.auth.order", auths);
    }

    @Override
    public void setConnectionProfile(SshToolsConnectionProfile profile) {
        int i;
        this.profile = profile;
        String order = PreferencesStore.get("sshterm.auth.order", this.DEFAULT_ORDER);
        order = profile.getApplicationProperty("sshterm.auth.order", order);
        String[] meths = order.split("(,|\\s)");
        LinkedList<String> luse = new LinkedList<String>();
        LinkedList<String> lnouse = new LinkedList<String>();
        for (i = 0; i < meths.length; ++i) {
            if (meths[i] == null || meths[i].equals("") || luse.contains(meths[i])) continue;
            luse.add(meths[i]);
        }
        for (i = 0; i < this.ALL_AUTHS.length; ++i) {
            if (luse.contains(this.ALL_AUTHS[i])) continue;
            lnouse.add(this.ALL_AUTHS[i]);
        }
        DefaultListModel<String> suse = new DefaultListModel<String>();
        for (int i2 = 0; i2 < luse.size(); ++i2) {
            String res = null;
            for (int j = 0; j < this.ALL_AUTHS.length; ++j) {
                if (!this.ALL_AUTHS[j].equals((String)luse.get(i2))) continue;
                res = this.AUTHNAMES[j];
            }
            suse.addElement(res);
        }
        DefaultListModel<String> snouse = new DefaultListModel<String>();
        for (int i3 = 0; i3 < lnouse.size(); ++i3) {
            String res = null;
            for (int j = 0; j < this.ALL_AUTHS.length; ++j) {
                if (!this.ALL_AUTHS[j].equals((String)lnouse.get(i3))) continue;
                res = this.AUTHNAMES[j];
            }
            snouse.addElement(res);
        }
        this.useList.setModel(suse);
        this.dontUseList.setModel(snouse);
        this.mpUsernameTextField.setText(profile.getApplicationProperty("sshterm.myproxy.defaults.username", PreferencesStore.get("sshterm.myproxy.defaults.username", System.getProperty("user.name"))));
        this.mpHostTextField.setText(profile.getApplicationProperty("sshterm.myproxy.defaults.hostname", PreferencesStore.get("sshterm.myproxy.defaults.hostname", "myproxy.ngs.ac.uk")));
        this.mpPortTextField.setText(profile.getApplicationProperty("sshterm.myproxy.defaults.port", PreferencesStore.get("sshterm.myproxy.defaults.port", "7513")));
        this.bDNTextField.setText(profile.getApplicationProperty("sshterm.browser.dn", PreferencesStore.get("sshterm.browser.dn", "")));
        this.pkcs12FileTextField.setText(profile.getApplicationProperty("sshterm.pkcs12.defaults.file", PreferencesStore.get("sshterm.pkcs12.defaults.file", "")));
        String prefProfile = profile.getApplicationProperty("sshterm.browser.profile", PreferencesStore.get("sshterm.browser.profile", ""));
        String bprofile = Browser.getCurrentBrowser();
        this.bBrowserComboBox.setEnabled(true);
        this.bDNTextField.setEnabled(true);
        boolean ok = true;
        if (bprofile == null) {
            try {
                String[] profiles = Browser.getBrowserList();
                if (profiles == null || profiles.length == 0) {
                    this.bBrowserComboBox.removeAllItems();
                    this.bBrowserComboBox.addItem("No Browsers found");
                    this.bBrowserComboBox.setSelectedIndex(0);
                    this.bBrowserComboBox.setEnabled(false);
                    this.bDNTextField.setEnabled(false);
                    ok = false;
                } else {
                    this.bBrowserComboBox.removeAllItems();
                    for (String i4 : profiles) {
                        this.bBrowserComboBox.addItem(i4);
                    }
                }
            }
            catch (IOException e) {
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            if (ok) {
                this.bBrowserComboBox.insertItemAt(prefProfile, 0);
                this.bBrowserComboBox.setSelectedIndex(0);
            }
        } else {
            this.bBrowserComboBox.removeAllItems();
            this.bBrowserComboBox.addItem("Browser Set for session (" + bprofile + ")");
            this.bBrowserComboBox.setSelectedIndex(0);
            this.bBrowserComboBox.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.setAvailableActions();
    }

    @Override
    public SshToolsConnectionProfile getConnectionProfile() {
        return this.profile;
    }

    @Override
    public String getTabContext() {
        return "Connection";
    }

    @Override
    public Icon getTabIcon() {
        return null;
    }

    @Override
    public String getTabTitle() {
        return "GSI Defaults";
    }

    @Override
    public String getTabToolTipText() {
        return "GSI Authentication Defaults Configuration.";
    }

    @Override
    public int getTabMnemonic() {
        return 103;
    }

    @Override
    public Component getTabComponent() {
        return this;
    }

    @Override
    public boolean validateTab() {
        return true;
    }

    @Override
    public void tabSelected() {
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.gridx = 0;
            gridBagConstraints15.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints15.fill = 2;
            gridBagConstraints15.gridy = 7;
            this.mpHostLabel = new JLabel();
            this.mpHostLabel.setText("Host:");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridy = 4;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.gridheight = 4;
            gridBagConstraints2.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints2.gridx = 3;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.gridy = 4;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.gridheight = 4;
            gridBagConstraints1.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints1.gridx = 0;
            this.useLabel = new JLabel();
            this.useLabel.setText("Use:");
            this.dontUseLabel = new JLabel();
            this.dontUseLabel.setText("Dont Use:");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 4;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getUsePanel(), gridBagConstraints);
            this.jContentPane.add((Component)this.getAuthsPanel(), gridBagConstraints15);
        }
        return this.jContentPane;
    }

    private JPanel getUsePanel() {
        if (this.usePanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.ipadx = 4;
            gridBagConstraints1.ipady = 2;
            gridBagConstraints1.weightx = 0.0;
            gridBagConstraints1.gridheight = 7;
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.gridx = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.ipadx = 0;
            gridBagConstraints2.ipady = 0;
            gridBagConstraints2.gridheight = 7;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridx = 3;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.ipadx = 4;
            gridBagConstraints3.ipady = 2;
            gridBagConstraints3.gridx = 3;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.ipadx = 4;
            gridBagConstraints4.ipady = 2;
            gridBagConstraints4.gridx = 0;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.insets = new Insets(26, 3, 20, 3);
            gridBagConstraints8.gridy = 5;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 2;
            gridBagConstraints7.insets = new Insets(26, 3, 20, 3);
            gridBagConstraints7.gridy = 5;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.gridy = 7;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.gridy = 4;
            this.usePanel = new JPanel();
            this.usePanel.setLayout(new GridBagLayout());
            this.usePanel.setBorder(BorderFactory.createTitledBorder("Authentication Order: "));
            this.usePanel.add((Component)this.getUseList(), gridBagConstraints1);
            this.usePanel.add((Component)this.getDontUseList(), gridBagConstraints2);
            this.usePanel.add((Component)this.getUpButton(), gridBagConstraints5);
            this.usePanel.add((Component)this.getDownButton(), gridBagConstraints6);
            this.usePanel.add((Component)this.getStopUseButton(), gridBagConstraints7);
            this.usePanel.add((Component)this.getUseButton(), gridBagConstraints8);
            this.usePanel.add((Component)this.useLabel, gridBagConstraints4);
            this.usePanel.add((Component)this.dontUseLabel, gridBagConstraints3);
        }
        return this.usePanel;
    }

    private JList getUseList() {
        if (this.useList == null) {
            this.useList = new JList();
            this.useList.setPreferredSize(new Dimension(120, 100));
            this.useList.setSelectionMode(0);
            this.useList.setBorder(BorderFactory.createEtchedBorder(1));
        }
        return this.useList;
    }

    private JList getDontUseList() {
        if (this.dontUseList == null) {
            this.dontUseList = new JList();
            this.dontUseList.setPreferredSize(new Dimension(120, 100));
            this.dontUseList.setSelectionMode(0);
            this.dontUseList.setBorder(BorderFactory.createEtchedBorder(1));
        }
        return this.dontUseList;
    }

    private JButton getUpButton() {
        if (this.upButton == null) {
            this.upButton = new JButton();
            this.upButton.setIcon(new ResourceIcon("/com/sshtools/sshterm/up.png"));
            this.upButton.setMargin(new Insets(3, 3, 3, 3));
            this.upButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int i = GSIAuthTab.this.useList.getSelectedIndex();
                    if (i != -1 && i != 0) {
                        DefaultListModel lm = (DefaultListModel)GSIAuthTab.this.useList.getModel();
                        Object o = lm.get(i);
                        lm.set(i, lm.get(i - 1));
                        lm.set(i - 1, o);
                        GSIAuthTab.this.useList.setSelectedIndex(i - 1);
                    }
                }
            });
        }
        return this.upButton;
    }

    private JButton getDownButton() {
        if (this.downButton == null) {
            this.downButton = new JButton();
            this.downButton.setMargin(new Insets(3, 3, 3, 3));
            this.downButton.setIcon(new ResourceIcon("/com/sshtools/sshterm/down.png"));
            this.downButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int i = GSIAuthTab.this.useList.getSelectedIndex();
                    DefaultListModel lm = (DefaultListModel)GSIAuthTab.this.useList.getModel();
                    if (i != -1 && i != lm.size() - 1) {
                        Object o = lm.get(i);
                        lm.set(i, lm.get(i + 1));
                        lm.set(i + 1, o);
                        GSIAuthTab.this.useList.setSelectedIndex(i + 1);
                    }
                }
            });
        }
        return this.downButton;
    }

    private JButton getStopUseButton() {
        if (this.stopUseButton == null) {
            this.stopUseButton = new JButton();
            this.stopUseButton.setMargin(new Insets(3, 3, 3, 3));
            this.stopUseButton.setIcon(new ResourceIcon("/com/sshtools/sshterm/right.png"));
            this.stopUseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int i = GSIAuthTab.this.useList.getSelectedIndex();
                    if (i != -1) {
                        DefaultListModel lmu = (DefaultListModel)GSIAuthTab.this.useList.getModel();
                        DefaultListModel lmd = (DefaultListModel)GSIAuthTab.this.dontUseList.getModel();
                        lmd.addElement(lmu.get(i));
                        lmu.remove(i);
                    }
                }
            });
        }
        return this.stopUseButton;
    }

    private JButton getUseButton() {
        if (this.useButton == null) {
            this.useButton = new JButton();
            this.useButton.setMargin(new Insets(3, 3, 3, 3));
            this.useButton.setIcon(new ResourceIcon("/com/sshtools/sshterm/left.png"));
            this.useButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int i = GSIAuthTab.this.dontUseList.getSelectedIndex();
                    if (i != -1) {
                        DefaultListModel lmu = (DefaultListModel)GSIAuthTab.this.useList.getModel();
                        DefaultListModel lmd = (DefaultListModel)GSIAuthTab.this.dontUseList.getModel();
                        lmu.addElement(lmd.get(i));
                        lmd.remove(i);
                    }
                }
            });
        }
        return this.useButton;
    }

    private JPanel getMpPanel() {
        if (this.mpPanel == null) {
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.fill = 3;
            gridBagConstraints14.gridy = 3;
            gridBagConstraints14.weightx = 1.0;
            gridBagConstraints14.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints14.anchor = 17;
            gridBagConstraints14.gridx = 2;
            GridBagConstraints gridBagConstraints14b = new GridBagConstraints();
            gridBagConstraints14b.fill = 3;
            gridBagConstraints14b.gridy = 4;
            gridBagConstraints14b.weightx = 1.0;
            gridBagConstraints14.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints14b.anchor = 17;
            gridBagConstraints14b.gridx = 2;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.fill = 3;
            gridBagConstraints13.gridy = 2;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints13.anchor = 17;
            gridBagConstraints13.gridx = 2;
            GridBagConstraints gridBagConstraints13b = new GridBagConstraints();
            gridBagConstraints13b.fill = 3;
            gridBagConstraints13b.gridy = 1;
            gridBagConstraints13b.weightx = 1.0;
            gridBagConstraints13b.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints13b.anchor = 17;
            gridBagConstraints13b.gridx = 2;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 1;
            gridBagConstraints12.insets = new Insets(3, 20, 3, 3);
            gridBagConstraints12.ipadx = 4;
            gridBagConstraints12.ipady = 2;
            gridBagConstraints12.anchor = 13;
            gridBagConstraints12.gridy = 3;
            GridBagConstraints gridBagConstraints12b = new GridBagConstraints();
            gridBagConstraints12b.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints12b.gridy = 4;
            gridBagConstraints12b.ipadx = 4;
            gridBagConstraints12b.ipady = 2;
            gridBagConstraints12b.weightx = 1.0;
            gridBagConstraints12b.anchor = 13;
            gridBagConstraints12b.gridx = 1;
            this.mpPortLabel = new JLabel();
            this.mpPortLabel.setText("Port:");
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints10.gridy = 2;
            gridBagConstraints10.ipadx = 4;
            gridBagConstraints10.ipady = 2;
            gridBagConstraints10.anchor = 13;
            gridBagConstraints10.gridx = 1;
            GridBagConstraints gridBagConstraints10b = new GridBagConstraints();
            gridBagConstraints10b.insets = new Insets(3, 20, 3, 3);
            gridBagConstraints10b.gridy = 1;
            gridBagConstraints10b.ipadx = 4;
            gridBagConstraints10b.ipady = 2;
            gridBagConstraints10b.anchor = 13;
            gridBagConstraints10b.gridx = 1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints11.gridy = 0;
            gridBagConstraints11.gridwidth = 3;
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.ipadx = 4;
            gridBagConstraints11.ipady = 2;
            gridBagConstraints11.gridx = 0;
            this.myProxyLabel = new JLabel();
            this.myProxyLabel.setText("MyProxy:");
            this.mpUsernameLabel = new JLabel();
            this.mpUsernameLabel.setText("Username:");
            this.mpVOnameLabel = new JLabel();
            this.mpVOnameLabel.setText("VO name:");
            this.mpPanel = new JPanel();
            this.mpPanel.setLayout(new GridBagLayout());
            this.mpPanel.add((Component)this.myProxyLabel, gridBagConstraints11);
            this.mpPanel.add((Component)this.mpHostLabel, gridBagConstraints10);
            this.mpPanel.add((Component)this.mpUsernameLabel, gridBagConstraints10b);
            this.mpPanel.add((Component)this.mpPortLabel, gridBagConstraints12);
            this.mpPanel.add((Component)this.mpVOnameLabel, gridBagConstraints12b);
            this.mpPanel.add((Component)this.getMpVOnameTextField(), gridBagConstraints14b);
            this.mpPanel.add((Component)this.getMpHostTextField(), gridBagConstraints13);
            this.mpPanel.add((Component)this.getMpPortTextField(), gridBagConstraints14);
            this.mpPanel.add((Component)this.getMpUsernameTextField(), gridBagConstraints13b);
        }
        return this.mpPanel;
    }

    private JTextField getMpHostTextField() {
        if (this.mpHostTextField == null) {
            this.mpHostTextField = new JTextField();
            this.mpHostTextField.setPreferredSize(new Dimension(240, 20));
        }
        return this.mpHostTextField;
    }

    private JTextField getMpPortTextField() {
        if (this.mpPortTextField == null) {
            this.mpPortTextField = new NumericTextField(new Integer(0), new Integer(65535), new Integer(7513));
            this.mpPortTextField.setPreferredSize(new Dimension(60, 20));
        }
        return this.mpPortTextField;
    }

    private JTextField getMpUsernameTextField() {
        if (this.mpUsernameTextField == null) {
            this.mpUsernameTextField = new JTextField();
            this.mpUsernameTextField.setPreferredSize(new Dimension(100, 20));
        }
        return this.mpUsernameTextField;
    }

    private JTextField getMpVOnameTextField() {
        if (this.mpVOnameTextField == null) {
            this.mpVOnameTextField = new JTextField();
            this.mpVOnameTextField.setPreferredSize(new Dimension(100, 20));
        }
        return this.mpVOnameTextField;
    }

    private JPanel getAuthsPanel() {
        if (this.authsPanel == null) {
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.gridx = 0;
            gridBagConstraints22.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints22.gridy = 3;
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.gridx = 0;
            gridBagConstraints17.fill = 2;
            gridBagConstraints17.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints17.gridy = 2;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = -1;
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints9.gridy = -1;
            this.authsPanel = new JPanel();
            this.authsPanel.setLayout(new GridBagLayout());
            this.authsPanel.setBorder(BorderFactory.createTitledBorder("Authentication Defaults: "));
            this.authsPanel.add((Component)this.getMpPanel(), gridBagConstraints9);
            this.authsPanel.add((Component)this.getBrowserPanel(), gridBagConstraints17);
            this.authsPanel.add((Component)this.getPkcs12Panel(), gridBagConstraints22);
        }
        return this.authsPanel;
    }

    private JPanel getBrowserPanel() {
        if (this.browserPanel == null) {
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.fill = 1;
            gridBagConstraints21.gridy = 2;
            gridBagConstraints21.weightx = 1.0;
            gridBagConstraints21.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints21.anchor = 17;
            gridBagConstraints21.gridx = 1;
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            gridBagConstraints20.gridx = 0;
            gridBagConstraints20.anchor = 13;
            gridBagConstraints20.insets = new Insets(3, 20, 3, 3);
            gridBagConstraints20.ipadx = 4;
            gridBagConstraints20.ipady = 2;
            gridBagConstraints20.gridy = 2;
            this.dNLabel = new JLabel();
            this.dNLabel.setText("DN:");
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.gridx = 0;
            gridBagConstraints19.insets = new Insets(3, 28, 3, 3);
            gridBagConstraints19.ipadx = 4;
            gridBagConstraints19.ipady = 2;
            gridBagConstraints19.anchor = 13;
            gridBagConstraints19.gridy = 1;
            this.browserBrowserLabel = new JLabel();
            this.browserBrowserLabel.setText("Browser:");
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.fill = 3;
            gridBagConstraints18.gridy = 1;
            gridBagConstraints18.weightx = 1.0;
            gridBagConstraints18.anchor = 17;
            gridBagConstraints18.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints18.gridx = 1;
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridx = 0;
            gridBagConstraints16.ipadx = 4;
            gridBagConstraints16.ipady = 2;
            gridBagConstraints16.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints16.gridwidth = 2;
            gridBagConstraints16.anchor = 17;
            gridBagConstraints16.gridy = 0;
            this.browserLabel = new JLabel();
            this.browserLabel.setText("Browser:");
            this.browserPanel = new JPanel();
            this.browserPanel.setLayout(new GridBagLayout());
            this.browserPanel.add((Component)this.getBBrowserComboBox(), gridBagConstraints18);
            this.browserPanel.add((Component)this.browserLabel, gridBagConstraints16);
            this.browserPanel.add((Component)this.browserBrowserLabel, gridBagConstraints19);
            this.browserPanel.add((Component)this.dNLabel, gridBagConstraints20);
            this.browserPanel.add((Component)this.getBDNTextField(), gridBagConstraints21);
        }
        return this.browserPanel;
    }

    private JComboBox getBBrowserComboBox() {
        if (this.bBrowserComboBox == null) {
            this.bBrowserComboBox = new JComboBox();
            this.bBrowserComboBox.setPreferredSize(new Dimension(240, 25));
        }
        return this.bBrowserComboBox;
    }

    private JTextField getBDNTextField() {
        if (this.bDNTextField == null) {
            this.bDNTextField = new JTextField();
            this.bDNTextField.setPreferredSize(new Dimension(240, 20));
        }
        return this.bDNTextField;
    }

    private JPanel getPkcs12Panel() {
        if (this.pkcs12Panel == null) {
            GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
            gridBagConstraints26.fill = 3;
            gridBagConstraints26.gridy = 1;
            gridBagConstraints26.weightx = 1.0;
            gridBagConstraints26.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints26.gridx = 4;
            GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
            gridBagConstraints25.fill = 3;
            gridBagConstraints25.gridy = 1;
            gridBagConstraints25.weightx = 1.0;
            gridBagConstraints25.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints25.gridx = 3;
            GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
            gridBagConstraints24.gridx = 2;
            gridBagConstraints24.anchor = 17;
            gridBagConstraints24.insets = new Insets(3, 50, 3, 3);
            gridBagConstraints24.ipadx = 4;
            gridBagConstraints24.ipady = 2;
            gridBagConstraints24.gridy = 1;
            this.pkcs12FileLabel = new JLabel();
            this.pkcs12FileLabel.setText("File:");
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            gridBagConstraints23.anchor = 17;
            gridBagConstraints23.gridx = 0;
            gridBagConstraints23.gridy = 0;
            gridBagConstraints23.gridwidth = 3;
            gridBagConstraints23.ipadx = 4;
            gridBagConstraints23.ipady = 2;
            gridBagConstraints23.insets = new Insets(3, 3, 3, 3);
            this.pkcs12Label = new JLabel();
            this.pkcs12Label.setText("PKCS12:");
            this.pkcs12Panel = new JPanel();
            this.pkcs12Panel.setLayout(new GridBagLayout());
            this.pkcs12Panel.add((Component)this.pkcs12Label, gridBagConstraints23);
            this.pkcs12Panel.add((Component)this.pkcs12FileLabel, gridBagConstraints24);
            this.pkcs12Panel.add((Component)this.getPkcs12FileTextField(), gridBagConstraints25);
            this.pkcs12Panel.add((Component)this.getPkcs12Button(), gridBagConstraints26);
        }
        return this.pkcs12Panel;
    }

    private JTextField getPkcs12FileTextField() {
        if (this.pkcs12FileTextField == null) {
            this.pkcs12FileTextField = new JTextField();
            this.pkcs12FileTextField.setPreferredSize(new Dimension(150, 20));
        }
        return this.pkcs12FileTextField;
    }

    private JButton getPkcs12Button() {
        if (this.pkcs12Button == null) {
            this.pkcs12Button = new JButton();
            this.pkcs12Button.setText("Browse...");
            this.pkcs12Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionevent) {
                    JFileChooser chooser = new JFileChooser();
                    ExampleFileFilter filter = new ExampleFileFilter();
                    filter.addExtension("pfx");
                    filter.addExtension("p12");
                    filter.setDescription("pfx and p12 files");
                    chooser.setFileFilter(filter);
                    chooser.setFileHidingEnabled(false);
                    chooser.setDialogTitle("Select Certificate File For Authentication");
                    if (chooser.showOpenDialog(GSIAuthTab.this) == 0) {
                        GSIAuthTab.this.pkcs12FileTextField.setText(chooser.getSelectedFile().getAbsolutePath());
                    }
                }
            });
        }
        return this.pkcs12Button;
    }
}

