/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshterm;

import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.glite.voms.VOMSAttribute;
import org.glite.voms.VOMSValidator;
import org.globus.common.CoGProperties;
import org.globus.gsi.CredentialException;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.X509Credential;
import org.globus.gsi.util.CertificateUtil;
import org.globus.gsi.util.ProxyCertificateUtil;
import org.globus.util.ConfigUtil;
import org.globus.util.Util;

public class ProxyHelper
implements Runnable {
    public static boolean proxyExists() {
        String filename = CoGProperties.getDefault().getProxyFile();
        if (filename == null) {
            return false;
        }
        File file = new File(filename);
        return file.exists() && file.isFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveProxy(X509Credential theProxy, SshConnectionProperties props) {
        String proxyFile = CoGProperties.getDefault().getProxyFile();
        FileOutputStream out = null;
        String proxyLoc = ConfigUtil.discoverProxyLocation();
        try {
            out = new FileOutputStream(proxyLoc);
            theProxy.save(out);
            if (!Util.setOwnerAccessOnly(proxyLoc)) {
                System.out.println("Warning: could not set permissions on proxy file.");
            }
            out.flush();
        }
        catch (FileNotFoundException e) {
            System.out.println("Failed to save proxy to proxy file: " + e.getMessage());
            ProxyHelper.message(props, "Failed to save proxy to proxy file: " + e.getMessage());
        }
        catch (CertificateEncodingException e) {
            System.out.println("Failed to save proxy to proxy file: " + e.getMessage());
            ProxyHelper.message(props, "Failed to save proxy to proxy file: " + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("Failed to save proxy to proxy file: " + e.getMessage());
            ProxyHelper.message(props, "Failed to save proxy to proxy file: " + e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (Exception e) {}
            }
        }
    }

    @Override
    public void run() {
        int ret;
        if (ProxyHelper.proxyExists() && (ret = JOptionPane.showConfirmDialog(null, "You have a proxy certificate stored on a disk which may have been created by this terminal, do you want to delete it?", "GSI-SSHTerm", 0, 3)) == 0) {
            ProxyHelper.destroyProxy();
        }
    }

    private static void message(SshConnectionProperties props, String s) {
        JOptionPane.showMessageDialog(props.getWindow(), s, "Problem saving proxy", 0);
    }

    public static void showProxyInfo(Component parent) {
        String identity = "";
        String subject = "";
        String issuer = "";
        String lifetime = "";
        String storage = "";
        String type = "";
        Vector voAttributes = null;
        CoGProperties cogproperties = CoGProperties.getDefault();
        try {
            if (!new File(cogproperties.getProxyFile()).exists()) {
                storage = "No local proxy.";
            } else {
                X509Credential x509credential = new X509Credential(cogproperties.getProxyFile());
                if (x509credential.getTimeLeft() > 0L) {
                    storage = "Local File: " + cogproperties.getProxyFile();
                    subject = CertificateUtil.toGlobusID(x509credential.getSubject(), true);
                    issuer = CertificateUtil.toGlobusID(x509credential.getIssuer(), true);
                    identity = CertificateUtil.toGlobusID(x509credential.getIdentityCertificate().getSubjectDN().toString(), true);
                    long seconds = x509credential.getTimeLeft();
                    long days = seconds / 86400L;
                    long hours = (seconds -= days * 60L * 60L * 24L) / 3600L;
                    long mins = (seconds -= hours * 60L * 60L) / 60L;
                    lifetime = days + " days " + hours + " hours " + mins + " minutes " + (seconds -= mins * 60L) + " seconds.";
                    GSIConstants.CertificateType certType = x509credential.getProxyType();
                    type = ProxyCertificateUtil.getProxyTypeAsString(certType);
                    if (certType == GSIConstants.CertificateType.EEC) {
                        type = "end entity certificate";
                    }
                }
                voAttributes = VOMSValidator.parse((X509Certificate[])x509credential.getCertificateChain());
            }
        }
        catch (CredentialException credentialexception) {
            if (credentialexception.getMessage().indexOf("Expired") >= 0) {
                File file = new File(cogproperties.getProxyFile());
                file.delete();
                storage = "Expired local proxy.";
            }
            storage = "No local proxy (Error).";
        }
        JComponent panel = ProxyHelper.getInfoPanel(identity, subject, issuer, lifetime, storage, type, voAttributes);
        JOptionPane.showMessageDialog(parent, panel, "Disk Proxy Information", -1);
    }

    public static void destroyProxy() {
        String filename = CoGProperties.getDefault().getProxyFile();
        if (filename != null) {
            Util.destroy(new File(filename));
        }
    }

    private static JComponent getInfoPanel(String identity, String subject, String issuer, String lifetime, String storage, String type, Vector voAttributes) {
        JPanel infoResultPanel = new JPanel();
        infoResultPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.anchor = 18;
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.insets = new Insets(20, 20, 0, 0);
        JLabel infoResulTitleLabel = new JLabel();
        infoResulTitleLabel.setFont(new Font("Dialog", 1, 18));
        infoResulTitleLabel.setText("Proxy Information:");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = 1;
        infoResultPanel.setLayout(new GridBagLayout());
        infoResultPanel.add((Component)ProxyHelper.getInfoResultMainPanel(identity, subject, issuer, lifetime, storage, type, voAttributes), gridBagConstraints2);
        infoResultPanel.add((Component)infoResulTitleLabel, gridBagConstraints1);
        return infoResultPanel;
    }

    private static JPanel getInfoResultMainPanel(String identity, String subject, String issuer, String lifetime, String storage, String type, Vector voAttributes) {
        JPanel infoResultMainPanel = new JPanel();
        infoResultMainPanel.setAutoscrolls(true);
        GridBagConstraints gridBagConstraintsA = new GridBagConstraints();
        gridBagConstraintsA.fill = 3;
        gridBagConstraintsA.weightx = 1.0;
        gridBagConstraintsA.insets = new Insets(3, 3, 3, 3);
        gridBagConstraintsA.ipadx = 0;
        gridBagConstraintsA.gridx = 2;
        gridBagConstraintsA.gridy = 1;
        GridBagConstraints gridBagConstraintsB = new GridBagConstraints();
        gridBagConstraintsB.insets = new Insets(3, 3, 3, 3);
        gridBagConstraintsB.anchor = 17;
        gridBagConstraintsB.gridx = 1;
        gridBagConstraintsB.gridy = 1;
        JLabel infoResultTypeLabel = new JLabel();
        infoResultTypeLabel.setText("Type:");
        JLabel infoResultIdentityLabel = new JLabel();
        infoResultIdentityLabel.setText("Identity: ");
        JLabel infoResultLifetimeLabel = new JLabel();
        infoResultLifetimeLabel.setText("Lifetime: ");
        JLabel infoResultIssuerLabel = new JLabel();
        infoResultIssuerLabel.setText("Issuer: ");
        JLabel infoResultSubjectLabel = new JLabel();
        infoResultSubjectLabel.setText("Subject: ");
        JLabel infoResultStorageLabel = new JLabel();
        infoResultStorageLabel.setText("Storage: ");
        JTextField infoResultIdentityTextField = new JTextField(identity);
        infoResultIdentityTextField.setEditable(false);
        infoResultIdentityTextField.setColumns(50);
        JTextField infoResultSubjectTextField = new JTextField(subject);
        infoResultSubjectTextField.setEditable(false);
        infoResultSubjectTextField.setColumns(50);
        JTextField infoResultStorageTextField = new JTextField(storage);
        infoResultStorageTextField.setEditable(false);
        infoResultStorageTextField.setColumns(50);
        JTextField infoResultIssuerTextField = new JTextField(issuer);
        infoResultIssuerTextField.setEditable(false);
        infoResultIssuerTextField.setColumns(50);
        JTextField infoResultTypeTextField = new JTextField(type);
        infoResultTypeTextField.setEditable(false);
        infoResultTypeTextField.setColumns(50);
        JTextField infoResultLifetimeTextField = new JTextField(lifetime);
        infoResultLifetimeTextField.setEditable(false);
        infoResultLifetimeTextField.setColumns(50);
        infoResultMainPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        infoResultMainPanel.setLayout(new GridBagLayout());
        infoResultMainPanel.add((Component)infoResultStorageLabel, gridBagConstraintsB);
        infoResultMainPanel.add((Component)infoResultStorageTextField, gridBagConstraintsA);
        gridBagConstraintsB.gridy = 2;
        gridBagConstraintsA.gridy = 2;
        infoResultMainPanel.add((Component)infoResultIdentityLabel, gridBagConstraintsB);
        infoResultMainPanel.add((Component)infoResultIdentityTextField, gridBagConstraintsA);
        gridBagConstraintsB.gridy = 3;
        gridBagConstraintsA.gridy = 3;
        infoResultMainPanel.add((Component)infoResultSubjectLabel, gridBagConstraintsB);
        infoResultMainPanel.add((Component)infoResultSubjectTextField, gridBagConstraintsA);
        gridBagConstraintsB.gridy = 4;
        gridBagConstraintsA.gridy = 4;
        infoResultMainPanel.add((Component)infoResultIssuerLabel, gridBagConstraintsB);
        infoResultMainPanel.add((Component)infoResultIssuerTextField, gridBagConstraintsA);
        gridBagConstraintsB.gridy = 5;
        gridBagConstraintsA.gridy = 5;
        infoResultMainPanel.add((Component)infoResultLifetimeLabel, gridBagConstraintsB);
        infoResultMainPanel.add((Component)infoResultLifetimeTextField, gridBagConstraintsA);
        gridBagConstraintsB.gridy = 6;
        gridBagConstraintsA.gridy = 6;
        infoResultMainPanel.add((Component)infoResultTypeLabel, gridBagConstraintsB);
        infoResultMainPanel.add((Component)infoResultTypeTextField, gridBagConstraintsA);
        int j = 7;
        if (voAttributes != null && voAttributes.size() > 0) {
            JTextArea voInfo = new JTextArea(5, 50);
            JScrollPane voScrollPane = new JScrollPane(voInfo);
            String info = "";
            for (int i = 0; i < voAttributes.size(); ++i) {
                VOMSAttribute att = (VOMSAttribute)voAttributes.get(i);
                if (att == null) continue;
                if (i == 0) {
                    gridBagConstraintsB.gridy = j;
                    gridBagConstraintsA.gridy = j;
                    infoResultMainPanel.add((Component)new JLabel("VO Information:"), gridBagConstraintsB);
                }
                info = info + "VO: " + att.getVO() + "\n";
                info = info + "Issuer: " + att.getIssuer() + "\n";
                info = info + "URI: " + att.getHost() + ":" + att.getPort() + "\n";
                try {
                    long seconds = (att.getNotAfter().getTime() - System.currentTimeMillis()) / 1000L;
                    long days = seconds / 86400L;
                    long hours = (seconds -= days * 60L * 60L * 24L) / 3600L;
                    long mins = (seconds -= hours * 60L * 60L) / 60L;
                    info = info + "Lifetime: " + days + " days " + hours + " hours " + mins + " minutes " + (seconds -= mins * 60L) + " seconds\n";
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                info = info + "\n";
            }
            gridBagConstraintsB.gridy = j;
            gridBagConstraintsA.gridy = j++;
            voInfo.append(info);
            infoResultMainPanel.add((Component)voScrollPane, gridBagConstraintsA);
        }
        return infoResultMainPanel;
    }
}

