/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshvnc;

import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.sshvnc.AuthenticationFrame;
import com.sshtools.sshvnc.ClipboardFrame;
import com.sshtools.sshvnc.DesCipher;
import com.sshtools.sshvnc.HexASCII;
import com.sshtools.sshvnc.RfbProto;
import com.sshtools.sshvnc.SshVNCOptions;
import com.sshtools.sshvnc.VncCanvas;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class SshVNCViewer
extends JPanel {
    private String[] mainArgs;
    private RfbProto rfb;
    private JScrollPane desktopScrollPane;
    private GridBagLayout gridbag;
    private VncCanvas vc;
    private ClipboardFrame clipboard;
    private boolean protocolInitialised;
    private Object recordingSync;
    private String sessionFileName;
    private boolean recordingActive;
    private boolean recordingStatusChanged;
    private String cursorUpdatesDef;
    private String eightBitColorsDef;
    private String socketFactory;
    private boolean showOfflineDesktop;
    private int deferScreenUpdates;
    private int deferCursorUpdates;
    private int deferUpdateRequests;
    private SshToolsApplicationPanel application;
    private SshVNCOptions options;
    private SshVNCOptions oldOptions;
    private AuthenticationFrame authFrame;
    private boolean frameResizeable = true;

    public SshVNCViewer() {
        this.showWelcomeScreen();
    }

    public boolean init(InputStream in, OutputStream out, SshToolsApplicationPanel application, SshVNCOptions options) throws Exception {
        this.options = options;
        this.application = application;
        this.recordingSync = new Object();
        Window w = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
        this.clipboard = w instanceof JFrame ? new ClipboardFrame((Frame)((JFrame)w), this) : (w instanceof JDialog ? new ClipboardFrame((Dialog)((JDialog)w), this) : new ClipboardFrame(this));
        this.sessionFileName = null;
        this.recordingActive = false;
        this.recordingStatusChanged = false;
        this.cursorUpdatesDef = null;
        this.eightBitColorsDef = null;
        this.application = application;
        this.gridbag = new GridBagLayout();
        this.removeAll();
        this.setLayout(this.gridbag);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        try {
            if (!this.connectAndAuthenticate(in, out)) {
                application.getStatusBar().setStatusText("Failed to authenticate with VNC server");
                this.closeConnection();
                return false;
            }
            application.getStatusBar().setStatusText("Initialising VNC protocol");
            this.doProtocolInitialisation();
            this.vc = new VncCanvas(this);
            if (options.isRequestCursorUpdates() && !options.isIgnoreCursorUpdates()) {
                try {
                    BufferedImage img = new BufferedImage(1, 1, 6);
                    if (img != null) {
                        Cursor c = this.getToolkit().createCustomCursor(img, new Point(0, 0), "Dot");
                        this.vc.setCursor(c);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.gridbag.setConstraints(this.vc, gbc);
            this.desktopScrollPane = new JScrollPane(this.vc);
            this.desktopScrollPane.setBorder(null);
            gbc.fill = 1;
            this.gridbag.setConstraints(this.desktopScrollPane, gbc);
            this.add(this.desktopScrollPane);
            this.validate();
            this.vc.resizeDesktopFrame();
            application.getStatusBar().setStatusText("Connected");
            this.vc.processNormalProtocol();
            return true;
        }
        catch (Exception e) {
            this.closeConnection();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showWelcomeScreen() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.removeAll();
            this.setLayout(new BorderLayout());
            JPanel p = new JPanel(new BorderLayout());
            p.setBackground(Color.black);
            p.setForeground(Color.white);
            JLabel welcomeLabel = new JLabel("SSHVnc", 0);
            welcomeLabel.setForeground(Color.white);
            welcomeLabel.setFont(welcomeLabel.getFont().deriveFont(72.0f).deriveFont(3));
            p.add((Component)welcomeLabel, "Center");
            this.add((Component)p, "Center");
            this.validate();
        }
    }

    public boolean isFrameResizeable() {
        return this.frameResizeable;
    }

    public void setFrameResizeable(boolean frameResizeable) {
        this.frameResizeable = frameResizeable;
    }

    public void setClipboardVisible(boolean visible) {
        if (this.clipboard != null) {
            this.clipboard.setVisible(visible);
        }
    }

    public int getScreenSizePolicy() {
        return this.options.getScreenSizePolicy();
    }

    public boolean isClipboardVisible() {
        return this.clipboard != null && this.clipboard.isVisible();
    }

    public void closeConnection() {
        this.protocolInitialised = false;
        if (this.vc != null) {
            this.vc.enableInput(false);
            this.vc.setCursor(Cursor.getDefaultCursor());
        }
        if (this.rfb != null && !this.rfb.closed()) {
            this.rfb.close();
        }
        System.out.println("Disconnect");
        if (this.rfb != null && !this.rfb.closed()) {
            this.rfb.close();
        }
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        if (this.recordingActive) {
            this.setRecordingStatus(null);
            try {
                this.stopRecording();
            }
            catch (IOException ioe) {
                System.err.println("Could not stop recording sesion.");
                ioe.printStackTrace();
            }
        }
        this.showWelcomeScreen();
    }

    public String getSocketFactory() {
        return this.socketFactory;
    }

    public RfbProto getRFB() {
        return this.rfb;
    }

    public SshVNCOptions getOptions() {
        return this.options;
    }

    public int getDeferCursorUpdates() {
        return this.deferCursorUpdates;
    }

    public int getDeferUpdateRequests() {
        return this.deferUpdateRequests;
    }

    public int getDeferScreenUpdates() {
        return this.deferUpdateRequests;
    }

    public ClipboardFrame getClipboard() {
        return this.clipboard;
    }

    public VncCanvas getVNCCanvas() {
        return this.vc;
    }

    public JFrame getFrame() {
        return (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
    }

    public JScrollPane getScroller() {
        return this.desktopScrollPane;
    }

    private boolean connectAndAuthenticate(InputStream in, OutputStream out) throws Exception {
        this.protocolInitialised = false;
        if (this.authFrame == null) {
            Window w = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
            this.authFrame = w instanceof JFrame ? new AuthenticationFrame((JFrame)w) : (w instanceof JDialog ? new AuthenticationFrame((JDialog)w) : new AuthenticationFrame());
            UIUtil.positionComponent(0, this.authFrame);
        }
        this.rfb = new RfbProto(in, out, this);
        this.rfb.readVersionMsg();
        System.out.println("RFB server supports protocol version " + this.rfb.serverMajor + "." + this.rfb.serverMinor);
        this.rfb.writeVersionMsg();
        int authScheme = this.rfb.readAuthScheme();
        System.out.println("Got auth scheme " + authScheme);
        block9: while (true) {
            switch (authScheme) {
                case 1: {
                    return true;
                }
                case 2: {
                    int firstZero;
                    Object[] c;
                    String pw = "";
                    String encPw = this.options.getEncryptedPassword();
                    if (!encPw.equals("")) {
                        c = HexASCII.ToByteArray(encPw);
                        byte[] key = new byte[]{23, 82, 107, 6, 35, 78, 88, 7};
                        DesCipher des = new DesCipher(key);
                        des.decrypt((byte[])c, 0, (byte[])c, 0);
                        pw = new String((byte[])c);
                    } else {
                        c = this.authFrame.doAuthentication();
                        if (c == null) {
                            return false;
                        }
                        pw = new String((char[])c);
                    }
                    byte[] challenge = new byte[16];
                    this.rfb.is.readFully(challenge);
                    if (pw.length() > 8) {
                        pw = pw.substring(0, 8);
                    }
                    if ((firstZero = pw.indexOf(0)) != -1) {
                        pw = pw.substring(0, firstZero);
                    }
                    byte[] key = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
                    System.arraycopy(pw.getBytes(), 0, key, 0, pw.length());
                    DesCipher des = new DesCipher(key);
                    des.encrypt(challenge, 0, challenge, 0);
                    des.encrypt(challenge, 8, challenge, 8);
                    this.rfb.os.write(challenge);
                    int authResult = this.rfb.is.readInt();
                    switch (authResult) {
                        case 0: {
                            return true;
                        }
                        case 1: {
                            continue block9;
                        }
                        case 2: {
                            throw new Exception("VNC authentication failed - too many tries");
                        }
                    }
                    throw new Exception("Unknown VNC authentication result " + authResult);
                }
            }
            break;
        }
        throw new Exception("Unknown VNC authentication scheme " + authScheme);
    }

    public boolean isProtocolInitialised() {
        return this.protocolInitialised;
    }

    void doProtocolInitialisation() throws IOException {
        this.rfb.writeClientInit();
        this.protocolInitialised = true;
        this.rfb.readServerInit();
        System.out.println("Desktop name is " + this.rfb.desktopName);
        System.out.println("Desktop size is " + this.rfb.framebufferWidth + " x " + this.rfb.framebufferHeight);
        this.setEncodings();
    }

    void setEncodings() {
        try {
            if (this.rfb != null && this.rfb.inNormalProtocol) {
                this.rfb.writeSetEncodings(this.options.getEncodings(), this.options.getNumberOfEncodings());
                if (this.vc != null) {
                    this.vc.softCursorFree();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setCutText(String text) {
        try {
            if (this.rfb != null && this.rfb.inNormalProtocol) {
                this.rfb.writeClientCutText(text);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRecordingStatus(String fname) {
        Object object = this.recordingSync;
        synchronized (object) {
            this.sessionFileName = fname;
            this.recordingStatusChanged = true;
        }
    }

    public String getRecordingStatus() {
        return this.sessionFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkRecordingStatus() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (this.recordingStatusChanged) {
                this.recordingStatusChanged = false;
                if (this.sessionFileName != null) {
                    this.startRecording();
                    return true;
                }
                this.stopRecording();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startRecording() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (!this.recordingActive) {
                try {
                    this.oldOptions = (SshVNCOptions)this.options.clone();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.options.setEightBitColors(false);
                this.options.setRequestCursorUpdates(false);
                this.options.setEncodings();
                this.setEncodings();
            } else {
                this.rfb.closeSession();
            }
            System.out.println("Recording the session in " + this.sessionFileName);
            this.rfb.startSession(this.sessionFileName);
            this.recordingActive = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopRecording() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (this.recordingActive) {
                this.options = this.oldOptions;
                this.setEncodings();
                this.rfb.closeSession();
                System.out.println("Session recording stopped.");
            }
            this.sessionFileName = null;
            this.recordingActive = false;
        }
    }

    public void refresh() throws IOException {
        this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, false);
    }

    public void sendCtrlAltDel() throws IOException {
        int modifiers = 10;
        KeyEvent ctrlAltDelEvent = new KeyEvent(this, 401, 0L, 10, 127, '\uffff');
        this.getRFB().writeKeyEvent(ctrlAltDelEvent);
        ctrlAltDelEvent = new KeyEvent(this, 402, 0L, 10, 127, '\uffff');
        this.getRFB().writeKeyEvent(ctrlAltDelEvent);
    }

    void moveFocusToDesktop() {
        if (this.vc != null && this.isAncestorOf(this.vc)) {
            this.vc.requestFocus();
        }
    }

    public synchronized void fatalError(String str, Exception e) {
        if (this.rfb != null) {
            if (this.rfb.closed()) {
                return;
            }
            this.rfb.close();
        }
        SshToolsApplicationPanel.showErrorMessage(this, str, "VNC Error", e);
    }

    void showMessage(String msg) {
        this.removeAll();
        Label errLabel = new Label(msg, 1);
        errLabel.setFont(new Font("Helvetica", 0, 12));
        this.setLayout(new FlowLayout(0, 30, 30));
        this.add(errLabel);
        this.validate();
    }

    class AuthenticationDialog
    extends JDialog {
        AuthenticationDialog() {
        }
    }
}

