/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.hep.dcapj.nio;

import edu.caltech.hep.dcapj.dCacheFile;
import edu.caltech.hep.dcapj.io.dCacheFileInputStream;
import edu.caltech.hep.dcapj.io.dCacheFileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class dCacheFileChannel
extends FileChannel {
    private dCacheFile _file;
    private dCacheFileInputStream _fileInStream;
    private dCacheFileOutputStream _fileOutStream;

    public dCacheFileChannel(dCacheFile file, dCacheFileInputStream fileIn) {
        this._file = file;
        this._fileInStream = fileIn;
    }

    public dCacheFileChannel(dCacheFile file, dCacheFileOutputStream fileOut) {
        this._file = file;
        this._fileOutStream = fileOut;
    }

    @Override
    public void force(boolean metaData) throws IOException {
        throw new IOException("Not implemented yet!");
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        return null;
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        return null;
    }

    @Override
    public long position() throws IOException {
        return 0L;
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        return null;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this._file.mode() == dCacheFile.Mode.WRITE_ONLY) {
            throw new IOException("Not in read mode.");
        }
        int result = this._file.read(dst, 0L);
        return result;
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        if (this._file.mode() == dCacheFile.Mode.WRITE_ONLY) {
            throw new IOException("Not in read mode.");
        }
        long oldPosition = this._file.tell();
        this._file.seek(position, false);
        int result = this.read(dst);
        this._file.seek(oldPosition, false);
        return result;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long result = 0L;
        for (int i = offset; i < offset + length; ++i) {
            result += (long)this.read(dsts[i]);
        }
        return result;
    }

    @Override
    public long size() throws IOException {
        if (this._file.mode() == dCacheFile.Mode.WRITE_ONLY) {
            throw new IOException("size() operation not available in write mode");
        }
        return this._file.length();
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate((int)count);
        src.read(buffer);
        buffer.flip();
        return this.write(buffer, position);
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate((int)count);
        this.read(buffer, position);
        buffer.flip();
        return target.write(buffer);
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        return null;
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        return null;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (this._file.mode() == dCacheFile.Mode.READ_ONLY) {
            throw new IOException("Not in write mode");
        }
        return this._file.write(src, -1L);
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        if (this._file.mode() == dCacheFile.Mode.READ_ONLY) {
            throw new IOException("Not in write mode");
        }
        return this._file.write(src, position);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long result = 0L;
        if (this._file.mode() == dCacheFile.Mode.READ_ONLY) {
            throw new IOException("Not in write mode");
        }
        for (int i = offset; i < offset + length; ++i) {
            result += (long)this.write(srcs[i]);
        }
        return result;
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this._file.close();
    }
}

