/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.hep.dcapj.util;

import edu.caltech.hep.dcapj.util.DataConnectionCallback;
import edu.caltech.hep.dcapj.util.ServerNIO;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Hashtable;
import java.util.logging.Logger;

public class IOCallback
extends ServerNIO {
    private static final Logger logger = Logger.getLogger(IOCallback.class.getName());
    protected Hashtable<Integer, DataConnectionCallback> callbacks = new Hashtable();

    public IOCallback() throws IOException {
        this.start();
        logger.info("Data connecation callback is now active");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleConnection(SocketChannel client) {
        block6: {
            DataInputStream poolIn = null;
            DataOutputStream poolOut = null;
            if (client == null) {
                logger.severe("IO callback channel failed for unknown file");
                return;
            }
            try {
                logger.fine("Handling connection from " + client.socket().getInetAddress().getHostAddress() + ":" + client.socket().getPort());
                poolIn = new DataInputStream(client.socket().getInputStream());
                poolOut = new DataOutputStream(client.socket().getOutputStream());
                ByteBuffer buffer = ByteBuffer.allocate(4);
                client.read(buffer);
                buffer.flip();
                int sessionID = buffer.getInt();
                logger.info("Received callback for session id " + sessionID);
                DataConnectionCallback connection = this.callbacks.get(sessionID);
                if (connection != null) {
                    logger.fine("Information callback reciever for sessionID " + sessionID);
                    connection.handleStreams(poolIn, poolOut, client.socket().getInetAddress().getHostAddress(), client);
                    break block6;
                }
                logger.warning("No callback receiver registred for sessionID " + sessionID);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public boolean registerCallback(int sessionID, DataConnectionCallback connection) {
        if (!this.callbacks.contains(sessionID)) {
            this.callbacks.put(sessionID, connection);
            logger.fine("Registered data call back receiver for sessionID " + sessionID);
            return true;
        }
        return false;
    }

    public boolean unregisterCallback(int sessionID) {
        if (this.callbacks.contains(sessionID)) {
            logger.info("Removing callback receiver for sessionID " + sessionID);
            this.callbacks.remove(sessionID);
            return true;
        }
        return false;
    }
}

