/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.crmf;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1Encodable;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1EncodableVector;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERInteger;
import edu.illinois.ncsa.bouncycastle.asn1.DERObject;
import edu.illinois.ncsa.bouncycastle.asn1.DERSequence;
import edu.illinois.ncsa.bouncycastle.asn1.crmf.SinglePubInfo;

public class PKIPublicationInfo
extends ASN1Encodable {
    private DERInteger action;
    private ASN1Sequence pubInfos;

    private PKIPublicationInfo(ASN1Sequence aSN1Sequence) {
        this.action = DERInteger.getInstance(aSN1Sequence.getObjectAt(0));
        this.pubInfos = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(1));
    }

    public static PKIPublicationInfo getInstance(Object object) {
        if (object instanceof PKIPublicationInfo) {
            return (PKIPublicationInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new PKIPublicationInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid object: " + object.getClass().getName());
    }

    public DERInteger getAction() {
        return this.action;
    }

    public SinglePubInfo[] getPubInfos() {
        if (this.pubInfos == null) {
            return null;
        }
        SinglePubInfo[] singlePubInfoArray = new SinglePubInfo[this.pubInfos.size()];
        for (int i = 0; i != singlePubInfoArray.length; ++i) {
            singlePubInfoArray[i] = SinglePubInfo.getInstance(this.pubInfos.getObjectAt(i));
        }
        return singlePubInfoArray;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.action);
        aSN1EncodableVector.add(this.pubInfos);
        return new DERSequence(aSN1EncodableVector);
    }
}

