/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERObjectIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.DERUTF8String;
import edu.illinois.ncsa.bouncycastle.asn1.ess.ContentHints;
import edu.illinois.ncsa.bouncycastle.asn1.test.ASN1UnitTest;
import java.io.IOException;

public class ContentHintsUnitTest
extends ASN1UnitTest {
    public String getName() {
        return "ContentHints";
    }

    public void performTest() throws Exception {
        DERUTF8String dERUTF8String = new DERUTF8String("Description");
        DERObjectIdentifier dERObjectIdentifier = new DERObjectIdentifier("1.2.2.3");
        ContentHints contentHints = new ContentHints(dERObjectIdentifier);
        this.checkConstruction(contentHints, dERObjectIdentifier, null);
        contentHints = new ContentHints(dERObjectIdentifier, dERUTF8String);
        this.checkConstruction(contentHints, dERObjectIdentifier, dERUTF8String);
        contentHints = ContentHints.getInstance(null);
        if (contentHints != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            ContentHints.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(ContentHints contentHints, DERObjectIdentifier dERObjectIdentifier, DERUTF8String dERUTF8String) throws IOException {
        this.checkValues(contentHints, dERObjectIdentifier, dERUTF8String);
        contentHints = ContentHints.getInstance(contentHints);
        this.checkValues(contentHints, dERObjectIdentifier, dERUTF8String);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(contentHints.toASN1Object().getEncoded());
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        contentHints = ContentHints.getInstance(aSN1Sequence);
        this.checkValues(contentHints, dERObjectIdentifier, dERUTF8String);
    }

    private void checkValues(ContentHints contentHints, DERObjectIdentifier dERObjectIdentifier, DERUTF8String dERUTF8String) {
        this.checkMandatoryField("contentType", dERObjectIdentifier, contentHints.getContentType());
        this.checkOptionalField("description", dERUTF8String, contentHints.getContentDescription());
    }

    public static void main(String[] stringArray) {
        ContentHintsUnitTest.runTest(new ContentHintsUnitTest());
    }
}

