/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1Encodable;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1OutputStream;
import edu.illinois.ncsa.bouncycastle.asn1.DERIA5String;
import edu.illinois.ncsa.bouncycastle.asn1.DERObject;
import edu.illinois.ncsa.bouncycastle.asn1.misc.CAST5CBCParameters;
import edu.illinois.ncsa.bouncycastle.asn1.misc.IDEACBCPar;
import edu.illinois.ncsa.bouncycastle.asn1.misc.NetscapeCertType;
import edu.illinois.ncsa.bouncycastle.asn1.misc.NetscapeRevocationURL;
import edu.illinois.ncsa.bouncycastle.asn1.misc.VerisignCzagExtension;
import edu.illinois.ncsa.bouncycastle.util.encoders.Base64;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTestResult;
import edu.illinois.ncsa.bouncycastle.util.test.Test;
import edu.illinois.ncsa.bouncycastle.util.test.TestResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class MiscTest
implements Test {
    private boolean isSameAs(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i != byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public TestResult perform() {
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[]{new CAST5CBCParameters(byArray, 128), new NetscapeCertType(32), new VerisignCzagExtension(new DERIA5String("hello")), new IDEACBCPar(byArray), new NetscapeRevocationURL(new DERIA5String("http://test"))};
        byte[] byArray2 = Base64.decode("MA4ECAECAwQFBgcIAgIAgAMCBSAWBWhlbGxvMAoECAECAwQFBgcIFgtodHRwOi8vdGVzdA==");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            for (int i = 0; i != aSN1EncodableArray.length; ++i) {
                aSN1OutputStream.writeObject(aSN1EncodableArray[i]);
            }
            DERObject[] dERObjectArray = new DERObject[aSN1EncodableArray.length];
            if (!this.isSameAs(byteArrayOutputStream.toByteArray(), byArray2)) {
                return new SimpleTestResult(false, this.getName() + ": Failed data check");
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            for (int i = 0; i != aSN1EncodableArray.length; ++i) {
                DERObject dERObject = aSN1InputStream.readObject();
                if (!aSN1EncodableArray[i].equals(dERObject)) {
                    return new SimpleTestResult(false, this.getName() + ": Failed equality test for " + dERObject);
                }
                if (dERObject.hashCode() == aSN1EncodableArray[i].hashCode()) continue;
                return new SimpleTestResult(false, this.getName() + ": Failed hashCode test for " + dERObject);
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": Failed - exception " + exception.toString(), exception);
        }
    }

    public String getName() {
        return "Misc";
    }

    public static void main(String[] stringArray) {
        MiscTest miscTest = new MiscTest();
        TestResult testResult = miscTest.perform();
        System.out.println(testResult);
    }
}

