/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1Object;
import edu.illinois.ncsa.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import edu.illinois.ncsa.bouncycastle.util.Arrays;
import edu.illinois.ncsa.bouncycastle.util.encoders.Base64;
import edu.illinois.ncsa.bouncycastle.util.encoders.Hex;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;
import java.io.IOException;

public class SubjectKeyIdentifierTest
extends SimpleTest {
    private static byte[] pubKeyInfo = Base64.decode("MFgwCwYJKoZIhvcNAQEBA0kAMEYCQQC6wMMmHYMZszT/7bNFMn+gaZoiWJLVP8ODRuu1C2jeAeQpxM+5Oe7PaN2GNy3nBE4EOYkB5pMJWA0y9n04FX8NAgED");
    private static byte[] shaID = Hex.decode("d8128a06d6c2feb0865994a2936e7b75b836a021");
    private static byte[] shaTruncID = Hex.decode("436e7b75b836a021");

    public String getName() {
        return "SubjectKeyIdentifier";
    }

    public void performTest() throws IOException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(ASN1Object.fromByteArray(pubKeyInfo));
        SubjectKeyIdentifier subjectKeyIdentifier = SubjectKeyIdentifier.createSHA1KeyIdentifier(subjectPublicKeyInfo);
        if (!Arrays.areEqual(shaID, subjectKeyIdentifier.getKeyIdentifier())) {
            this.fail("SHA-1 ID does not match");
        }
        if (!Arrays.areEqual(shaTruncID, (subjectKeyIdentifier = SubjectKeyIdentifier.createTruncatedSHA1KeyIdentifier(subjectPublicKeyInfo)).getKeyIdentifier())) {
            this.fail("truncated SHA-1 ID does not match");
        }
    }

    public static void main(String[] stringArray) {
        SubjectKeyIdentifierTest.runTest(new SubjectKeyIdentifierTest());
    }
}

