/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.agreement;

import edu.illinois.ncsa.bouncycastle.crypto.BasicAgreement;
import edu.illinois.ncsa.bouncycastle.crypto.CipherParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.AsymmetricKeyParameter;
import edu.illinois.ncsa.bouncycastle.crypto.params.DHParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.DHPrivateKeyParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.DHPublicKeyParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.ParametersWithRandom;
import java.math.BigInteger;

public class DHBasicAgreement
implements BasicAgreement {
    private DHPrivateKeyParameters key;
    private DHParameters dhParams;

    public void init(CipherParameters cipherParameters) {
        AsymmetricKeyParameter asymmetricKeyParameter;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            asymmetricKeyParameter = (AsymmetricKeyParameter)parametersWithRandom.getParameters();
        } else {
            asymmetricKeyParameter = (AsymmetricKeyParameter)cipherParameters;
        }
        if (!(asymmetricKeyParameter instanceof DHPrivateKeyParameters)) {
            throw new IllegalArgumentException("DHEngine expects DHPrivateKeyParameters");
        }
        this.key = (DHPrivateKeyParameters)asymmetricKeyParameter;
        this.dhParams = this.key.getParameters();
    }

    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        DHPublicKeyParameters dHPublicKeyParameters = (DHPublicKeyParameters)cipherParameters;
        if (!dHPublicKeyParameters.getParameters().equals(this.dhParams)) {
            throw new IllegalArgumentException("Diffie-Hellman public key has wrong parameters.");
        }
        return dHPublicKeyParameters.getY().modPow(this.key.getX(), this.dhParams.getP());
    }
}

