/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.tls;

import edu.illinois.ncsa.bouncycastle.crypto.tls.SecurityParameters;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsClientContext;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsProtocolVersion;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;

class TlsClientContextImpl
implements TlsClientContext {
    private SecureRandom secureRandom;
    private SecurityParameters securityParameters;
    private TlsProtocolVersion clientVersion;
    private TlsProtocolVersion negotiatedVersion;
    private Object userObject = null;

    TlsClientContextImpl(SecureRandom secureRandom, SecurityParameters securityParameters, TlsProtocolVersion tlsProtocolVersion, TlsProtocolVersion tlsProtocolVersion2) {
        this.secureRandom = secureRandom;
        this.securityParameters = securityParameters;
        this.clientVersion = tlsProtocolVersion;
        this.negotiatedVersion = tlsProtocolVersion2;
    }

    public SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public SecurityParameters getSecurityParameters() {
        return this.securityParameters;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public void writeClientVersion(byte[] byArray, int n) {
        byArray[n] = (byte)this.clientVersion.getMajorVersion();
        byArray[n + 1] = (byte)this.clientVersion.getMinorVersion();
    }

    public void setNegotiatedVersion(TlsProtocolVersion tlsProtocolVersion) {
        this.negotiatedVersion = tlsProtocolVersion;
    }

    public void writeVersion(OutputStream outputStream) throws IOException {
        outputStream.write(this.negotiatedVersion.getMajorVersion());
        outputStream.write(this.negotiatedVersion.getMinorVersion());
    }

    public void writeVersion(byte[] byArray, int n) {
        byArray[n] = (byte)this.negotiatedVersion.getMajorVersion();
        byArray[n + 1] = (byte)this.negotiatedVersion.getMinorVersion();
    }

    public TlsProtocolVersion getNegotiatedVersion() {
        return this.negotiatedVersion;
    }
}

