/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.util.io.pem;

import edu.illinois.ncsa.bouncycastle.util.io.pem.PemHeader;
import edu.illinois.ncsa.bouncycastle.util.io.pem.PemObject;
import edu.illinois.ncsa.bouncycastle.util.io.pem.PemWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class AllTests
extends TestCase {
    public void testPemLength() throws IOException {
        for (int i = 1; i != 60; ++i) {
            this.lengthTest("CERTIFICATE", Collections.EMPTY_LIST, new byte[i]);
        }
        this.lengthTest("CERTIFICATE", Collections.EMPTY_LIST, new byte[100]);
        this.lengthTest("CERTIFICATE", Collections.EMPTY_LIST, new byte[101]);
        this.lengthTest("CERTIFICATE", Collections.EMPTY_LIST, new byte[102]);
        this.lengthTest("CERTIFICATE", Collections.EMPTY_LIST, new byte[103]);
        this.lengthTest("CERTIFICATE", Collections.EMPTY_LIST, new byte[1000]);
        this.lengthTest("CERTIFICATE", Collections.EMPTY_LIST, new byte[1001]);
        this.lengthTest("CERTIFICATE", Collections.EMPTY_LIST, new byte[1002]);
        this.lengthTest("CERTIFICATE", Collections.EMPTY_LIST, new byte[1003]);
        ArrayList<PemHeader> arrayList = new ArrayList<PemHeader>();
        arrayList.add(new PemHeader("Proc-Type", "4,ENCRYPTED"));
        arrayList.add(new PemHeader("DEK-Info", "DES3,0001020304050607"));
        this.lengthTest("RSA PRIVATE KEY", arrayList, new byte[103]);
    }

    private void lengthTest(String string, List list, byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PemWriter pemWriter = new PemWriter(new OutputStreamWriter(byteArrayOutputStream));
        PemObject pemObject = new PemObject(string, list, byArray);
        pemWriter.writeObject(pemObject);
        pemWriter.close();
        AllTests.assertEquals((int)byteArrayOutputStream.toByteArray().length, (int)pemWriter.getOutputSize(pemObject));
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)AllTests.suite());
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("util tests");
        testSuite.addTestSuite(AllTests.class);
        return testSuite;
    }
}

