/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.filters.examples;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import lia.util.net.copy.filters.Postprocessor;
import lia.util.net.copy.filters.ProcessorInfo;

public class PostRename
implements Postprocessor {
    public static final String PREFIX = "prefix";
    public static final String DEFAULT_PREFIX = "RENAMED_";
    private static final Logger logger = Logger.getLogger(PostRename.class.getName());

    @Override
    public void postProcessFileList(ProcessorInfo processorInfo, Subject peerSubject, Throwable downCause, String downMessage) throws Exception {
        logger.log(Level.INFO, " [ PostRename ] Subject: " + peerSubject);
        String filePrefix = System.getProperty(PREFIX, DEFAULT_PREFIX);
        for (int i = 0; i < processorInfo.fileList.length; ++i) {
            try {
                String name = processorInfo.fileList[i];
                String outFilename = processorInfo.destinationDir + File.separator + filePrefix + name;
                String orgFileName = processorInfo.destinationDir + File.separator + name;
                logger.log(Level.INFO, "Renaming file: " + name + " to: " + filePrefix + name);
                new File(orgFileName).renameTo(new File(outFilename));
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

