/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.gui.session;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.swing.filechooser.FileSystemView;
import lia.util.net.copy.gui.session.Session;

public class LocalSession
extends Session {
    private static FileSystemView local = FileSystemView.getFileSystemView();
    private final HashMap<String, File> roots = new HashMap();
    public String currentDir;
    public String userDir;
    public String osName;
    private boolean canWrite = true;
    private File currentFile = local.getHomeDirectory();

    public LocalSession() {
        this.currentDir = this.currentFile.getAbsolutePath();
        this.osName = System.getProperty("os.name");
        this.userDir = System.getProperty("user.home");
        this.update();
    }

    public static void main(String[] args) {
        int i;
        File f = new File("E:\\cipsm");
        f = local.getChild(f, "..");
        File[] roots = local.getFiles(f, false);
        for (i = 0; i < roots.length; ++i) {
            System.out.println(roots[i].isDirectory() + "'" + local.getSystemDisplayName(roots[i]) + "'" + local.getSystemTypeDescription(roots[i]) + "'" + local.getSystemDisplayName(roots[i]).length());
        }
        System.out.println("....");
        roots = f.listFiles();
        for (i = 0; i < roots.length; ++i) {
            System.out.println("'" + local.getSystemDisplayName(roots[i]) + "'" + local.getSystemTypeDescription(roots[i]) + "'" + local.getSystemDisplayName(roots[i]).length());
        }
    }

    @Override
    public void setAbsoluteDir(String dir) {
        if (dir == null) {
            return;
        }
        if (this.roots.containsKey(dir = this.getRoot(dir))) {
            this.currentFile = this.roots.get(dir);
            this.currentDir = this.currentFile.getAbsolutePath();
            this.update();
            return;
        }
        try {
            File f = new File(dir);
            if (!(f.exists() && f.isDirectory() && f.canRead())) {
                return;
            }
            this.currentFile = f;
            this.currentDir = this.currentFile.getAbsolutePath();
            this.update();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final String getRoot(String dir) {
        if (this.roots.containsKey(dir)) {
            return dir;
        }
        for (Map.Entry<String, File> entry : this.roots.entrySet()) {
            if (!entry.getValue().getAbsolutePath().equals(dir)) continue;
            return entry.getKey();
        }
        return dir;
    }

    @Override
    public void setRelativeDir(String dir) {
        File f = local.getChild(this.currentFile, dir);
        if (f == null || !f.exists() || !f.isDirectory()) {
            return;
        }
        this.currentFile = f;
        this.currentDir = f.getAbsolutePath();
        this.update();
    }

    @Override
    public void setUpDir() {
        File f = local.getParentDirectory(this.currentFile);
        if (f == null || !f.exists() || !f.isDirectory()) {
            return;
        }
        this.currentFile = f;
        this.currentDir = f.getAbsolutePath();
        this.update();
    }

    @Override
    public String[] getRoots() {
        String p;
        File f;
        String displayName;
        int i;
        this.roots.clear();
        HashSet<String> h = new HashSet<String>();
        File[] roots = local.getRoots();
        if (roots != null) {
            for (i = 0; i < roots.length; ++i) {
                displayName = local.getSystemDisplayName(roots[i]);
                if (h.contains(displayName) || displayName.length() == 0) continue;
                h.add(displayName);
                this.roots.put(displayName, roots[i]);
            }
        }
        if ((roots = File.listRoots()) != null) {
            for (i = 0; i < roots.length; ++i) {
                displayName = local.getSystemDisplayName(roots[i]);
                if (h.contains(displayName) || displayName.length() == 0) continue;
                h.add(displayName);
                this.roots.put(displayName, roots[i]);
            }
        }
        if (System.getProperty("os.name").toLowerCase(Locale.US).contains("linux") && (f = new File(p = System.getProperty("user.home"))).exists()) {
            File pa = null;
            while ((pa = f.getParentFile()) != null && pa.exists()) {
                this.roots.put(f.getAbsolutePath(), f);
                f = pa;
            }
        }
        String[] keys = new String[this.roots.size()];
        Iterator<String> it = this.roots.keySet().iterator();
        for (int i2 = 0; it.hasNext() && i2 < keys.length; ++i2) {
            keys[i2] = it.next();
        }
        return keys;
    }

    @Override
    public String getShortRootName(String rootFolder) {
        if (rootFolder == null) {
            return null;
        }
        if (this.roots.containsKey(rootFolder = this.getRoot(rootFolder))) {
            return this.roots.get(rootFolder).getAbsolutePath();
        }
        return null;
    }

    @Override
    public boolean isRoot() {
        if (local.isDrive(this.currentFile)) {
            return true;
        }
        File f = local.getParentDirectory(this.currentFile);
        return f == null;
    }

    private void update() {
        int i;
        this.dirs.clear();
        this.length.clear();
        this.icons.clear();
        this.modif.clear();
        this.read.clear();
        this.write.clear();
        File[] l = local.getFiles(this.currentFile, false);
        if (l != null) {
            for (i = 0; i < l.length; ++i) {
                String fn = local.getSystemDisplayName(l[i]);
                if (fn.length() == 0) continue;
                if (l[i].isDirectory()) {
                    try {
                        File tmpf = local.getChild(this.currentFile, fn);
                        if (tmpf == null || !local.isTraversable(tmpf).booleanValue()) continue;
                        local.getFiles(tmpf, false);
                    }
                    catch (Throwable t) {
                        continue;
                    }
                    this.dirs.add(fn);
                    this.icons.put(fn, local.getSystemIcon(l[i]));
                    this.modif.put(fn, l[i].lastModified());
                    this.read.put(fn, l[i].canRead());
                    this.write.put(fn, l[i].canWrite());
                    continue;
                }
                if (!l[i].isFile()) continue;
                this.length.put(fn, l[i].length());
                this.icons.put(fn, local.getSystemIcon(l[i]));
                this.modif.put(fn, l[i].lastModified());
                this.read.put(fn, l[i].canRead());
                this.write.put(fn, l[i].canWrite());
            }
        }
        try {
            File f;
            i = 0;
            while ((f = new File(this.currentDir + System.getProperty("file.separator") + "fdt" + i)).exists()) {
            }
            f.createNewFile();
            this.canWrite = f.exists();
            if (this.canWrite) {
                f.delete();
            }
        }
        catch (Throwable t) {
            this.canWrite = false;
        }
    }

    @Override
    public String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    @Override
    public String getWorkingDir() {
        return this.currentDir;
    }

    @Override
    public boolean canWrite() {
        return this.canWrite;
    }

    @Override
    public String getOSName() {
        return this.osName;
    }

    @Override
    public String getUserDir() {
        return this.userDir;
    }

    @Override
    public boolean fileExists(String fileName) {
        if (fileName == null) {
            return false;
        }
        return this.modif.containsKey(fileName);
    }

    @Override
    public void removeFiles(String[] files) {
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            try {
                File[] ff;
                File f = new File(files[i]);
                if (f.isDirectory() && (ff = f.listFiles()) != null) {
                    String[] str = new String[ff.length];
                    for (int j = 0; j < str.length; ++j) {
                        str[j] = ff[j].getAbsolutePath();
                    }
                    this.removeFiles(str);
                }
                f.delete();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.update();
    }

    @Override
    public void createDir(String name) {
        try {
            File f = new File(name);
            f.mkdirs();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.update();
    }

    @Override
    public String freeSpace() {
        if (this.currentFile == null) {
            return null;
        }
        try {
            long space = this.currentFile.getFreeSpace();
            return this.parseSize(space);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private final String parseSize(long space) {
        if (space > 1024L) {
            if ((space /= 1024L) > 1024L) {
                if ((space /= 1024L) > 1024L) {
                    if ((space /= 1024L) > 1024L) {
                        return (space /= 1024L) + " TB";
                    }
                    return space + " GB";
                }
                return space + " MB";
            }
            return space + "KB";
        }
        return space + " B";
    }
}

