/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.monitoring.lisa;

import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.copy.monitoring.lisa.cmdExec;

public class MacHostPropertiesMonitor {
    protected static final Object lock = new Object();
    protected static int ptnr = 0;
    protected final Logger logger;
    protected String[] networkInterfaces;
    protected String activeInterface;
    protected String cpuUsage = "0";
    protected String cpuUSR = "0";
    protected String cpuSYS = "0";
    protected String cpuIDLE = "0";
    protected String nbProcesses = "0";
    protected String load1 = "0";
    protected String load5 = "0";
    protected String load15 = "0";
    protected String memUsed = "0";
    protected String memFree = "0";
    protected String memUsage = "0";
    protected String netIn = "0";
    protected String netOut = "0";
    protected String pagesIn = "0";
    protected String pagesOut = "0";
    protected String macAddress = "unknown";
    protected String diskIO = "0";
    protected String diskIn = "0";
    protected String diskOut = "0";
    protected String diskFree = "0";
    protected String diskUsed = "0";
    protected String diskTotal = "0";
    protected String command = "";
    protected cmdExec execute = null;
    protected String sep = null;

    public MacHostPropertiesMonitor(Logger logger) {
        this.logger = logger;
        this.execute = cmdExec.getInstance();
        this.sep = System.getProperty("file.separator");
        this.command = this.sep + "sbin" + this.sep + "ifconfig -l -u";
        cmdExec.CommandResult cmdRes = this.execute.executeCommand(this.command, "lo0", 3000L);
        String result = cmdRes.getOutput();
        if (result == null || result.equals("")) {
            logger.warning(this.command + ": No result???");
        } else {
            int where = result.indexOf("lo0");
            this.networkInterfaces = result.substring(where + 3, result.length()).replaceAll("  ", " ").trim().split(" ");
            for (int i = 0; i < this.networkInterfaces.length; ++i) {
                String current = this.networkInterfaces[i];
                this.command = this.sep + "sbin" + this.sep + "ifconfig " + current;
                cmdRes = this.execute.executeCommand(this.command, current, 3000L);
                result = cmdRes.getOutput();
                if (result == null || result.equals("")) {
                    logger.warning(this.command + ": No result???");
                    continue;
                }
                if (result.indexOf("inet ") == -1) continue;
                int pointI = result.indexOf("ether");
                int pointJ = result.indexOf("media", pointI);
                this.macAddress = result.substring(pointI + 5, pointJ).trim();
                this.activeInterface = current;
            }
        }
        this.command = this.sep + "bin" + this.sep + "df -k -h " + this.sep;
        cmdRes = this.execute.executeCommand(this.command, "/dev", 3000L);
        result = cmdRes.getOutput();
        if (result == null || result.equals("")) {
            logger.warning(this.command + ": No result???");
        } else {
            this.parseDf(result);
        }
        this.update();
    }

    public String getMacAddresses() {
        return this.macAddress;
    }

    public void update() {
        if (this.execute == null) {
            this.execute = cmdExec.getInstance();
        }
        this.command = this.sep + "usr" + this.sep + "bin" + this.sep + "top -d -l2 -n1 -F -R -X";
        cmdExec.CommandResult cmdRes = this.execute.executeCommand(this.command, "PID", 2, 100000L);
        String result = cmdRes.getOutput();
        if (result == null || result.equals("")) {
            this.logger.warning("No result???");
        } else {
            this.parseTop(result);
        }
    }

    private void parseDf(String toParse) {
        int pointI = toParse.indexOf("/dev/");
        int pointJ = 0;
        int pointK = 0;
        try {
            pointJ = toParse.indexOf(" ", pointI);
            pointK = this.indexOfUnitLetter(toParse, pointJ);
            this.diskTotal = toParse.substring(pointJ, pointK).trim();
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            pointI = toParse.indexOf(" ", pointK);
            pointJ = this.indexOfUnitLetter(toParse, pointI);
            this.diskUsed = toParse.substring(pointI, pointJ).trim();
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            pointK = toParse.indexOf(" ", pointJ);
            pointI = this.indexOfUnitLetter(toParse, pointK);
            this.diskFree = toParse.substring(pointK, pointI).trim();
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private int indexOfUnitLetter(String inside, int from) {
        int temp = inside.indexOf(75, from);
        if (!(temp != -1 && temp - from <= 10 || (temp = inside.indexOf(77, from)) != -1 && temp - from <= 10 || (temp = inside.indexOf(71, from)) != -1 && temp - from <= 10 || (temp = inside.indexOf(66, from)) != -1 && temp - from <= 10 || (temp = inside.indexOf(84, from)) != -1 && temp - from <= 10 || (temp = inside.indexOf(98, from)) - from <= 10)) {
            temp = -1;
        }
        return temp;
    }

    private int lastIndexOfUnitLetter(String inside, int from) {
        int temp = inside.lastIndexOf(75, from);
        if (!(temp != -1 && from - temp <= 10 || (temp = inside.lastIndexOf(77, from)) != -1 && from - temp <= 10 || (temp = inside.lastIndexOf(71, from)) != -1 && from - temp <= 10 || (temp = inside.lastIndexOf(66, from)) != -1 && from - temp <= 10 || (temp = inside.lastIndexOf(84, from)) != -1 && from - temp <= 10 || from - (temp = inside.lastIndexOf(98, from)) <= 10)) {
            temp = -1;
        }
        return temp;
    }

    private double howMuchMegaBytes(char a) {
        switch (a) {
            case 'T': {
                return 1048576.0;
            }
            case 'G': {
                return 1024.0;
            }
            case 'M': {
                return 1.0;
            }
            case 'K': {
                return 9.765625E-4;
            }
            case 'B': {
                return 9.537E-7;
            }
        }
        return 1.0;
    }

    private void parseTop(String toParse) {
        int pointA = 0;
        int pointB = 0;
        int unitPos = 0;
        double sum = 0.0;
        try {
            pointA = toParse.indexOf("Procs:");
            pointA = toParse.indexOf("Procs:", pointA + 6) + 6;
            pointB = toParse.indexOf(",", pointA + 1);
            this.nbProcesses = toParse.substring(pointA, pointB).trim();
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            pointA = toParse.indexOf("LoadAvg:", pointA);
            pointB = toParse.indexOf(",", pointA += 9);
            this.load1 = toParse.substring(pointA, pointB).trim();
            pointA = toParse.indexOf(",", pointB + 1);
            this.load5 = toParse.substring(pointB + 1, pointA).trim();
            pointB = toParse.indexOf("CPU:", pointA + 1);
            pointB = toParse.lastIndexOf(".", pointB);
            this.load15 = toParse.substring(pointA + 1, pointB).trim();
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            pointB = toParse.indexOf("CPU:", pointB + 1) + 4;
            pointA = toParse.indexOf("% user", pointB);
            this.cpuUSR = toParse.substring(pointB, pointA).trim();
            pointA = toParse.indexOf(",", pointA);
            pointB = toParse.indexOf("% sys", pointA + 1);
            this.cpuSYS = toParse.substring(pointA + 1, pointB).trim();
            pointA = toParse.indexOf(",", pointB);
            pointB = toParse.indexOf("% idle", pointA + 1);
            this.cpuIDLE = toParse.substring(pointA + 1, pointB).trim();
            sum = 100.0 - Double.parseDouble(this.cpuIDLE);
            this.cpuUsage = String.valueOf(sum);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            pointA = toParse.indexOf("PhysMem", pointB);
            pointB = toParse.indexOf("M used", pointA += 8);
            pointA = toParse.lastIndexOf(",", pointB);
            this.memUsed = toParse.substring(pointA + 1, pointB).trim();
            pointB = toParse.indexOf("M free", pointB);
            pointA = toParse.lastIndexOf(",", pointB);
            this.memFree = toParse.substring(pointA + 1, pointB).trim();
            sum = Double.parseDouble(this.memUsed) + Double.parseDouble(this.memFree);
            double percentage = (double)Integer.parseInt(this.memUsed) / sum * 100.0;
            this.memUsage = String.valueOf(percentage);
        }
        catch (StringIndexOutOfBoundsException percentage) {
            // empty catch block
        }
        try {
            pointA = toParse.indexOf("VirtMem:", pointB + 6);
            pointB = toParse.indexOf("pagein", pointA);
            pointA = toParse.lastIndexOf(",", pointB);
            this.pagesIn = toParse.substring(pointA + 1, pointB).trim();
            pointA = toParse.indexOf("pageout", pointB);
            pointB = toParse.lastIndexOf(",", pointA);
            this.pagesOut = toParse.substring(pointB + 1, pointA).trim();
        }
        catch (StringIndexOutOfBoundsException e) {
            this.logger.warning("Can't find pages in :" + toParse);
        }
        try {
            pointA = toParse.indexOf("Networks:", pointB) + 9;
            pointB = toParse.indexOf("data =", pointA) + 6;
            pointA = toParse.indexOf("in", pointB);
            unitPos = this.lastIndexOfUnitLetter(toParse, pointA);
            this.netIn = toParse.substring(pointB, unitPos).trim();
            double factor = this.howMuchMegaBytes(toParse.substring(unitPos, unitPos + 1).toCharArray()[0]);
            this.netIn = String.valueOf(Double.parseDouble(this.netIn) * factor * 4.0);
            pointB = toParse.indexOf("out", pointA);
            unitPos = this.lastIndexOfUnitLetter(toParse, pointB);
            factor = this.howMuchMegaBytes(toParse.substring(unitPos, unitPos + 1).toCharArray()[0]);
            this.netOut = toParse.substring(pointA + 3, unitPos).trim();
            this.netOut = String.valueOf(Double.parseDouble(this.netOut) * factor);
        }
        catch (StringIndexOutOfBoundsException e) {
            this.logger.log(Level.INFO, "Got exception", e);
        }
        try {
            pointB = toParse.indexOf("Disks:", pointA) + 6;
            pointA = toParse.indexOf("data =", pointB) + 6;
            pointB = toParse.indexOf("in,", pointA);
            unitPos = this.lastIndexOfUnitLetter(toParse, pointB);
            this.diskIn = toParse.substring(pointA, unitPos).trim();
            pointA = toParse.indexOf("out", pointB);
            unitPos = this.lastIndexOfUnitLetter(toParse, pointA);
            this.diskIO = this.diskOut = toParse.substring(pointB + 3, unitPos).trim();
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public String getCpuUsage() {
        return this.cpuUsage;
    }

    public String getCpuUSR() {
        return this.cpuUSR;
    }

    public String getCpuSYS() {
        return this.cpuSYS;
    }

    public String getCpuNICE() {
        return "0";
    }

    public String getCpuIDLE() {
        return this.cpuIDLE;
    }

    public String getPagesIn() {
        return this.pagesIn;
    }

    public String getPagesOut() {
        return this.pagesOut;
    }

    public String getMemUsage() {
        return this.memUsage;
    }

    public String getMemUsed() {
        return this.memUsed;
    }

    public String getMemFree() {
        return this.memFree;
    }

    public String getDiskIO() {
        return this.diskIO;
    }

    public String getDiskTotal() {
        return this.diskTotal;
    }

    public String getDiskUsed() {
        return this.diskUsed;
    }

    public String getDiskFree() {
        return this.diskFree;
    }

    public String getNoProcesses() {
        return this.nbProcesses;
    }

    public String getLoad1() {
        return this.load1;
    }

    public String getLoad5() {
        return this.load5;
    }

    public String getLoad15() {
        return this.load15;
    }

    public String[] getNetInterfaces() {
        return this.networkInterfaces;
    }

    public String getNetIn(String ifName) {
        if (ifName.equalsIgnoreCase(this.activeInterface)) {
            return this.netIn;
        }
        return "0";
    }

    public String getNetOut(String ifName) {
        if (ifName.equalsIgnoreCase(this.activeInterface)) {
            return this.netOut;
        }
        return "0";
    }
}

