/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.transport;

import java.net.InetAddress;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.common.Config;
import lia.util.net.common.Utils;
import lia.util.net.copy.FDTSession;
import lia.util.net.copy.FileBlockConsumer;
import lia.util.net.copy.transport.FDTReaderKeyAttachement;
import lia.util.net.copy.transport.SocketReaderTask;
import lia.util.net.copy.transport.TCPTransportProvider;
import lia.util.net.copy.transport.internal.FDTSelectionKey;
import lia.util.net.copy.transport.internal.SelectionManager;

public class TCPSessionReader
extends TCPTransportProvider {
    private static final Logger logger = Logger.getLogger(TCPSessionReader.class.getName());
    private static final SelectionManager selectionManager = SelectionManager.getInstance();
    private static final Config config = Config.getInstance();
    private FileBlockConsumer fileBlockConsumer;

    public TCPSessionReader(FDTSession fdtSession, FileBlockConsumer fileBlockConsumer) throws Exception {
        super(fdtSession);
        this.fileBlockConsumer = fileBlockConsumer;
    }

    public TCPSessionReader(FDTSession fdtSession, FileBlockConsumer fileBlockConsumer, InetAddress endPointAddress, int port, int numberOfStreams) throws Exception {
        super(fdtSession, endPointAddress, port, numberOfStreams);
        this.fileBlockConsumer = fileBlockConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWorkerStream(SocketChannel sc, boolean sentCookie) throws Exception {
        Object object = this.closeLock;
        synchronized (object) {
            super.addWorkerStream(sc, sentCookie);
            FDTSelectionKey fsk = null;
            if (config.isBlocking()) {
                fsk = new FDTSelectionKey(this.fdtSession.sessionID(), sc, 1, this, null);
                fsk.attach(new FDTReaderKeyAttachement(fsk, this.fdtSession.useFixedBlockSize()));
                this.selectionQueue.add(fsk);
                SocketReaderTask socketTask = new SocketReaderTask(this.selectionQueue, this.fileBlockConsumer, this);
                if (this.addSocketTask(socketTask)) {
                    this.executor.submit(socketTask);
                } else {
                    this.close("Unable to add a new SocketTask. OOM?", null);
                }
            } else {
                fsk = selectionManager.register(this.fdtSession.sessionID(), sc, 1, this);
                fsk.attach(new FDTReaderKeyAttachement(fsk, this.fdtSession.useFixedBlockSize()));
                if (!fsk.registerInterest()) {
                    logger.log(Level.WARNING, " \n\n Smth went terrible wrong ?? \n\n fsk.registerInterest() returned false \n\n");
                }
            }
            this.channels.put(sc, fsk);
        }
    }

    public void workerDown(FDTSelectionKey fdtSelectionKey, Throwable downCause) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startTransport(boolean sendCookie) throws Exception {
        super.startTransport(sendCookie);
        Object object = this.closeLock;
        synchronized (object) {
            if (!config.isBlocking()) {
                for (int i = 0; i <= Utils.availableProcessors() * 2; ++i) {
                    SocketReaderTask socketTask = new SocketReaderTask(this.selectionQueue, this.fileBlockConsumer, this);
                    if (this.addSocketTask(socketTask)) {
                        this.executor.submit(socketTask);
                        continue;
                    }
                    this.close("Unable to add a new SocketTask. OOM?", null);
                }
            }
        }
    }
}

