/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.jiperf;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import lia.util.net.jiperf.ByteBufferPool;
import lia.util.net.jiperf.JIperf;

public class JIperfServer {
    private static final transient Logger logger = Logger.getLogger(JIperfServer.class.getName());
    ServerSocketChannel ssc;
    ServerSocket ss;
    Selector sel;
    int port;
    ByteBufferPool buffPool;
    ExecutorService executor;
    boolean sshMode = false;
    String allowedIP = null;
    int connectionNo;
    int windowSize;

    public JIperfServer(HashMap<String, String> config) throws Exception {
        if (config.containsKey("-ssh")) {
            this.sshMode = true;
            this.initSSH();
        } else {
            this.port = Integer.parseInt(config.get("-p"));
            this.init();
        }
    }

    private void init() throws Exception {
        this.buffPool = ByteBufferPool.getInstance();
        this.executor = JIperf.getExecutor();
        this.ssc = ServerSocketChannel.open();
        this.ssc.configureBlocking(false);
        this.ss = this.ssc.socket();
        this.ss.bind(new InetSocketAddress(this.port));
        this.sel = Selector.open();
        this.ssc.register(this.sel, 16);
    }

    private void initSSH() throws Exception {
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        try {
            System.out.println("ACK1");
            this.allowedIP = stdin.readLine();
            this.port = Integer.parseInt(stdin.readLine());
            this.connectionNo = Integer.parseInt(stdin.readLine());
            this.windowSize = Integer.parseInt(stdin.readLine());
            System.err.println("Conection parameters received: IP: " + this.allowedIP + " PORT: " + this.port + " STREAMS: " + this.connectionNo + " WSIZE: " + this.windowSize);
            this.init();
            System.out.println("ACK2");
        }
        catch (Throwable t) {
            System.err.println("Invalid connection parameters" + t.getMessage());
            this.ssc.close();
            this.ss.close();
            System.exit(1);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void doWork() throws Exception {
        block0: while (true) {
            if (this.sel.select() > 0) {
                continue;
            }
            it = this.sel.selectedKeys().iterator();
            while (true) {
                if (it.hasNext()) ** break;
                continue block0;
                sk = it.next();
                if (sk.isAcceptable()) {
                    ssc = (ServerSocketChannel)sk.channel();
                    sc = ssc.accept();
                    if (!this.sshMode) {
                        sc.configureBlocking(false);
                        sc.register(this.sel, 1);
                    } else if (this.allowedIP != null && !this.allowedIP.equals(sc.socket().getInetAddress().getHostAddress())) {
                        System.err.println(" [" + this.allowedIP + "] does not match " + sc.socket().getInetAddress().getHostAddress());
                        sc.close();
                    } else {
                        sc.configureBlocking(false);
                        sc.register(this.sel, 1);
                        if (--this.connectionNo == 0) {
                            this.ssc.keyFor(this.sel).cancel();
                            this.ssc.close();
                        }
                    }
                } else if (sk.isReadable()) {
                    sk.interestOps(sk.interestOps() & -2);
                    this.executor.execute(new ReaderTask(sk));
                }
                it.remove();
            }
            break;
        }
    }

    class ReaderTask
    implements Runnable {
        SelectionKey sk;
        ByteBuffer buff;

        ReaderTask(SelectionKey sk) {
            this.sk = sk;
            this.buff = JIperfServer.this.buffPool.get();
        }

        private void readData() throws Exception {
            this.buff.clear();
            SocketChannel sc = (SocketChannel)this.sk.channel();
            int count = -1;
            while ((count = sc.read(this.buff)) > 0) {
                this.buff.clear();
            }
            if (count < 0) {
                sc.close();
            } else {
                this.sk.interestOps(this.sk.interestOps() | 1);
            }
            JIperfServer.this.sel.wakeup();
        }

        @Override
        public void run() {
            if (this.sk == null) {
                return;
            }
            try {
                this.readData();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                JIperfServer.this.buffPool.put(this.buff);
            }
        }
    }
}

