/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi.net.example;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.gssapi.GlobusGSSManagerImpl;
import org.globus.gsi.gssapi.net.GssSocket;
import org.globus.gsi.gssapi.net.GssSocketFactory;
import org.globus.gsi.gssapi.net.example.GetOpts;
import org.gridforum.jgss.ExtendedGSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;

class Client
extends Thread {
    GetOpts opts;
    Socket s;
    private static GSSCredential cred;

    public Client(Socket s, GetOpts opts) {
        this.s = s;
        this.opts = opts;
    }

    private static GSSCredential getCredential(GSSManager manager) throws Exception {
        if (cred == null) {
            cred = manager.createCredential(0);
        }
        return cred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        System.out.println("client connected");
        GlobusGSSManagerImpl manager = new GlobusGSSManagerImpl();
        ExtendedGSSContext context = null;
        try {
            GSSCredential credd = Client.getCredential(manager);
            context = (ExtendedGSSContext)((GSSManager)manager).createContext(credd);
            context.requestConf(this.opts.conf);
            context.setOption(GSSConstants.GSS_MODE, this.opts.gsiMode ? GSIConstants.MODE_GSI : GSIConstants.MODE_SSL);
            context.setOption(GSSConstants.REJECT_LIMITED_PROXY, new Boolean(this.opts.rejectLimitedProxy));
            context.setOption(GSSConstants.REQUIRE_CLIENT_AUTH, new Boolean(!this.opts.anonymity));
            this.s = GssSocketFactory.getDefault().createSocket(this.s, null, 0, context);
            ((GssSocket)this.s).setUseClientMode(false);
            ((GssSocket)this.s).setWrapMode(this.opts.wrapMode);
            OutputStream out = this.s.getOutputStream();
            InputStream in = this.s.getInputStream();
            System.out.println("Context established.");
            System.out.println("Initiator : " + context.getSrcName());
            System.out.println("Acceptor  : " + context.getTargName());
            System.out.println("Lifetime  : " + context.getLifetime());
            System.out.println("Privacy   : " + context.getConfState());
            GlobusGSSCredentialImpl cred = (GlobusGSSCredentialImpl)context.getDelegCred();
            System.out.println("Delegated credential :");
            if (cred != null) {
                System.out.println(cred.getX509Credential());
            } else {
                System.out.println("None");
            }
            String line = null;
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            while ((line = r.readLine()) != null && line.length() != 0) {
                System.out.println(line);
            }
            byte[] msg = "HTTP/1.1 404 Not Found\r\nConnection: close\r\n\r\n".getBytes();
            out.write(msg);
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.s.close();
            }
            catch (Exception exception) {}
            System.out.println("client disconnected");
        }
    }
}

