/*
 * Decompiled with CFR 0.152.
 */
package org.globus.io.gass.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.auth.SelfAuthorization;
import org.globus.gsi.gssapi.net.GssSocket;
import org.globus.gsi.gssapi.net.GssSocketFactory;
import org.globus.io.gass.client.internal.GASSProtocol;
import org.globus.io.gass.server.GassClientHandler;
import org.globus.net.BaseServer;
import org.globus.net.SocketFactory;
import org.globus.util.GlobusURL;
import org.globus.util.http.HttpResponse;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class GassServer
extends BaseServer {
    private static Log logger = LogFactory.getLog(GassServer.class.getName());
    public static final int READ_ENABLE = 8;
    public static final int WRITE_ENABLE = 16;
    public static final int STDOUT_ENABLE = 32;
    public static final int STDERR_ENABLE = 64;
    public static final int CLIENT_SHUTDOWN_ENABLE = 128;
    public static final String SHUTDOWN_STR = "/dev/globus_gass_client_shutdown";
    private Hashtable jobOutputs = null;
    private int options = 0;

    public GassServer() throws IOException {
        this(null, 0);
    }

    public GassServer(int port) throws IOException {
        this(null, port);
    }

    public GassServer(GSSCredential cred, int port) throws IOException {
        super(cred, port);
        this.init();
    }

    public GassServer(boolean secure, int port) throws IOException {
        super(secure, port);
        this.init();
    }

    private void init() {
        this.jobOutputs = new Hashtable();
        this.options = 120;
        super.initialize();
        this.setAuthorization(SelfAuthorization.getInstance());
    }

    public void setOptions(int options) {
        this.options = options;
    }

    public int getOptions() {
        return this.options;
    }

    public void registerJobOutputStream(String lb, OutputStream out) {
        this.jobOutputs.put(lb, out);
    }

    public void unregisterJobOutputStream(String lb) {
        this.jobOutputs.remove(lb);
    }

    public void unregisterJobOutputStream(String lb, OutputStream out) {
        this.unregisterJobOutputStream(lb);
    }

    protected OutputStream getJobOutputStream(String id) {
        return (OutputStream)this.jobOutputs.get(id);
    }

    protected void handleConnection(Socket socket) {
        GassClientHandler gcb = new GassClientHandler(this, socket);
        new Thread(gcb).start();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("GassServer: ");
        try {
            buf.append(this.getURL());
        }
        catch (Exception exception) {
            // empty catch block
        }
        buf.append(" options (");
        boolean op = (this.options & 8) != 0;
        buf.append("r:" + (op ? "+" : "-"));
        op = (this.options & 0x10) != 0;
        buf.append(" w:" + (op ? "+" : "-"));
        op = (this.options & 0x20) != 0;
        buf.append(" so:" + (op ? "+" : "-"));
        op = (this.options & 0x40) != 0;
        buf.append(" se:" + (op ? "+" : "-"));
        op = (this.options & 0x80) != 0;
        buf.append(" rc:" + (op ? "+" : "-"));
        buf.append(")");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown(GSSCredential cred, GlobusURL gassURL) throws IOException, GSSException {
        OutputStream output = null;
        InputStream input = null;
        Socket socket = null;
        try {
            if (gassURL.getProtocol().equalsIgnoreCase("https")) {
                GSSManager manager = ExtendedGSSManager.getInstance();
                ExtendedGSSContext context = (ExtendedGSSContext)manager.createContext(null, GSSConstants.MECH_OID, cred, 0);
                context.setOption(GSSConstants.GSS_MODE, GSIConstants.MODE_SSL);
                GssSocketFactory factory = GssSocketFactory.getDefault();
                socket = factory.createSocket(gassURL.getHost(), gassURL.getPort(), context);
                ((GssSocket)socket).setAuthorization(SelfAuthorization.getInstance());
            } else {
                SocketFactory factory = SocketFactory.getDefault();
                socket = factory.createSocket(gassURL.getHost(), gassURL.getPort());
            }
            output = socket.getOutputStream();
            input = socket.getInputStream();
            String msg = GASSProtocol.SHUTDOWN(SHUTDOWN_STR, gassURL.getHost());
            if (logger.isTraceEnabled()) {
                logger.trace("Shutdown msg: " + msg);
            }
            output.write(msg.getBytes());
            output.flush();
            HttpResponse rp = new HttpResponse(input);
            if (rp.httpCode == -1 && rp.httpMsg == null) {
            } else if (rp.httpCode != 200) {
                throw new IOException("Remote shutdown failed (" + rp.httpCode + " " + rp.httpMsg + ")");
            }
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
                if (input != null) {
                    input.close();
                }
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

