/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.ac.impl;

import java.security.cert.X509Certificate;
import java.util.List;
import org.italiangrid.voms.VOMSAttribute;
import org.italiangrid.voms.ac.ACParsingContext;
import org.italiangrid.voms.ac.VOMSACLookupStrategy;
import org.italiangrid.voms.ac.VOMSACParser;
import org.italiangrid.voms.ac.VOMSAttributesNormalizationStrategy;
import org.italiangrid.voms.ac.impl.LeafACLookupStrategy;
import org.italiangrid.voms.ac.impl.LeafVOMSExtensionNormalizationStrategy;
import org.italiangrid.voms.util.NullListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultVOMSACParser
implements VOMSACParser {
    private VOMSACLookupStrategy acLookupStrategy;
    private final VOMSAttributesNormalizationStrategy acNormalizationStrategy = new LeafVOMSExtensionNormalizationStrategy();
    private X509Certificate[] certChain;

    public DefaultVOMSACParser() {
        this(new LeafACLookupStrategy(NullListener.INSTANCE));
    }

    public DefaultVOMSACParser(VOMSACLookupStrategy strategy) {
        this.acLookupStrategy = strategy;
    }

    @Override
    public synchronized List<VOMSAttribute> parse(X509Certificate[] validatedChain) {
        this.certChain = validatedChain;
        return this.parse();
    }

    protected synchronized List<VOMSAttribute> parse() {
        if (this.certChain == null) {
            throw new NullPointerException("Cannot parse a null certchain!");
        }
        List<ACParsingContext> parsedACs = this.acLookupStrategy.lookupVOMSAttributeCertificates(this.certChain);
        return this.acNormalizationStrategy.normalizeAttributes(parsedACs);
    }

    protected synchronized X509Certificate[] getCertChain() {
        return this.certChain;
    }

    protected synchronized void setCertChain(X509Certificate[] certChain) {
        this.certChain = certChain;
    }
}

