/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.store.impl;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.italiangrid.voms.VOMSError;
import org.italiangrid.voms.store.UpdatingVOMSTrustStore;
import org.italiangrid.voms.store.VOMSTrustStoreStatusListener;
import org.italiangrid.voms.store.impl.DefaultVOMSTrustStore;
import org.italiangrid.voms.store.impl.VOMSNamedThreadFactory;
import org.italiangrid.voms.util.NullListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultUpdatingVOMSTrustStore
extends DefaultVOMSTrustStore
implements UpdatingVOMSTrustStore {
    public static final long DEFAULT_UPDATE_FREQUENCY = TimeUnit.MINUTES.toMillis(10L);
    private long updateFrequency;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new VOMSNamedThreadFactory());

    public DefaultUpdatingVOMSTrustStore(List<String> localTrustDirs, long updateFrequency, VOMSTrustStoreStatusListener listener) {
        super(localTrustDirs, listener);
        this.updateFrequencySanityChecks(updateFrequency);
        this.updateFrequency = updateFrequency;
        this.scheduleUpdate();
    }

    public DefaultUpdatingVOMSTrustStore(long updateFrequency) {
        this(DefaultUpdatingVOMSTrustStore.buildDefaultTrustedDirs(), updateFrequency, NullListener.INSTANCE);
    }

    public DefaultUpdatingVOMSTrustStore(List<String> localTrustDirs, long updateFrequency) {
        this(localTrustDirs, updateFrequency, NullListener.INSTANCE);
    }

    public DefaultUpdatingVOMSTrustStore(List<String> localTrustDirs) {
        this(localTrustDirs, DEFAULT_UPDATE_FREQUENCY, NullListener.INSTANCE);
    }

    public DefaultUpdatingVOMSTrustStore() {
        this(DefaultUpdatingVOMSTrustStore.buildDefaultTrustedDirs(), DEFAULT_UPDATE_FREQUENCY, NullListener.INSTANCE);
    }

    protected void updateFrequencySanityChecks(long updateFrequency) {
        if (updateFrequency <= 0L) {
            throw new VOMSError("Please provide a positive value for this store update frequency!");
        }
    }

    protected synchronized void scheduleUpdate() {
        long frequency = this.getUpdateFrequency();
        this.scheduler.scheduleWithFixedDelay(new Runnable(){

            public void run() {
                DefaultUpdatingVOMSTrustStore.this.update();
            }
        }, frequency, frequency, TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized long getUpdateFrequency() {
        return this.updateFrequency;
    }

    @Override
    public synchronized void update() {
        this.loadTrustInformation();
    }

    @Override
    public synchronized void cancel() {
        this.scheduler.shutdownNow();
    }
}

