/*
 * Decompiled with CFR 0.152.
 */
package org.opentsdb.client;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.opentsdb.client.ExpectResponse;
import org.opentsdb.client.HttpClient;
import org.opentsdb.client.PoolingHttpClient;
import org.opentsdb.client.builder.MetricBuilder;
import org.opentsdb.client.response.ErrorDetail;
import org.opentsdb.client.response.Response;
import org.opentsdb.client.response.SimpleHttpResponse;

public class HttpClientImpl
implements HttpClient {
    private static Logger logger = Logger.getLogger(HttpClientImpl.class);
    private String serviceUrl;
    private Gson mapper;
    PoolingHttpClient httpClient = new PoolingHttpClient();

    public HttpClientImpl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
        GsonBuilder builder = new GsonBuilder();
        this.mapper = builder.create();
    }

    @Override
    public Response pushMetrics(MetricBuilder builder) throws IOException {
        return this.pushMetrics(builder, ExpectResponse.STATUS_CODE);
    }

    @Override
    public Response pushMetrics(MetricBuilder builder, ExpectResponse expectResponse) throws IOException {
        Preconditions.checkNotNull(builder);
        SimpleHttpResponse response = this.httpClient.doPost(this.buildUrl(this.serviceUrl, "/api/put", expectResponse), builder.build());
        return this.getResponse(response);
    }

    private String buildUrl(String serviceUrl, String postApiEndPoint, ExpectResponse expectResponse) {
        String url = serviceUrl + postApiEndPoint;
        switch (expectResponse) {
            case SUMMARY: {
                url = url + "?summary";
                break;
            }
            case DETAIL: {
                url = url + "?details";
                break;
            }
        }
        return url;
    }

    private Response getResponse(SimpleHttpResponse httpResponse) {
        Response response = new Response(httpResponse.getStatusCode());
        String content = httpResponse.getContent();
        if (StringUtils.isNotEmpty(content)) {
            if (response.isSuccess()) {
                ErrorDetail errorDetail = this.mapper.fromJson(content, ErrorDetail.class);
                response.setErrorDetail(errorDetail);
            } else {
                logger.error("request failed!" + httpResponse.getContent());
            }
        }
        return response;
    }
}

