/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.globusonlinetool;

import com.sshtools.common.globusonlinetool.CredentialHelper;
import com.sshtools.common.globusonlinetool.GOHelper;
import com.sshtools.common.globusonlinetool.GOTaskPanel;
import com.sshtools.common.globusonlinetool.GlobusOnlineToolPanel;
import com.sshtools.common.globusonlinetool.SetupPanel;
import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.ui.XTextField;
import com.sshtools.j2ssh.authentication.UserGridCredential;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.globus.common.CoGProperties;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.X509Credential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.gssapi.auth.IdentityAuthorization;
import org.globus.myproxy.DestroyParams;
import org.globus.myproxy.MyProxy;
import org.ietf.jgss.GSSCredential;

public class Main
extends JFrame
implements ActionListener {
    static final String ICON = "/com/sshtools/common/globusonlinetool/largego.png";
    static final int LOGIN_SETUP = 0;
    static final int BEGIN_TRANSFER = 1;
    static final int CHECK_TRANSFERS = 2;
    String userName = "";
    String hostName = "";
    int port = 0;
    int lifetime = 0;
    String certType = null;
    String dn = null;
    boolean voms = false;
    boolean autoProxyUpload = false;
    String uploadedproxyPassphrase = "";
    JButton close;
    JButton generate;
    GlobusOnlineToolPanel gotoolpanel;
    GOTaskPanel gotaskpanel;
    JComboBox action;
    private String passphrase = null;
    private String confirmPassphrase = null;
    private boolean toContinue = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Main() {
        super("Globus Online Tool - Cloud GridFTP service");
        try {
            ConfigurationLoader.initialize(false);
        }
        catch (ConfigurationException ex) {
            // empty catch block
        }
        this.setIconImage(new ResourceIcon(this.getClass(), ICON).getImage());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (GOHelper.isAuthenticated()) {
                    GOHelper.writeGOLogFile();
                    if (CredentialHelper.isProxyUploaded()) {
                        Main.this.removeCredentialFromMyProxy();
                    }
                }
                if (GOHelper.getGoUserName() != null && !GOHelper.getGoUserName().trim().equals("")) {
                    PreferencesStore.put("sshterm.go.username", GOHelper.getGoUserName());
                }
            }
        });
        String existingProxyCertStr = "";
        boolean proxyValid = false;
        if (CredentialHelper.getExistingProxyLocation() != null && (existingProxyCertStr = CredentialHelper.getExistingProxyLocation()) != null && !existingProxyCertStr.equals("")) {
            proxyValid = true;
        }
        JLabel goUsernameLabel = new JLabel("Globus Online Username:");
        String goUsernameStr = PreferencesStore.get("sshterm.go.username", "");
        XTextField goUsernameTextBox = goUsernameStr != null ? new XTextField(goUsernameStr, 20) : new XTextField(20);
        if (proxyValid) {
            Object[] obj = new Object[]{goUsernameLabel, goUsernameTextBox};
            for (int counter = 0; counter < 3; --counter) {
                int result = JOptionPane.showConfirmDialog(this, obj, "Login", 2, 3, new ResourceIcon(this.getClass(), ICON));
                if (result == 0) {
                    String goUserName = goUsernameTextBox.getText().trim();
                    if (goUserName.equals("")) {
                        JOptionPane.showMessageDialog(this, "Cannot login to Globus Online without a valid username.", "Error: Globus Online username", 0);
                        continue;
                    }
                    GOHelper.setGoUserName(goUserName);
                    if (GOHelper.credentialChecker()) {
                        this.toContinue = true;
                        break;
                    } else {
                        JOptionPane.showMessageDialog(this, "Cannot login to Globus Online without a valid username.", "Error: Globus Online username", 0);
                        continue;
                    }
                }
                this.toContinue = false;
                break;
            }
        } else {
            JPanel goSetupPanel = new JPanel();
            SetupPanel.GOSetupPanel goLoginPanel = new SetupPanel.GOSetupPanel();
            goSetupPanel.add(goLoginPanel);
            JScrollPane scrollPane = new JScrollPane(goLoginPanel);
            int counter = 0;
            while (counter < 3) {
                int result = JOptionPane.showConfirmDialog(this, scrollPane, "Setting up for Globus Online", 2, 3, new ResourceIcon(this.getClass(), ICON));
                if (result == 0) {
                    String goUserName = goLoginPanel.getGOUsername();
                    if (goUserName.equals("")) {
                        JOptionPane.showMessageDialog(this, "Cannot login to Globus Online without a valid username.", "Error: Globus Online username", 0);
                        continue;
                    }
                    if (!this.authenticationHelper(goLoginPanel)) continue;
                    GOHelper.setGoUserName(goUserName);
                    if (GOHelper.credentialChecker()) {
                        this.toContinue = true;
                        break;
                    } else {
                        JOptionPane.showMessageDialog(this, "Cannot login to Globus Online without a valid username.", "Error: Globus Online username", 0);
                        continue;
                    }
                }
                this.toContinue = false;
                break;
            }
        }
        if (this.toContinue) {
            try {
                String globusCertDir = System.getProperty("user.home") + File.separator + ".globus" + File.separator + "certificates";
                if (!new File(globusCertDir).exists()) {
                    UserGridCredential.checkCACertificates(CoGProperties.getDefault());
                }
            }
            catch (IOException e1) {
                System.out.println("Failed to update CA certificates");
            }
            JPanel iconPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.insets = new Insets(0, 2, 4, 2);
            gbc.weightx = 0.0;
            goUsernameLabel = new JLabel("GO Username: " + GOHelper.getGoUserName());
            goUsernameLabel.setFont(new Font("Serif", 1, 15));
            UIUtil.jGridBagAdd(iconPanel, goUsernameLabel, gbc, -1);
            gbc.weightx = 1.0;
            IconWrapperPanel northPanel = new IconWrapperPanel(new ResourceIcon(this.getClass(), ICON), iconPanel);
            northPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.gotoolpanel = new GlobusOnlineToolPanel();
            JPanel centerPanel = new JPanel(new FlowLayout(0, 0, 0));
            centerPanel.add(this.gotoolpanel);
            this.gotaskpanel = new GOTaskPanel();
            JPanel southPanel = new JPanel(new FlowLayout(0, 0, 0));
            southPanel.add(this.gotaskpanel);
            JPanel mainPanel = new JPanel(new BorderLayout());
            JScrollPane mainScroller = new JScrollPane(mainPanel);
            mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            mainPanel.add((Component)northPanel, "North");
            mainPanel.add((Component)centerPanel, "Center");
            mainPanel.add((Component)southPanel, "South");
            this.getContentPane().setLayout(new GridLayout(1, 1));
            this.getContentPane().add(mainScroller);
        }
    }

    public boolean authenticationHelper(SetupPanel.GOSetupPanel goSetupPanel) {
        String localPassphrase = new String(goSetupPanel.getLocalPassphrase()).trim();
        this.userName = new String(goSetupPanel.getMyProxyUsername());
        this.hostName = new String(goSetupPanel.getMyProxyServer());
        this.port = goSetupPanel.getMyProxyPort();
        this.lifetime = goSetupPanel.getMyProxyLifetime();
        this.uploadedproxyPassphrase = new String(goSetupPanel.getUploadedMyProxyPassphrase());
        this.certType = goSetupPanel.getCertType();
        this.voms = goSetupPanel.getVOMSSupport();
        this.autoProxyUpload = goSetupPanel.getAutoProxyUpload();
        String pkcs12cert = goSetupPanel.getPKCS12Cert();
        String existingProxyCert = goSetupPanel.getExistingProxyCert();
        String myProxyServer = goSetupPanel.getMyProxyServer();
        int myProxyPort = goSetupPanel.getMyProxyPort();
        int myProxyLifetime = goSetupPanel.getMyProxyLifetime();
        String myProxyUsername = goSetupPanel.getMyProxyUsername();
        try {
            GSSCredential gsscredential = null;
            GSIConstants.CertificateType proxyType = GSIConstants.CertificateType.GSI_4_IMPERSONATION_PROXY;
            GSSCredential vomscredential = null;
            if (this.certType.equals("Local PEM") || this.certType.equals("Local PKCS12")) {
                gsscredential = this.createCredential(localPassphrase, proxyType, this.lifetime, pkcs12cert, existingProxyCert, false);
                if (this.voms && gsscredential != null) {
                    vomscredential = this.createCredential(localPassphrase, proxyType, this.lifetime, pkcs12cert, existingProxyCert, true);
                }
            } else if (this.certType.equals("Retrieve from MyProxy Server")) {
                MyProxy myProxy = this.getMyProxy();
                gsscredential = myProxy.get(null, this.userName, this.uploadedproxyPassphrase, this.lifetime * 3600);
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("username", this.userName);
                info.put("passphrase", this.uploadedproxyPassphrase);
                info.put("server", this.hostName);
                CredentialHelper.setMyProxyInfo(info);
                if (gsscredential == null) {
                    JOptionPane.showMessageDialog(this, "Cannot retrieve valid/required credential from MyProxy Server", "Error: MyProxy Server", 0);
                }
            }
            if (gsscredential != null) {
                boolean ok;
                CredentialHelper.saveProxy(((GlobusGSSCredentialImpl)gsscredential).getX509Credential());
                if (this.autoProxyUpload && (ok = this.createConfirmPassphraseDialog())) {
                    MyProxy myProxy = this.getMyProxy();
                    if (vomscredential != null) {
                        myProxy.put(vomscredential, this.userName, this.passphrase, this.lifetime * 3600);
                    } else {
                        myProxy.put(gsscredential, this.userName, this.passphrase, this.lifetime * 3600);
                    }
                    JOptionPane.showMessageDialog(this, "Your credential has been uploaded to " + this.hostName + " under \nUsername: " + this.userName + "\nWhen you exit normally from Globus Online Tool, this proxy will automatically be removed from the server.", "MyProxy status", 1, new ResourceIcon(this.getClass(), ICON));
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("username", this.userName);
                    info.put("passphrase", this.passphrase);
                    info.put("server", this.hostName);
                    CredentialHelper.setMyProxyInfo(info);
                    CredentialHelper.setProxyUploaded(true);
                }
                return true;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "MyProxy Error", 0);
        }
        return false;
    }

    public void removeCredentialFromMyProxy() {
        block5: {
            GSSCredential gsscredential = null;
            int proxyType = GSIConstants.CertificateType.GSI_4_IMPERSONATION_PROXY.getCode();
            try {
                gsscredential = CredentialHelper.loadExistingProxy();
                if (gsscredential == null) break block5;
                DestroyParams destroyRequest = new DestroyParams();
                destroyRequest.setUserName(this.userName);
                destroyRequest.setCredentialName(null);
                destroyRequest.setPassphrase("DUMMY-PASSPHRASE");
                try {
                    MyProxy myProxy = this.getMyProxy();
                    myProxy.destroy(gsscredential, destroyRequest);
                    JOptionPane.showMessageDialog(this, "Proxy is successfully removed/destroyed.", "MyProxy status", 1, new ResourceIcon(this.getClass(), ICON));
                }
                catch (Exception e) {
                    if (e.getMessage().contains("Credentials do not exist")) {
                        JOptionPane.showMessageDialog(this, "No credential found for user '" + this.userName + "'", "MyProxy Error", 0);
                        break block5;
                    }
                    JOptionPane.showMessageDialog(this, e.getMessage(), "MyProxy Error", 0);
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), "MyProxy Error", 0);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
    }

    public int getAction() {
        return this.action.getSelectedIndex();
    }

    private GSSCredential createCredential(String localPassphrase, GSIConstants.CertificateType proxyType, int lifetime, String pkcs12cert, String existingProxyCert, boolean voms) throws Exception {
        GSSCredential defensivecopy;
        GSSCredential gsscredential = null;
        X509Credential proxy = null;
        boolean error = false;
        if (voms) {
            JLabel question = new JLabel("Authentication with VOs before logging in?");
            JLabel proxyTypeLB = new JLabel("Proxy Type: ");
            JComboBox<String> proxyTypeCB = new JComboBox<String>(new String[]{"Legacy", "RFC Impersonation"});
            String cur = PreferencesStore.get("sshterm.voms.proxyType", Integer.toString(GSIConstants.CertificateType.GSI_4_IMPERSONATION_PROXY.getCode()));
            if (cur.equals(Integer.toString(GSIConstants.CertificateType.GSI_2_PROXY.getCode()))) {
                proxyTypeCB.setSelectedIndex(0);
            } else {
                proxyTypeCB.setSelectedIndex(1);
            }
            Object[] obj = new Object[]{question, proxyTypeLB, proxyTypeCB};
            int result = JOptionPane.showConfirmDialog(null, obj, "Enable VOMS ?", 0);
            if (result == 0) {
                int index = proxyTypeCB.getSelectedIndex();
                if (index == 0) {
                    proxyType = GSIConstants.CertificateType.GSI_2_PROXY;
                } else if (index == 1) {
                    proxyType = GSIConstants.CertificateType.GSI_4_IMPERSONATION_PROXY;
                }
            }
        }
        if (this.certType.equals("Local PEM")) {
            try {
                proxy = UserGridCredential.createProxy(localPassphrase, proxyType, lifetime);
            }
            catch (Exception ex) {
                error = true;
                JOptionPane.showMessageDialog(this, "Cannot find your PEM certificates in {home directory}/.globus/ or incorrect passphrase.", "MyProxy Error", 0);
            }
        } else if (this.certType.equals("Local PKCS12")) {
            try {
                proxy = CredentialHelper.createProxyFromPKCS12(localPassphrase, proxyType, lifetime, pkcs12cert);
            }
            catch (Exception ex) {
                error = true;
                JOptionPane.showMessageDialog(null, ex.getMessage(), "MyProxy Error", 0);
            }
        } else if (this.certType.equals("Existing proxy")) {
            try {
                proxy = CredentialHelper.retrieveExistingProxy(existingProxyCert);
            }
            catch (Exception ex) {
                error = true;
                JOptionPane.showMessageDialog(null, ex.getMessage(), "MyProxy Error", 0);
            }
        }
        if (proxy != null) {
            try {
                if (proxy.getTimeLeft() <= 0L) {
                    JOptionPane.showMessageDialog(this, "Credentials have expired.", "MyProxy Error", 0);
                }
                gsscredential = new GlobusGSSCredentialImpl(proxy, 1);
            }
            catch (Exception exception1) {
                error = true;
                if (exception1.getMessage().indexOf("Expired credentials") >= 0) {
                    JOptionPane.showMessageDialog(this, "Credentials have expired.", "MyProxy Error", 0);
                }
                JOptionPane.showMessageDialog(this, "Could not load your certificate.", "MyProxy Error", 0);
            }
        }
        if (!error && voms && (defensivecopy = UserGridCredential.vomsEnable(gsscredential)) != null) {
            gsscredential = defensivecopy;
        }
        return gsscredential;
    }

    private boolean createConfirmPassphraseDialog() {
        for (int counter = 0; counter < 3; ++counter) {
            try {
                JLabel serverInfoLabel = new JLabel("MyProxy server: myproxy.lrz.de");
                JLabel lmyProxyPassphrase = new JLabel("Upload Passphrase:");
                JPasswordField myProxyPassphrase = new JPasswordField(20);
                JLabel lmyProxyPassphraseConfirm = new JLabel("Comfirm Upload Passphrase:");
                JPasswordField myProxyPassphraseConfirm = new JPasswordField(20);
                Object[] obj = new Object[]{serverInfoLabel, lmyProxyPassphrase, myProxyPassphrase, lmyProxyPassphraseConfirm, myProxyPassphraseConfirm};
                int result = JOptionPane.showConfirmDialog(this, obj, "Upload proxy to MyProxy Server", 2);
                if (result == 0) {
                    this.passphrase = new String(myProxyPassphrase.getPassword()).trim();
                    this.confirmPassphrase = new String(myProxyPassphraseConfirm.getPassword()).trim();
                    if (!this.passphrase.equals(this.confirmPassphrase)) {
                        throw new Exception("Passphrase and Confirm Passphrase do not match. Please try again.");
                    }
                    return true;
                }
                break;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "MyProxy Error", 0);
                continue;
            }
        }
        return false;
    }

    private MyProxy getMyProxy() {
        MyProxy myProxy = new MyProxy(this.hostName, this.port);
        if (this.dn != null) {
            myProxy.setAuthorization(new IdentityAuthorization(this.dn));
        }
        return myProxy;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        Main main = new Main();
        main.pack();
        UIUtil.positionComponent(0, main);
        main.setVisible(true);
    }

    public boolean isToContinue() {
        return this.toContinue;
    }
}

