/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.myproxytool;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.globus.gsi.CredentialException;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.X509Credential;
import org.globus.gsi.bc.BouncyCastleCertProcessingFactory;
import org.globus.gsi.bc.BouncyCastleOpenSSLKey;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.util.CertificateLoadUtil;
import org.globus.util.ConfigUtil;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public class CredentialHelper {
    public static GSSCredential loadExistingProxy() throws Exception {
        GSSCredential cred = null;
        X509Credential proxy = null;
        String proxyLoc = ConfigUtil.discoverProxyLocation();
        try {
            if (!new File(proxyLoc).exists()) {
                return null;
            }
            proxy = new X509Credential(proxyLoc);
            cred = proxy.getProxyType().equals((Object)GSIConstants.CertificateType.EEC) ? CredentialHelper.createCredentialFromEndEntityProxy(proxyLoc, (int)Math.ceil(proxy.getTimeLeft() / 3600L)) : new GlobusGSSCredentialImpl(proxy, 1);
            proxy.verify();
        }
        catch (CredentialException ce) {
            throw new Exception("Credential from proxy file '" + proxyLoc + "' is not a valid X509 credential.", ce);
        }
        catch (GSSException gsse) {
            if (proxy.getTimeLeft() <= 0L) {
                File file = new File(proxyLoc);
                file.delete();
                cred = null;
            }
            throw new Exception("Credential from proxy file '" + proxyLoc + "' cannot be verified", gsse);
        }
        return cred;
    }

    public static String getExistingProxyLocation() {
        try {
            if (!new File(ConfigUtil.discoverProxyLocation()).exists()) {
                return null;
            }
            X509Credential proxy = new X509Credential(ConfigUtil.discoverProxyLocation());
            proxy.verify();
        }
        catch (CredentialException e) {
            return null;
        }
        return ConfigUtil.discoverProxyLocation();
    }

    public static X509Credential retrieveExistingProxy(String path) throws Exception {
        X509Credential proxy = null;
        try {
            if (!new File(path).exists()) {
                throw new Exception("Proxy file '" + path + "' does not exist.");
            }
            proxy = new X509Credential(path);
            if (proxy.getProxyType().equals((Object)GSIConstants.CertificateType.EEC)) {
                proxy = CredentialHelper.createX509CredentialFromEndEntityProxy(path, (int)Math.ceil(proxy.getTimeLeft() / 3600L));
            }
            proxy.verify();
        }
        catch (CredentialException ce) {
            if (ce.getMessage().contains("expired") && proxy.getTimeLeft() <= 0L) {
                throw new Exception("Existing proxy is expired.");
            }
            throw new Exception("Globus credential from proxy file '" + path + "' cannot be verified");
        }
        return proxy;
    }

    public static X509Credential createProxyFromPKCS12(String password, GSIConstants.CertificateType proxyType, int lifetimeHours, String pcksCert) throws Exception {
        X509Credential proxy = null;
        File keyfile = new File(pcksCert);
        Security.addProvider(new BouncyCastleProvider());
        KeyStore store = KeyStore.getInstance("PKCS12", "BC");
        FileInputStream in = new FileInputStream(keyfile);
        try {
            store.load(in, password.toCharArray());
        }
        catch (IOException ioe) {
            if (ioe.getMessage().indexOf("Illegal key size") >= 0) {
                throw new Exception("GSI Exception: To use this PKCS#12 file you need to install the Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files");
            }
            throw new Exception("Wrong password or other security error");
        }
        Enumeration<String> e = store.aliases();
        Key key = null;
        Certificate cert = null;
        if (!e.hasMoreElements()) {
            throw new Exception("GSI Exception: Could not access your certificate: No certificates found in file '" + pcksCert + "'");
        }
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            key = store.getKey(alias, password.toCharArray());
            if (key == null || !(key instanceof PrivateKey)) continue;
            cert = store.getCertificate(alias);
            break;
        }
        if (!(cert instanceof X509Certificate)) {
            throw new Exception("GSI Exception: Could not access your certificate: bad certificate type.");
        }
        if (!(key instanceof PrivateKey)) {
            throw new Exception("GSI Exception: Could not access your certificate: bad key type.");
        }
        BouncyCastleCertProcessingFactory factory = BouncyCastleCertProcessingFactory.getDefault();
        try {
            int bits = 2048;
            proxy = factory.createCredential(new X509Certificate[]{(X509Certificate)cert}, (PrivateKey)key, bits, lifetimeHours * 3600, proxyType);
        }
        catch (Exception ex) {
            throw new Exception("Failed to create a proxy:" + ex.getMessage());
        }
        return proxy;
    }

    private static GSSCredential createCredentialFromEndEntityProxy(String filename, int lifetimeHours) throws Exception {
        GlobusGSSCredentialImpl cred = null;
        X509Credential proxy = null;
        try {
            proxy = CredentialHelper.createX509CredentialFromEndEntityProxy(filename, lifetimeHours);
            cred = new GlobusGSSCredentialImpl(proxy, 1);
            System.out.println("Credential successfully created.");
        }
        catch (Exception e) {
            throw new Exception("Failed to create a proxy:" + e.getMessage());
        }
        return cred;
    }

    private static X509Credential createX509CredentialFromEndEntityProxy(String filename, int lifetimeHours) throws Exception {
        String line;
        X509Credential proxy = null;
        X509Certificate[] userCerts = null;
        PrivateKey userKey = null;
        String keyContent = "";
        String certContent = "";
        boolean isCertContent = false;
        boolean isKeyContent = false;
        BufferedReader br = new BufferedReader(new FileReader(filename));
        while ((line = br.readLine()) != null) {
            if (line.startsWith("-----") && line.contains("BEGIN") && line.contains("CERTIFICATE")) {
                certContent = certContent + line + "\n";
                isCertContent = true;
                continue;
            }
            if (line.startsWith("-----") && line.contains("END") && line.contains("CERTIFICATE")) {
                certContent = certContent + line + "\n";
                isCertContent = false;
            } else {
                if (line.startsWith("-----") && line.contains("BEGIN") && line.contains("PRIVATE") && line.contains("KEY")) {
                    keyContent = keyContent + line + "\n";
                    isKeyContent = true;
                    continue;
                }
                if (line.startsWith("-----") && line.contains("END") && line.contains("PRIVATE") && line.contains("KEY")) {
                    keyContent = keyContent + line + "\n";
                    isKeyContent = false;
                }
            }
            if (isCertContent) {
                certContent = certContent + line + "\n";
            }
            if (!isKeyContent) continue;
            keyContent = keyContent + line + "\n";
        }
        br.close();
        try {
            ByteArrayInputStream inKey = new ByteArrayInputStream(keyContent.getBytes());
            BouncyCastleOpenSSLKey key = new BouncyCastleOpenSSLKey(inKey);
            userKey = key.getPrivateKey();
        }
        catch (IOException e) {
            throw new Exception("Error: Failed to load key", e);
        }
        try {
            ByteArrayInputStream inCert = new ByteArrayInputStream(certContent.getBytes());
            X509Certificate cert = CertificateLoadUtil.readCertificate(new BufferedReader(new StringReader(certContent)));
            userCerts = new X509Certificate[]{cert};
        }
        catch (IOException e) {
            throw new Exception("Error: Failed to load cert", e);
        }
        catch (GeneralSecurityException e) {
            throw new Exception("Error: Unable to load user certificate", e);
        }
        BouncyCastleCertProcessingFactory factory = BouncyCastleCertProcessingFactory.getDefault();
        int bits = 2048;
        try {
            proxy = factory.createCredential(userCerts, userKey, bits, lifetimeHours * 3600, GSIConstants.DelegationType.FULL);
        }
        catch (Exception e) {
            throw new Exception("Failed to create a proxy:" + e.getMessage());
        }
        return proxy;
    }
}

