/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.SessionManager;
import com.sshtools.common.ui.SessionProvider;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationFrame;
import com.sshtools.common.ui.SshToolsApplicationSessionPanel;
import com.sshtools.j2ssh.SftpClient;
import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.SshEventAdapter;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelFactory;
import com.sshtools.j2ssh.forwarding.ForwardingClient;
import com.sshtools.j2ssh.session.SessionChannelClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;

public class SessionProviderFrame
extends SshToolsApplicationFrame
implements SessionManager {
    private SshToolsApplicationSessionPanel panel;
    private SessionProvider provider;
    private SshToolsConnectionProfile profile;
    private SshClient ssh;
    private boolean disconnectOnClose = false;

    public SessionProvider getSessionProvider() {
        return this.provider;
    }

    public SessionProviderFrame(SshToolsConnectionProfile profile, SshClient ssh, SessionProvider provider) throws IOException, SshToolsApplicationException {
        try {
            this.provider = provider;
            this.ssh = ssh;
            this.profile = profile;
            this.setIconImage(provider.getSmallIcon().getImage());
            this.setTitle(provider.getName() + " - " + ssh.getConnectionProperties().getHost());
            this.getContentPane().setLayout(new BorderLayout());
            this.panel = (SshToolsApplicationSessionPanel)provider.getProviderClass().newInstance();
            this.getContentPane().add((Component)this.panel, "Center");
            return;
        }
        catch (IllegalAccessException ex) {
        }
        catch (InstantiationException ex) {
            // empty catch block
        }
        throw new SshToolsApplicationException("Failed to create instance of " + provider.getProviderClass().getName());
    }

    public boolean initFrame(SshToolsApplication app) throws IOException, SshToolsApplicationException {
        this.panel.setCurrentConnectionProfile(this.profile);
        this.panel.init(app);
        this.init(app, this.panel);
        this.pack();
        return this.panel.openSession(this, this.profile);
    }

    public SshToolsApplicationSessionPanel getSessionPanel() {
        return this.panel;
    }

    @Override
    public int getRemoteEOL() {
        return this.ssh.getRemoteEOL();
    }

    public boolean canExit() {
        return this.panel.canClose();
    }

    public void exit() {
        this.panel.close();
        this.dispose();
    }

    @Override
    public SessionChannelClient openSession() throws IOException {
        return this.ssh.openSessionChannel();
    }

    @Override
    public void applyProfileChanges(SshToolsConnectionProfile profile) {
    }

    public void setDisconnectOnClose(boolean disconnectOnClose) {
        this.disconnectOnClose = disconnectOnClose;
    }

    @Override
    public SftpClient openSftpClient() throws IOException {
        return this.ssh.openSftpClient();
    }

    @Override
    public boolean openChannel(Channel channel) throws IOException {
        return this.ssh.openChannel(channel);
    }

    @Override
    public boolean isConnected() {
        return this.ssh.isConnected();
    }

    @Override
    public boolean requestDisconnect() {
        return this.disconnectOnClose;
    }

    @Override
    public ForwardingClient getForwardingClient() {
        return this.ssh.getForwardingClient();
    }

    @Override
    public byte[] sendGlobalRequest(String requestname, boolean wantreply, byte[] requestdata) throws IOException {
        return this.ssh.sendGlobalRequest(requestname, wantreply, requestdata);
    }

    @Override
    public void addEventHandler(SshEventAdapter eventHandler) {
        this.ssh.addEventHandler(eventHandler);
    }

    @Override
    public String getServerId() {
        return this.ssh.getServerId();
    }

    @Override
    public void allowChannelOpen(String channelType, ChannelFactory cf) throws IOException {
        this.ssh.allowChannelOpen(channelType, cf);
    }

    @Override
    public SshToolsConnectionProfile getProfile() {
        return this.profile;
    }
}

