/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.NumericTextField;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshToolsConnectionProxyTab
extends JPanel
implements SshToolsConnectionTab {
    public static final String PROXY_ICON = "/com/sshtools/common/ui/proxy.png";
    protected JRadioButton noProxy = new JRadioButton("No proxy");
    protected JRadioButton httpProxy = new JRadioButton("HTTP");
    protected JRadioButton socks4Proxy = new JRadioButton("SOCKS 4");
    protected JRadioButton socks5Proxy = new JRadioButton("SOCKS 5");
    protected ButtonGroup group = new ButtonGroup();
    protected JPanel proxyframe = new JPanel(new GridBagLayout());
    protected JTextField username = new JTextField();
    protected JPasswordField password = new JPasswordField();
    protected JTextField proxy = new JTextField();
    protected NumericTextField port = new NumericTextField(new Integer(1), new Integer(65535));
    protected SshToolsConnectionProfile profile;
    protected Log log = LogFactory.getLog(SshToolsConnectionProxyTab.class);

    public SshToolsConnectionProxyTab() {
        this.group.add(this.noProxy);
        this.group.add(this.httpProxy);
        this.group.add(this.socks4Proxy);
        this.group.add(this.socks5Proxy);
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (SshToolsConnectionProxyTab.this.noProxy.isSelected()) {
                    SshToolsConnectionProxyTab.this.username.setEnabled(false);
                    SshToolsConnectionProxyTab.this.password.setEnabled(false);
                    SshToolsConnectionProxyTab.this.proxy.setEnabled(false);
                    SshToolsConnectionProxyTab.this.port.setForeground(Color.white);
                } else {
                    SshToolsConnectionProxyTab.this.username.setEnabled(true);
                    SshToolsConnectionProxyTab.this.password.setEnabled(true);
                    SshToolsConnectionProxyTab.this.proxy.setEnabled(true);
                    SshToolsConnectionProxyTab.this.port.setForeground(Color.black);
                    if (SshToolsConnectionProxyTab.this.httpProxy.isSelected()) {
                        SshToolsConnectionProxyTab.this.port.setText("80");
                    } else {
                        SshToolsConnectionProxyTab.this.port.setText("1080");
                    }
                }
            }
        };
        this.noProxy.getModel().addChangeListener(listener);
        this.httpProxy.getModel().addChangeListener(listener);
        this.socks4Proxy.getModel().addChangeListener(listener);
        this.socks5Proxy.getModel().addChangeListener(listener);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = new Insets(0, 2, 2, 2);
        gbc.weightx = 1.0;
        this.proxyframe.setBorder(BorderFactory.createTitledBorder("Connect using the following proxy"));
        gbc.insets = new Insets(2, 10, 2, 2);
        UIUtil.jGridBagAdd(this.proxyframe, this.noProxy, gbc, -1);
        gbc.insets = new Insets(2, 15, 2, 2);
        UIUtil.jGridBagAdd(this.proxyframe, this.socks4Proxy, gbc, 0);
        gbc.insets = new Insets(2, 10, 2, 2);
        UIUtil.jGridBagAdd(this.proxyframe, this.httpProxy, gbc, -1);
        gbc.insets = new Insets(2, 15, 2, 2);
        UIUtil.jGridBagAdd(this.proxyframe, this.socks5Proxy, gbc, 0);
        gbc.insets = new Insets(2, 10, 2, 10);
        JPanel connect = new JPanel(new GridBagLayout());
        connect.setBorder(BorderFactory.createTitledBorder("Proxy Details"));
        UIUtil.jGridBagAdd(connect, new JLabel("Host"), gbc, 0);
        UIUtil.jGridBagAdd(connect, this.proxy, gbc, 0);
        UIUtil.jGridBagAdd(connect, new JLabel("Port"), gbc, 0);
        gbc.anchor = 17;
        gbc.fill = 0;
        UIUtil.jGridBagAdd(connect, this.port, gbc, 0);
        gbc.fill = 2;
        UIUtil.jGridBagAdd(connect, new JLabel("Username"), gbc, 0);
        UIUtil.jGridBagAdd(connect, this.username, gbc, 0);
        UIUtil.jGridBagAdd(connect, new JLabel("Password"), gbc, 0);
        gbc.insets = new Insets(2, 10, 10, 10);
        UIUtil.jGridBagAdd(connect, this.password, gbc, 0);
        JPanel main = new JPanel(new GridBagLayout());
        gbc.insets = new Insets(2, 2, 2, 2);
        UIUtil.jGridBagAdd(main, this.proxyframe, gbc, 0);
        UIUtil.jGridBagAdd(main, connect, gbc, 0);
        IconWrapperPanel iconProxyDetailsPanel = new IconWrapperPanel(new ResourceIcon(PROXY_ICON), main);
        this.noProxy.setSelected(true);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.weightx = 1.0;
        this.add((Component)iconProxyDetailsPanel, "North");
    }

    @Override
    public void setConnectionProfile(SshToolsConnectionProfile profile) {
        this.profile = profile;
        if (profile.getTransportProvider() == 2) {
            this.httpProxy.setSelected(true);
        } else if (profile.getTransportProvider() == 3) {
            this.socks4Proxy.setSelected(true);
        } else if (profile.getTransportProvider() == 4) {
            this.socks5Proxy.setSelected(true);
        }
        this.proxy.setText(profile.getProxyHost());
        if (profile.getProxyPort() > 0) {
            this.port.setValue(new Integer(profile.getProxyPort()));
        }
        this.username.setText(profile.getProxyUsername());
        this.password.setText(profile.getProxyPassword());
    }

    @Override
    public SshToolsConnectionProfile getConnectionProfile() {
        return this.profile;
    }

    @Override
    public String getTabContext() {
        return "Connection";
    }

    @Override
    public Icon getTabIcon() {
        return null;
    }

    @Override
    public String getTabTitle() {
        return "Proxy";
    }

    @Override
    public String getTabToolTipText() {
        return "Configure the proxy connection.";
    }

    @Override
    public int getTabMnemonic() {
        return 112;
    }

    @Override
    public Component getTabComponent() {
        return this;
    }

    @Override
    public boolean validateTab() {
        return true;
    }

    @Override
    public void applyTab() {
        if (this.httpProxy.isSelected()) {
            this.profile.setTransportProvider(2);
        } else if (this.socks4Proxy.isSelected()) {
            this.profile.setTransportProvider(3);
        } else if (this.socks5Proxy.isSelected()) {
            this.profile.setTransportProvider(4);
        } else {
            this.profile.setTransportProvider(1);
        }
        this.profile.setProxyHost(this.proxy.getText());
        this.profile.setProxyPort(this.port.getValue().intValue());
        this.profile.setProxyUsername(this.username.getText());
        this.profile.setProxyPassword(new String(this.password.getPassword()));
    }

    @Override
    public void tabSelected() {
    }
}

