/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SshToolsSimpleConnectionPrompt {
    private static SshToolsSimpleConnectionPrompt instance;
    private Component parent;
    private String title = "Connect to host...";
    private boolean advanced;
    private String lastHost;

    private SshToolsSimpleConnectionPrompt() {
    }

    public void setParentComponent(Component component) {
        this.parent = component;
    }

    public boolean getHostname(StringBuffer stringbuffer, String lastHost) {
        this.lastHost = lastHost;
        this.advanced = false;
        Window window = this.parent != null ? (Window)SwingUtilities.getAncestorOfClass(Window.class, this.parent) : null;
        SshToolsSimpleConnectionDialog dialog = null;
        dialog = window instanceof Frame ? new SshToolsSimpleConnectionDialog((Frame)window) : (window instanceof Dialog ? new SshToolsSimpleConnectionDialog((Dialog)window) : new SshToolsSimpleConnectionDialog());
        String ac = dialog.getHostname();
        if (ac != null) {
            stringbuffer.append(ac);
        }
        this.advanced = dialog.getAdvanced();
        return dialog.getCancelled();
    }

    public static SshToolsSimpleConnectionPrompt getInstance() {
        if (instance == null) {
            instance = new SshToolsSimpleConnectionPrompt();
        }
        return instance;
    }

    public void setTitle(String s) {
        this.title = s;
    }

    public boolean getAdvanced() {
        return this.advanced;
    }

    class SshToolsSimpleConnectionDialog
    extends JDialog {
        JLabel promptLabel;
        JTextField hostname;
        boolean cancelled;
        boolean advanced;

        String getHostname() {
            return !this.cancelled ? this.hostname.getText() : null;
        }

        boolean getCancelled() {
            return this.cancelled;
        }

        boolean getAdvanced() {
            return this.advanced;
        }

        void init() {
            this.setDefaultCloseOperation(2);
            JPanel jpanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridbagconstraints = new GridBagConstraints();
            gridbagconstraints.insets = new Insets(0, 0, 2, 2);
            gridbagconstraints.anchor = 17;
            gridbagconstraints.fill = 2;
            gridbagconstraints.weightx = 0.0;
            UIUtil.jGridBagAdd(jpanel, new JLabel("Host to Connect to: "), gridbagconstraints, -1);
            gridbagconstraints.weightx = 1.0;
            UIUtil.jGridBagAdd(jpanel, this.hostname, gridbagconstraints, 0);
            this.promptLabel.setHorizontalAlignment(0);
            JPanel jpanel1 = new JPanel(new BorderLayout());
            jpanel1.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jpanel1.add((Component)this.promptLabel, "North");
            jpanel1.add((Component)jpanel, "Center");
            JButton jbutton = new JButton("Ok");
            jbutton.setMnemonic('o');
            jbutton.setDefaultCapable(true);
            jbutton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionevent) {
                    SshToolsSimpleConnectionDialog.this.cancelled = false;
                    SshToolsSimpleConnectionDialog.this.advanced = false;
                    SshToolsSimpleConnectionDialog.this.hide();
                }
            });
            this.getRootPane().setDefaultButton(jbutton);
            JButton jbutton1 = new JButton("Cancel");
            jbutton1.setMnemonic('c');
            jbutton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionevent) {
                    SshToolsSimpleConnectionDialog.this.cancelled = true;
                    SshToolsSimpleConnectionDialog.this.advanced = false;
                    SshToolsSimpleConnectionDialog.this.hide();
                }
            });
            JButton jbutton3 = new JButton("Advanced");
            jbutton3.setMnemonic('a');
            jbutton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionevent) {
                    SshToolsSimpleConnectionDialog.this.cancelled = false;
                    SshToolsSimpleConnectionDialog.this.advanced = true;
                    SshToolsSimpleConnectionDialog.this.hide();
                }
            });
            JPanel jpanel2 = new JPanel(new FlowLayout(2, 0, 0));
            jpanel2.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
            jpanel2.add(jbutton3);
            jpanel2.add(jbutton1);
            jpanel2.add(jbutton);
            IconWrapperPanel iconwrapperpanel = new IconWrapperPanel(new ResourceIcon("largeserveridentity.png"), jpanel1);
            iconwrapperpanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            JPanel jpanel3 = new JPanel(new BorderLayout());
            jpanel3.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jpanel3.add((Component)iconwrapperpanel, "Center");
            jpanel3.add((Component)jpanel2, "South");
            this.getContentPane().setLayout(new GridLayout(1, 1));
            this.getContentPane().add(jpanel3);
            this.pack();
            this.toFront();
            UIUtil.positionComponent(0, this);
            this.setVisible(true);
        }

        SshToolsSimpleConnectionDialog() {
            super((Frame)null, SshToolsSimpleConnectionPrompt.this.title, true);
            this.cancelled = true;
            this.advanced = false;
            this.promptLabel = new JLabel();
            this.hostname = new JTextField(SshToolsSimpleConnectionPrompt.this.lastHost, 15);
            this.init();
        }

        SshToolsSimpleConnectionDialog(Frame frame) {
            super(frame, SshToolsSimpleConnectionPrompt.this.title, true);
            this.cancelled = true;
            this.advanced = false;
            this.promptLabel = new JLabel();
            this.hostname = new JTextField(SshToolsSimpleConnectionPrompt.this.lastHost, 15);
            this.init();
        }

        SshToolsSimpleConnectionDialog(Dialog dialog) {
            super(dialog, SshToolsSimpleConnectionPrompt.this.title, true);
            this.cancelled = true;
            this.advanced = false;
            this.promptLabel = new JLabel();
            this.hostname = new JTextField(SshToolsSimpleConnectionPrompt.this.lastHost, 15);
            this.init();
        }
    }
}

