/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import java.io.IOException;

class SshAgentFailure
extends SubsystemMessage {
    public static final int SSH_AGENT_FAILURE = 102;
    public static final int SSH_AGENT_ERROR_TIMEOUT = 1;
    public static final int SSH_AGENT_ERROR_KEY_NOT_FOUND = 2;
    public static final int SSH_AGENT_ERROR_DECRYPT_FAILED = 3;
    public static final int SSH_AGENT_ERROR_SIZE_ERROR = 4;
    public static final int SSH_AGENT_ERROR_KEY_NOT_SUITABLE = 5;
    public static final int SSH_AGENT_ERROR_DENIED = 6;
    public static final int SSH_AGENT_ERROR_FAILURE = 7;
    public static final int SSH_AGENT_ERROR_UNSUPPORTED_OP = 8;
    private int errorcode;

    public SshAgentFailure() {
        super(102);
    }

    public SshAgentFailure(int errorcode) {
        super(102);
        this.errorcode = errorcode;
    }

    @Override
    public String getMessageName() {
        return "SSH_AGENT_FAILURE";
    }

    public int getErrorCode() {
        return this.errorcode;
    }

    @Override
    public void constructByteArray(ByteArrayWriter baw) throws IOException, InvalidMessageException {
        try {
            baw.writeInt(this.errorcode);
        }
        catch (IOException ioe) {
            throw new InvalidMessageException(ioe.getMessage());
        }
    }

    @Override
    public void constructMessage(ByteArrayReader bar) throws IOException, InvalidMessageException {
        try {
            this.errorcode = (int)bar.readInt();
        }
        catch (IOException ioe) {
            throw new InvalidMessageException(ioe.getMessage());
        }
    }
}

