/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelState;
import com.sshtools.j2ssh.connection.SshMsgChannelData;
import com.sshtools.j2ssh.connection.SshMsgChannelExtendedData;
import java.io.IOException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BindingChannel
extends Channel {
    private Log log = LogFactory.getLog(BindingChannel.class);
    protected BindingChannel boundChannel;
    protected Vector messages = new Vector();

    public boolean isBound() {
        return this.boundChannel != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindChannel(BindingChannel boundChannel) throws IOException {
        if (boundChannel == null) {
            throw new IOException("[" + this.getName() + "] Bound channel cannot be null");
        }
        if (this.isBound()) {
            throw new IOException("[" + this.getName() + "] This channel is already bound to another channel [" + boundChannel.getName() + "]");
        }
        this.boundChannel = boundChannel;
        if (!boundChannel.isBound()) {
            boundChannel.bindChannel(this);
            Vector vector = this.messages;
            synchronized (vector) {
                if (boundChannel.isOpen() && this.messages.size() > 0) {
                    this.sendOutstandingMessages();
                }
            }
        } else if (!boundChannel.boundChannel.equals(this)) {
            throw new IOException("[" + this.getName() + "] Channel is already bound to an another channel [" + boundChannel.boundChannel.getName() + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendOutstandingMessages() throws IOException {
        if (this.boundChannel == null) {
            return;
        }
        Vector vector = this.messages;
        synchronized (vector) {
            for (Object obj : this.messages) {
                if (obj instanceof SshMsgChannelData) {
                    this.boundChannel.sendChannelData(((SshMsgChannelData)obj).getChannelData());
                    continue;
                }
                if (obj instanceof SshMsgChannelExtendedData) {
                    this.boundChannel.sendChannelExtData(((SshMsgChannelExtendedData)obj).getDataTypeCode(), ((SshMsgChannelExtendedData)obj).getChannelData());
                    continue;
                }
                throw new IOException("[" + this.getName() + "] Invalid message type in pre bound message list!");
            }
            this.messages.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onChannelExtData(SshMsgChannelExtendedData msg) throws IOException {
        Vector vector = this.messages;
        synchronized (vector) {
            if (this.boundChannel != null) {
                if (this.boundChannel.isOpen()) {
                    this.boundChannel.sendChannelExtData(msg.getDataTypeCode(), msg.getChannelData());
                } else {
                    this.messages.add(msg);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onChannelData(SshMsgChannelData msg) throws IOException {
        Vector vector = this.messages;
        synchronized (vector) {
            if (this.boundChannel != null) {
                if (this.boundChannel.isOpen()) {
                    this.boundChannel.sendChannelData(msg.getChannelData());
                } else {
                    this.messages.add(msg);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setRemoteEOF() throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            super.setRemoteEOF();
            if (!this.boundChannel.isLocalEOF()) {
                this.log.info("onRemoteEOF [" + this.getName() + "] is setting " + this.boundChannel.getName() + " to EOF");
                this.boundChannel.setLocalEOF();
            }
        }
    }

    @Override
    protected void onChannelEOF() throws IOException {
    }

    @Override
    protected void onChannelClose() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onChannelOpen() throws IOException {
        Vector vector = this.messages;
        synchronized (vector) {
            if (this.boundChannel != null && this.boundChannel.isOpen() && this.messages.size() > 0) {
                this.sendOutstandingMessages();
            }
        }
    }
}

