/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.net;

import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.net.HttpProxySocketProvider;
import com.sshtools.j2ssh.net.SocketTransportProvider;
import com.sshtools.j2ssh.net.SocksProxySocket;
import com.sshtools.j2ssh.net.TransportProvider;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransportProviderFactory {
    private static Log log = LogFactory.getLog(TransportProviderFactory.class);

    public static TransportProvider connectTransportProvider(SshConnectionProperties properties, int socketTimeout) throws UnknownHostException, IOException {
        if (properties.getTransportProvider() == 2) {
            log.debug("Use HttpProxySocketProvider");
            return HttpProxySocketProvider.connectViaProxy(properties.getHost(), properties.getPort(), properties.getProxyHost(), properties.getProxyPort(), properties.getProxyUsername(), properties.getProxyPassword(), "J2SSH");
        }
        if (properties.getTransportProvider() == 3) {
            log.debug("Use SocksProxySocket 4");
            return SocksProxySocket.connectViaSocks4Proxy(properties.getHost(), properties.getPort(), properties.getProxyHost(), properties.getProxyPort(), properties.getProxyUsername());
        }
        if (properties.getTransportProvider() == 4) {
            log.debug("Use SocksProxySocket 5");
            return SocksProxySocket.connectViaSocks5Proxy(properties.getHost(), properties.getPort(), properties.getProxyHost(), properties.getProxyPort(), properties.getProxyUsername(), properties.getProxyPassword());
        }
        log.debug("Use normal socket");
        InetAddress.getByName(properties.getHost());
        SocketTransportProvider socket = new SocketTransportProvider(properties.getHost(), properties.getPort());
        socket.setTcpNoDelay(true);
        socket.setSoTimeout(socketTimeout);
        return socket;
    }
}

