/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.cipher;

import com.sshtools.j2ssh.transport.AlgorithmOperationException;
import com.sshtools.j2ssh.transport.cipher.SshCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Aes128Ctr
extends SshCipher {
    private static Log log = LogFactory.getLog(Aes128Ctr.class);
    protected static String algorithmName = "aes128-ctr";
    Cipher cipher;

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public void init(int mode, byte[] iv, byte[] keydata) throws AlgorithmOperationException {
        try {
            this.cipher = Cipher.getInstance("AES/CTR/NoPadding");
            byte[] actualKey = new byte[16];
            System.arraycopy(keydata, 0, actualKey, 0, actualKey.length);
            SecretKeySpec keyspec = new SecretKeySpec(actualKey, "AES");
            this.cipher.init(mode == 0 ? 1 : 2, (Key)keyspec, new IvParameterSpec(iv, 0, this.cipher.getBlockSize()));
        }
        catch (NoSuchPaddingException nspe) {
            log.error("AES initialization failed", nspe);
            throw new AlgorithmOperationException("No Padding not supported");
        }
        catch (NoSuchAlgorithmException nsae) {
            log.error("AES initialization failed", nsae);
            throw new AlgorithmOperationException("Algorithm not supported");
        }
        catch (InvalidKeyException ike) {
            log.error("AES initialization failed", ike);
            throw new AlgorithmOperationException("Invalid encryption key");
        }
        catch (InvalidAlgorithmParameterException ape) {
            log.error("AES initialization failed", ape);
            throw new AlgorithmOperationException("Invalid algorithm parameter");
        }
    }

    @Override
    public byte[] transform(byte[] data, int offset, int len) throws AlgorithmOperationException {
        return this.cipher.update(data, offset, len);
    }
}

