/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshterm.emulation;

import com.sshtools.sshterm.emulation.SoftFont;
import com.sshtools.sshterm.emulation.VDUBuffer;
import com.sshtools.sshterm.emulation.VDUDisplay;
import com.sshtools.sshterm.emulation.VDUInput;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JScrollBar;

public class TerminalPanel
extends JComponent
implements VDUDisplay,
KeyListener,
MouseListener,
MouseMotionListener,
Printable {
    private static final int debug = 0;
    private static final long VDU_EVENTS = 131260L;
    public static final int RESIZE_NONE = 0;
    public static final int RESIZE_FONT = 1;
    public static final int RESIZE_SCREEN = 2;
    public static final int COLOR_BOLD = 8;
    public static final int COLOR_INVERT = 9;
    private static final int COLOR_FG_STD = 7;
    private static final int COLOR_BG_STD = 0;
    private VDUBuffer buffer;
    private Insets insets;
    private boolean raised;
    private Font normalFont;
    private FontMetrics fm;
    private int charWidth;
    private int charHeight;
    private int charDescent;
    private int resizeStrategy;
    private Point selectBegin;
    private Point selectEnd;
    private String selection;
    protected JScrollBar scrollBar;
    private SoftFont sf = new SoftFont();
    private boolean colorPrinting = false;
    private Image backingStore = null;
    private boolean antialias;
    private Color[] color = new Color[]{Color.black, Color.red, Color.green, Color.yellow, Color.blue, Color.magenta, Color.cyan, Color.white, null, null};
    private Color cursorColorFG = null;
    private Color cursorColorBG = null;
    private MouseListener mouseListener;
    private MouseMotionListener mouseMotionListener;
    private KeyListener keyListener;
    FocusListener focusListener;
    private boolean inDrag = false;
    private long lastRelease = 0L;

    public TerminalPanel(VDUBuffer buffer, Font font) {
        this.setVDUBuffer(buffer);
        this.addKeyListener(this);
        String version = System.getProperty("java.version");
        try {
            Class[] params = new Class[]{Boolean.TYPE};
            TerminalPanel.class.getMethod("setFocusable", params).invoke((Object)this, new Boolean(true));
            TerminalPanel.class.getMethod("setFocusTraversalKeysEnabled", params).invoke((Object)this, new Boolean(false));
        }
        catch (Exception e) {
            System.err.println("vt320: unable to reset focus handling for java version " + version);
            e.printStackTrace();
        }
        this.enableEvents(131260L);
        this.setResizeStrategy(1);
        String[] fnts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        boolean lucidaTypewriterFound = false;
        boolean courierNewFound = false;
        for (int i = 0; i < fnts.length; ++i) {
            if (fnts[i].equals("Lucida Sans Typewriter")) {
                lucidaTypewriterFound = true;
            }
            if (!fnts[i].equals("Courier New")) continue;
            courierNewFound = true;
        }
        if (font != null) {
            this.setFont(font);
        } else if (System.getProperty("os.name").startsWith("Windows")) {
            if (courierNewFound) {
                this.setFont(new Font("Courier New", 0, 13));
            } else if (lucidaTypewriterFound) {
                this.setFont(new Font("Lucida Sans Typewriter", 0, 11));
            } else {
                this.setFont(new Font("Monospaced", 0, 11));
            }
        } else {
            this.setFont(new Font("Monospaced", 0, 11));
        }
        this.setForeground(Color.white);
        this.setBackground(Color.black);
        this.cursorColorFG = this.color[7];
        this.cursorColorBG = this.color[0];
        this.clearSelection();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.selection = null;
    }

    public TerminalPanel(VDUBuffer buffer) {
        this(buffer, null);
    }

    private Color brighten(Color clr) {
        int r = (int)this.min((double)clr.getRed() * 1.2, 255.0);
        int g = (int)this.min((double)clr.getGreen() * 1.2, 255.0);
        int b = (int)this.min((double)clr.getBlue() * 1.2, 255.0);
        return new Color(r, g, b);
    }

    private Color darken(Color clr) {
        int r = (int)this.max((double)clr.getRed() * 0.8, 0.0);
        int g = (int)this.max((double)clr.getGreen() * 0.8, 0.0);
        int b = (int)this.max((double)clr.getBlue() * 0.8, 0.0);
        return new Color(r, g, b);
    }

    protected double max(double f1, double f2) {
        return f1 < f2 ? f2 : f1;
    }

    protected double min(double f1, double f2) {
        return f1 < f2 ? f1 : f2;
    }

    public synchronized void setAntialias(boolean antialias) {
        this.antialias = antialias;
        this.repaint();
    }

    public boolean isAntialias() {
        return this.antialias;
    }

    @Override
    public synchronized void setVDUBuffer(VDUBuffer buffer) {
        this.buffer = buffer;
        buffer.setDisplay(this);
    }

    @Override
    public VDUBuffer getVDUBuffer() {
        return this.buffer;
    }

    public synchronized void setColorSet(Color[] colorset) {
        System.arraycopy(colorset, 0, this.color, 0, 10);
        this.buffer.update[0] = true;
        this.redraw();
    }

    public Color[] getColorSet() {
        return this.color;
    }

    @Override
    public synchronized void setFont(Font font) {
        this.normalFont = font;
        super.setFont(this.normalFont);
        this.fm = this.getFontMetrics(font);
        if (this.fm != null) {
            this.charWidth = this.fm.charWidth('@');
            this.charHeight = this.fm.getHeight();
            this.charDescent = this.fm.getDescent();
        }
        if (this.buffer.update != null) {
            this.buffer.update[0] = true;
        }
        this.redraw();
    }

    public synchronized void setResizeStrategy(int strategy) {
        this.resizeStrategy = strategy;
        this.setBounds(this.getBounds());
    }

    public synchronized void setBorder(int thickness, boolean raised) {
        this.insets = thickness == 0 ? null : new Insets(thickness + 1, thickness + 1, thickness + 1, thickness + 1);
        this.raised = raised;
    }

    public synchronized void setScrollbar(JScrollBar scrollBar) {
        if (scrollBar == null) {
            return;
        }
        this.scrollBar = scrollBar;
        this.scrollBar.setValues(this.buffer.windowBase, this.buffer.height, 0, this.buffer.bufSize - this.buffer.height - 1);
        this.scrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent evt) {
                TerminalPanel.this.buffer.setWindowBase(evt.getValue());
            }
        });
    }

    @Override
    public synchronized void redraw() {
        if (this.backingStore != null) {
            this.redraw(this.backingStore.getGraphics());
            this.repaint();
        }
    }

    protected synchronized void redraw(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        if (this.isAntialias()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int xoffset = (super.getSize().width - this.buffer.width * this.charWidth) / 2;
        int yoffset = (super.getSize().height - this.buffer.height * this.charHeight) / 2;
        int selectStartLine = this.selectBegin.y - this.buffer.windowBase;
        int selectEndLine = this.selectEnd.y - this.buffer.windowBase;
        Color fg = this.color[7];
        Color bg = this.color[0];
        g.setFont(this.normalFont);
        for (int l = 0; l < this.buffer.height; ++l) {
            int selectEndColumn;
            int selectStartColumn;
            if (!this.buffer.update[0] && !this.buffer.update[l + 1]) continue;
            this.buffer.update[l + 1] = false;
            for (int c = 0; c < this.buffer.width; ++c) {
                int addr = 0;
                int currAttr = this.buffer.charAttributes[this.buffer.windowBase + l][c];
                fg = this.getForeground();
                bg = this.getBackground();
                if ((currAttr & 0xF0) != 0) {
                    fg = this.darken(this.color[((currAttr & 0xF0) >> 4) - 1]);
                }
                if ((currAttr & 0xF00) != 0) {
                    bg = this.darken(this.darken(this.color[((currAttr & 0xF00) >> 8) - 1]));
                }
                if ((currAttr & 1) != 0) {
                    g.setFont(new Font(this.normalFont.getName(), 1, this.normalFont.getSize()));
                    if (null != this.color[8]) {
                        fg = this.color[8];
                    }
                } else {
                    g.setFont(this.normalFont);
                }
                if ((currAttr & 8) != 0) {
                    fg = this.darken(fg);
                }
                if ((currAttr & 4) != 0) {
                    if (null == this.color[9]) {
                        Color swapc = bg;
                        bg = fg;
                        fg = swapc;
                    } else {
                        fg = null == this.color[8] ? bg : this.color[8];
                        bg = this.color[9];
                    }
                }
                if (this.sf.inSoftFont(this.buffer.charArray[this.buffer.windowBase + l][c])) {
                    g.setColor(bg);
                    g.fillRect(c * this.charWidth + xoffset, l * this.charHeight + yoffset, this.charWidth, this.charHeight);
                    g.setColor(fg);
                    this.sf.drawChar(g, this.buffer.charArray[this.buffer.windowBase + l][c], xoffset + c * this.charWidth, l * this.charHeight + yoffset, this.charWidth, this.charHeight);
                    if ((currAttr & 2) == 0) continue;
                    g.drawLine(c * this.charWidth + xoffset, (l + 1) * this.charHeight - this.charDescent / 2 + yoffset, c * this.charWidth + this.charWidth + xoffset, (l + 1) * this.charHeight - this.charDescent / 2 + yoffset);
                    continue;
                }
                while (!(c + addr >= this.buffer.width || this.buffer.charArray[this.buffer.windowBase + l][c + addr] >= ' ' && this.buffer.charAttributes[this.buffer.windowBase + l][c + addr] != currAttr || this.sf.inSoftFont(this.buffer.charArray[this.buffer.windowBase + l][c + addr]))) {
                    if (this.buffer.charArray[this.buffer.windowBase + l][c + addr] < ' ') {
                        this.buffer.charArray[this.buffer.windowBase + l][c + addr] = 32;
                        this.buffer.charAttributes[this.buffer.windowBase + l][c + addr] = 0;
                        continue;
                    }
                    ++addr;
                }
                g.setColor(bg);
                g.fillRect(c * this.charWidth + xoffset, l * this.charHeight + yoffset, addr * this.charWidth, this.charHeight);
                g.setColor(fg);
                g.drawChars(this.buffer.charArray[this.buffer.windowBase + l], c, addr, c * this.charWidth + xoffset, (l + 1) * this.charHeight - this.charDescent + yoffset);
                if ((currAttr & 2) != 0) {
                    g.drawLine(c * this.charWidth + xoffset, (l + 1) * this.charHeight - this.charDescent / 2 + yoffset, c * this.charWidth + addr * this.charWidth + xoffset, (l + 1) * this.charHeight - this.charDescent / 2 + yoffset);
                }
                c += addr - 1;
            }
            if (l < selectStartLine || l > selectEndLine) continue;
            int n = selectStartColumn = l == selectStartLine ? this.selectBegin.x : 0;
            int n2 = l == selectEndLine ? (l == selectStartLine ? this.selectEnd.x : this.selectEnd.x) : (selectEndColumn = this.buffer.width);
            if (selectStartColumn == selectEndColumn) continue;
            g.setXORMode(bg);
            g.fillRect(selectStartColumn * this.charWidth + xoffset, l * this.charHeight + yoffset, (selectEndColumn - selectStartColumn) * this.charWidth, this.charHeight);
            g.setPaintMode();
        }
        if (this.buffer.showcursor && this.buffer.screenBase + this.buffer.cursorY >= this.buffer.windowBase && this.buffer.screenBase + this.buffer.cursorY < this.buffer.windowBase + this.buffer.height) {
            g.setColor(this.cursorColorFG);
            g.setXORMode(this.cursorColorBG);
            g.fillRect(this.buffer.cursorX * this.charWidth + xoffset, (this.buffer.cursorY + this.buffer.screenBase - this.buffer.windowBase) * this.charHeight + yoffset, this.charWidth, this.charHeight);
            g.setPaintMode();
            g.setColor(this.color[7]);
        }
        if (this.insets != null) {
            g.setColor(this.getBackground());
            --xoffset;
            --yoffset;
            for (int i = this.insets.top - 1; i >= 0; --i) {
                g.draw3DRect(xoffset - i, yoffset - i, this.charWidth * this.buffer.width + 1 + i * 2, this.charHeight * this.buffer.height + 1 + i * 2, this.raised);
            }
        }
        this.buffer.update[0] = false;
    }

    @Override
    public synchronized void paint(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        if (this.isAntialias()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.backingStore == null) {
            Dimension size = super.getSize();
            this.backingStore = this.createImage(size.width, size.height);
            this.buffer.update[0] = true;
            this.redraw();
            Graphics g2 = this.backingStore.getGraphics();
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, super.getSize().width, super.getSize().height);
        }
        g.drawImage(this.backingStore, 0, 0, this);
    }

    public void setColorPrinting(boolean colorPrint) {
        this.colorPrinting = colorPrint;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        this.print(graphics);
        return pageIndex == 0 ? 0 : 1;
    }

    @Override
    public void print(Graphics g) {
        for (int i = 0; i <= this.buffer.height; ++i) {
            this.buffer.update[i] = true;
        }
        Color fg = null;
        Color bg = null;
        Color[] colorSave = null;
        if (!this.colorPrinting) {
            fg = this.getForeground();
            bg = this.getBackground();
            this.setForeground(Color.black);
            this.setBackground(Color.white);
            colorSave = this.color;
            this.color = new Color[]{Color.black, Color.black, Color.black, Color.black, Color.black, Color.black, Color.black, Color.white, null, null};
        }
        this.redraw(g);
        if (!this.colorPrinting) {
            this.color = colorSave;
            this.setForeground(fg);
            this.setBackground(bg);
        }
    }

    public Point mouseGetPos(Point evtpt) {
        Point mousepos = new Point(0, 0);
        int xoffset = (super.getSize().width - this.buffer.width * this.charWidth) / 2;
        int yoffset = (super.getSize().height - this.buffer.height * this.charHeight) / 2;
        mousepos.x = (evtpt.x - xoffset) / this.charWidth;
        if (mousepos.x < 0) {
            mousepos.x = 0;
        }
        if (mousepos.x >= this.buffer.width) {
            mousepos.x = this.buffer.width - 1;
        }
        mousepos.y = (evtpt.y - yoffset) / this.charHeight;
        if (mousepos.y < 0) {
            mousepos.y = 0;
        }
        if (mousepos.y >= this.buffer.height) {
            mousepos.y = this.buffer.height - 1;
        }
        return mousepos;
    }

    public synchronized void setCursorColors(Color fg, Color bg) {
        this.cursorColorFG = fg == null ? this.color[7] : fg;
        this.cursorColorBG = bg == null ? this.color[0] : bg;
        this.repaint();
    }

    @Override
    public synchronized void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        if (x == 0 && y == 0 && w == 0 && h == 0) {
            return;
        }
        if (this.insets != null) {
            w -= this.insets.left + this.insets.right;
            h -= this.insets.top + this.insets.bottom;
        }
        Font tmpFont = this.normalFont;
        String fontName = tmpFont.getName();
        int fontStyle = tmpFont.getStyle();
        this.fm = this.getFontMetrics(this.normalFont);
        if (this.fm != null) {
            this.charWidth = this.fm.charWidth('@');
            this.charHeight = this.fm.getHeight();
        }
        switch (this.resizeStrategy) {
            case 2: {
                if (this.buffer.width == w / this.charWidth && this.buffer.height == h / this.charHeight) break;
                this.buffer.setScreenSize(w / this.charWidth, h / this.charHeight);
                break;
            }
            case 1: {
                int height = h / this.buffer.height;
                int width = w / this.buffer.width;
                this.normalFont = new Font(fontName, fontStyle, this.charHeight);
                this.fm = this.getFontMetrics(this.normalFont);
                if (this.fm.getHeight() < height || this.fm.charWidth('@') < width) {
                    do {
                        this.normalFont = new Font(fontName, fontStyle, ++this.charHeight);
                        this.fm = this.getFontMetrics(this.normalFont);
                    } while (this.fm.getHeight() < height || this.fm.charWidth('@') < width);
                }
                if (this.fm.getHeight() > height || this.fm.charWidth('@') > width) {
                    do {
                        this.normalFont = new Font(fontName, fontStyle, --this.charHeight);
                        this.fm = this.getFontMetrics(this.normalFont);
                    } while (this.charHeight > 1 && (this.fm.getHeight() > height || this.fm.charWidth('@') > width));
                }
                if (this.charHeight <= 1) {
                    System.err.println("VDU: error during resize, resetting to default");
                    this.normalFont = new Font(fontName, fontStyle, 10);
                    System.err.println("VDU: disabling font/screen resize");
                }
                this.setFont(this.normalFont);
                this.fm = this.getFontMetrics(this.normalFont);
                this.charWidth = this.fm.charWidth('@');
                this.charHeight = this.fm.getHeight();
                this.charDescent = this.fm.getDescent();
                break;
            }
        }
        Dimension size = super.getSize();
        if (size.width <= 0) {
            size.width = 1;
        }
        if (size.height <= 0) {
            size.height = 1;
        }
        this.backingStore = this.createImage(size.width, size.height);
        if (this.backingStore != null) {
            Graphics g = this.backingStore.getGraphics();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, size.width, size.height);
            this.buffer.update[0] = true;
            this.redraw();
        }
    }

    public synchronized void refresh() {
        this.backingStore = null;
        this.repaint();
    }

    @Override
    public Dimension getSize() {
        int xborder = 0;
        int yborder = 0;
        if (this.insets != null) {
            xborder = this.insets.left + this.insets.right;
            yborder = this.insets.top + this.insets.bottom;
        }
        return new Dimension(this.buffer.width * this.charWidth + xborder, this.buffer.height * this.charHeight + yborder);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getSize();
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    public synchronized void clearSelection() {
        this.buffer.update[0] = true;
        this.selectBegin = new Point(0, 0);
        this.selectEnd = new Point(0, 0);
        this.selection = null;
    }

    @Override
    public synchronized void checkedClearSelection() {
        if (!this.inDrag) {
            this.buffer.update[0] = true;
            this.selectBegin = new Point(0, 0);
            this.selectEnd = new Point(0, 0);
            this.selection = null;
        }
    }

    public String getSelection() {
        return this.selection;
    }

    @Override
    public JScrollBar getScrollBar() {
        return this.scrollBar;
    }

    private boolean buttonCheck(int modifiers, int mask) {
        return (modifiers & mask) == mask;
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
    }

    private synchronized void selectWord(int x, int y) {
        int i;
        int xoffset = (super.getSize().width - this.buffer.width * this.charWidth) / 2;
        int yoffset = (super.getSize().height - this.buffer.height * this.charHeight) / 2;
        x = (x - xoffset) / this.charWidth;
        y = (y - yoffset) / this.charHeight + this.buffer.windowBase;
        char[] l = this.buffer.charArray[y];
        for (i = x; i >= 0 && l[i] != ' '; --i) {
        }
        if (i != x) {
            int j;
            this.selectBegin.y = y;
            this.selectBegin.x = i + 1;
            this.selectEnd.y = y;
            for (j = x; j < l.length && l[j] != ' '; ++j) {
            }
            this.selectEnd.x = j;
            this.buildSelectionText();
            this.buffer.update[0] = true;
            this.redraw();
        }
    }

    private synchronized void selectLine(int x, int y) {
        int i;
        int xoffset = (super.getSize().width - this.buffer.width * this.charWidth) / 2;
        int yoffset = (super.getSize().height - this.buffer.height * this.charHeight) / 2;
        x = (x - xoffset) / this.charWidth;
        y = (y - yoffset) / this.charHeight + this.buffer.windowBase;
        char[] l = this.buffer.charArray[y];
        for (i = 0; i < l.length && l[i] == ' '; ++i) {
        }
        if (i < l.length) {
            int j;
            this.selectBegin.y = y;
            this.selectEnd.y = y;
            this.selectBegin.x = i;
            for (j = l.length - 1; j >= 0 && l[j] == ' '; --j) {
            }
            this.selectEnd.x = j + 1;
            this.buildSelectionText();
            this.buffer.update[0] = true;
            this.redraw();
        }
    }

    @Override
    public synchronized void mouseDragged(MouseEvent evt) {
        if (this.buttonCheck(evt.getModifiers(), 16) || evt.getModifiers() == 0) {
            if (new Date().getTime() - this.lastRelease > 10L) {
                this.inDrag = true;
            }
            int xoffset = (super.getSize().width - this.buffer.width * this.charWidth) / 2;
            int yoffset = (super.getSize().height - this.buffer.height * this.charHeight) / 2;
            int x = (evt.getX() - xoffset) / this.charWidth;
            int y = (evt.getY() - yoffset) / this.charHeight + this.buffer.windowBase;
            int oldx = this.selectEnd.x;
            int oldy = this.selectEnd.y;
            if (x <= this.selectBegin.x && y <= this.selectBegin.y && x >= 0) {
                this.selectBegin.x = x;
                this.selectBegin.y = y;
            } else {
                if (x <= this.buffer.width && x >= 0) {
                    this.selectEnd.x = x;
                }
                this.selectEnd.y = y;
            }
            if (oldx != x || oldy != y) {
                this.buffer.update[0] = true;
                this.redraw();
            }
        }
    }

    @Override
    public synchronized void mouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.selectWord(evt.getX(), evt.getY());
            this.copyNotify();
        } else if (evt.getClickCount() == 3) {
            this.selectLine(evt.getX(), evt.getY());
            this.copyNotify();
        } else {
            this.requestFocus();
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public synchronized void mousePressed(MouseEvent evt) {
        this.requestFocus();
        int xoffset = (super.getSize().width - this.buffer.width * this.charWidth) / 2;
        int yoffset = (super.getSize().height - this.buffer.height * this.charHeight) / 2;
        if (this.buffer instanceof VDUInput) {
            ((VDUInput)((Object)this.buffer)).mousePressed(xoffset, yoffset, evt.getModifiers());
        }
        if (this.buttonCheck(evt.getModifiers(), 16)) {
            this.selectBegin.x = (evt.getX() - xoffset) / this.charWidth;
            this.selectBegin.y = (evt.getY() - yoffset) / this.charHeight + this.buffer.windowBase;
            this.selectEnd.x = this.selectBegin.x;
            this.selectEnd.y = this.selectBegin.y;
        }
    }

    @Override
    public synchronized void mouseReleased(MouseEvent evt) {
        this.inDrag = false;
        this.lastRelease = new Date().getTime();
        int xoffset = (super.getSize().width - this.buffer.width * this.charWidth) / 2;
        int yoffset = (super.getSize().height - this.buffer.height * this.charHeight) / 2;
        if (this.buffer instanceof VDUInput) {
            ((VDUInput)((Object)this.buffer)).mousePressed(xoffset, yoffset, evt.getModifiers());
        }
        if (this.buttonCheck(evt.getModifiers(), 16)) {
            this.mouseDragged(evt);
            if (this.selectBegin.x == this.selectEnd.x && this.selectBegin.y == this.selectEnd.y) {
                this.buffer.update[0] = true;
                this.redraw();
                return;
            }
            if (this.selectEnd.x < 0) {
                this.selectEnd.x = 0;
            }
            if (this.selectEnd.y < 0) {
                this.selectEnd.y = 0;
            }
            if (this.selectEnd.y >= this.buffer.charArray.length) {
                this.selectEnd.y = this.buffer.charArray.length - 1;
            }
            if (this.selectEnd.x > this.buffer.charArray[0].length) {
                this.selectEnd.x = this.buffer.charArray[0].length;
            }
            this.buildSelectionText();
            this.copyNotify();
        }
    }

    private void buildSelectionText() {
        this.selection = "";
        for (int l = this.selectBegin.y; l <= this.selectEnd.y; ++l) {
            int end;
            int start;
            start = l == this.selectBegin.y ? (start = this.selectBegin.x) : 0;
            end = l == this.selectEnd.y ? (end = this.selectEnd.x) : this.buffer.charArray[l].length;
            this.selection = this.selection + ("-" + new String(this.buffer.charArray[l]).substring(start, end)).trim().substring(1);
            if (end != this.buffer.charArray[l].length) continue;
            this.selection = this.selection + "\n";
        }
    }

    public void copyNotify() {
    }

    @Override
    public synchronized void keyTyped(KeyEvent e) {
        if (this.buffer != null) {
            ((VDUInput)((Object)this.buffer)).keyTyped(e.getKeyCode(), e.getKeyChar(), this.getModifiers(e));
        }
    }

    @Override
    public synchronized void keyPressed(KeyEvent e) {
        if (this.buffer != null) {
            ((VDUInput)((Object)this.buffer)).keyPressed(e.getKeyCode(), e.getKeyChar(), this.getModifiers(e));
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, listener);
        this.enableEvents(16L);
    }

    @Override
    public void removeMouseListener(MouseListener listener) {
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, listener);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener listener) {
        this.mouseMotionListener = AWTEventMulticaster.add(this.mouseMotionListener, listener);
        this.enableEvents(16L);
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener listener) {
        this.mouseMotionListener = AWTEventMulticaster.remove(this.mouseMotionListener, listener);
    }

    @Override
    public synchronized void processMouseEvent(MouseEvent evt) {
        if (this.mouseListener != null) {
            switch (evt.getID()) {
                case 500: {
                    this.mouseListener.mouseClicked(evt);
                    break;
                }
                case 504: {
                    this.mouseListener.mouseEntered(evt);
                    break;
                }
                case 505: {
                    this.mouseListener.mouseExited(evt);
                    break;
                }
                case 501: {
                    this.mouseListener.mousePressed(evt);
                    break;
                }
                case 502: {
                    this.mouseListener.mouseReleased(evt);
                }
            }
        }
        super.processMouseEvent(evt);
    }

    @Override
    public synchronized void processMouseMotionEvent(MouseEvent evt) {
        if (this.mouseMotionListener != null) {
            switch (evt.getID()) {
                case 506: {
                    this.mouseMotionListener.mouseDragged(evt);
                    break;
                }
                case 503: {
                    this.mouseMotionListener.mouseMoved(evt);
                }
            }
        }
        super.processMouseMotionEvent(evt);
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, listener);
        this.enableEvents(8L);
    }

    @Override
    public void removeKeyListener(KeyListener listener) {
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, listener);
    }

    @Override
    public synchronized void processKeyEvent(KeyEvent evt) {
        if (this.keyListener != null) {
            switch (evt.getID()) {
                case 401: {
                    this.keyListener.keyPressed(evt);
                    break;
                }
                case 402: {
                    this.keyListener.keyReleased(evt);
                    break;
                }
                case 400: {
                    this.keyListener.keyTyped(evt);
                }
            }
        }
        if (evt.getKeyCode() == 9 && evt.getSource() == this) {
            evt.consume();
        }
        super.processKeyEvent(evt);
    }

    @Override
    public void addFocusListener(FocusListener listener) {
        this.focusListener = AWTEventMulticaster.add(this.focusListener, listener);
    }

    @Override
    public void removeFocusListener(FocusListener listener) {
        this.focusListener = AWTEventMulticaster.remove(this.focusListener, listener);
    }

    @Override
    public synchronized void processFocusEvent(FocusEvent evt) {
        if (this.focusListener != null) {
            switch (evt.getID()) {
                case 1004: {
                    this.focusListener.focusGained(evt);
                    break;
                }
                case 1005: {
                    this.focusListener.focusLost(evt);
                }
            }
        }
        super.processFocusEvent(evt);
    }

    private int getModifiers(KeyEvent e) {
        return (e.isControlDown() ? 1 : 0) | (e.isShiftDown() ? 2 : 0) | (e.isAltDown() ? 4 : 0) | (e.isMetaDown() ? 256 : 0) | (e.isActionKey() ? 8 : 0);
    }
}

