/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshvnc;

import com.sshtools.common.ui.CloseAction;
import com.sshtools.common.ui.ConnectionPropertiesAction;
import com.sshtools.common.ui.DataNotificationListener;
import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.RefreshAction;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.SshToolsApplicationSessionPanel;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.StandardAction;
import com.sshtools.common.ui.StatusBar;
import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.forwarding.ForwardingChannel;
import com.sshtools.j2ssh.forwarding.ForwardingConfiguration;
import com.sshtools.j2ssh.forwarding.ForwardingIOChannel;
import com.sshtools.j2ssh.forwarding.VNCDisplay;
import com.sshtools.j2ssh.io.IOStreamConnector;
import com.sshtools.j2ssh.session.SessionChannelClient;
import com.sshtools.sshterm.emulation.TerminalEmulation;
import com.sshtools.sshterm.emulation.TerminalPanel;
import com.sshtools.sshvnc.ClipboardAction;
import com.sshtools.sshvnc.CtrlAltDelAction;
import com.sshtools.sshvnc.SshVNC;
import com.sshtools.sshvnc.SshVNCOptions;
import com.sshtools.sshvnc.SshVNCViewer;
import com.sshtools.sshvnc.SshVncFullScreenWindowContainer;
import com.sshtools.sshvnc.VNCAdvancedTab;
import com.sshtools.sshvnc.VNCTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshVncSessionPanel
extends SshToolsApplicationSessionPanel
implements ActionListener {
    public static final String PROFILE_PROPERTY_VNC_HOST = "VNC_HOST";
    public static final String PROFILE_PROPERTY_VNC_DISPLAY = "VNC_DISPLAY";
    public static final String PROFILE_PROPERTY_PREFERRED_ENCODING = "PREFERRED_ENCODING";
    public static final String PROFILE_PROPERTY_USE_COPY_RECT = "USE_COPY_RECT";
    public static final String PROFILE_PROPERTY_COMPRESS_LEVEL = "COMPRESS_LEVEL";
    public static final String PROFILE_PRE_VNC_COMMAND = "PRE_VNC_COMMAND";
    public static final String PROFILE_POST_VNC_COMMAND = "POST_VNC_COMMAND";
    public static final String PROFILE_PROPERTY_JPEG_QUALITY = "JPEG_QUALITY";
    public static final String PROFILE_PROPERTY_CURSOR_UPDATES = "CURSOR_UPDATES";
    public static final String PROFILE_PROPERTY_EIGHT_BIT_COLORS = "EIGHT_BIT_COLORS";
    public static final String PROFILE_PROPERTY_REVERSE_MOUSE_BUTTONS_2_AND_3 = "REVERSE_MOUSE_BUTTONS_2_AND_3";
    public static final String PROFILE_PROPERTY_SHARE_DESKTOP = "SHARE_DESKTOP";
    public static final String PROFILE_PROPERTY_VIEW_ONLY = "VIEW_ONLY";
    protected static Log log = LogFactory.getLog(SshVNC.class);
    private static boolean debug = true;
    public static final ResourceIcon MY3SP_VNC_ICON = new ResourceIcon(SshVncSessionPanel.class, "sshvncframeicon.gif");
    private boolean closing = false;
    private SshVNCViewer vnc;
    private StandardAction closeAction;
    private StandardAction refreshAction;
    private StandardAction clipboardAction;
    private StandardAction ctrlAltDelAction;
    private StandardAction recordAction;
    private StandardAction stopAction;
    private Thread rfbThread;
    private JFileChooser recordingFileChooser;
    private VNCTab vncTab;
    private StatusBar statusBar;
    private Timer sendTimer;
    private Timer receiveTimer;
    private SessionChannelClient sessionCloserSession;
    private TerminalPanel terminal;
    protected TerminalEmulation emulation;
    private boolean fullScreenMode;
    private SshToolsConnectionTab[] additionalTabs;
    private ConnectionPropertiesAction connectionPropertiesAction;
    private VncThread vncThread;
    protected SshClient ssh;
    private ChannelEventListener eventListener;

    @Override
    public void init(SshToolsApplication application) throws SshToolsApplicationException {
        super.init(application);
        this.setLayout(new BorderLayout());
        this.sendTimer = new Timer(500, this);
        this.sendTimer.setRepeats(false);
        this.receiveTimer = new Timer(500, this);
        this.receiveTimer.setRepeats(false);
        this.statusBar = new StatusBar();
        this.statusBar.setUser("");
        this.statusBar.setHost("");
        this.statusBar.setStatusText("Disconnected");
        this.statusBar.setConnected(false);
        this.setLayout(new BorderLayout());
        try {
            this.emulation = this.createEmulation();
        }
        catch (IOException ioe) {
            throw new SshToolsApplicationException(ioe);
        }
        this.emulation.setBufferSize(1000);
        this.terminal = new TerminalPanel(this.emulation);
        this.terminal.requestFocus();
        try {
            this.vnc = new SshVNCViewer();
            this.additionalTabs = new SshToolsConnectionTab[]{new VNCTab(), new VNCAdvancedTab()};
            this.add((Component)this.vnc, "Center");
            this.initActions();
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            IconWrapperPanel p = new IconWrapperPanel(UIManager.getIcon("OptionPane.errorIcon"), new ErrorTextBox((t.getMessage() == null ? "<no message supplied>" : t.getMessage()) + (debug ? "\n\n" + sw.getBuffer().toString() : "")));
            p.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this.add((Component)p, "Center");
            throw new SshToolsApplicationException("Failed to start SshVNC. ", t);
        }
    }

    @Override
    public ResourceIcon getIcon() {
        return MY3SP_VNC_ICON;
    }

    @Override
    public String getId() {
        return "sshvnc";
    }

    @Override
    public void addEventListener(ChannelEventListener eventListener) {
        this.eventListener = eventListener;
        if (this.vncThread != null) {
            this.vncThread.getChannel().addEventListener(eventListener);
        }
    }

    @Override
    public SshToolsConnectionTab[] getAdditionalConnectionTabs() {
        return this.additionalTabs;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.receiveTimer) {
            this.statusBar.setReceiving(false);
        } else if (evt.getSource() == this.sendTimer) {
            this.statusBar.setSending(false);
        }
    }

    @Override
    public boolean requiresConfiguration() {
        return true;
    }

    public void setFrameResizeable(boolean frameResizeable) {
        this.vnc.setFrameResizeable(frameResizeable);
    }

    public void opened(ForwardingConfiguration config, ForwardingChannel channel) {
    }

    public void closed(ForwardingConfiguration config, ForwardingChannel channel) {
    }

    public void dataReceived(ForwardingConfiguration config, ForwardingChannel channel, int bytes) {
        if (!this.receiveTimer.isRunning()) {
            this.statusBar.setReceiving(true);
            this.receiveTimer.start();
        }
    }

    public void setFullScreenMode(boolean full) {
        if (this.fullScreenMode != full) {
            try {
                if (!full) {
                    this.application.convertContainer(this.getContainer(), SshVncSessionPanel.class);
                } else {
                    this.application.convertContainer(this.getContainer(), SshVncFullScreenWindowContainer.class);
                }
                this.requestFocus();
                this.fullScreenMode = full;
            }
            catch (SshToolsApplicationException sshte) {
                sshte.printStackTrace();
                log.error(sshte);
            }
            this.setAvailableActions();
        }
    }

    public void dataSent(ForwardingConfiguration config, ForwardingChannel channel, int bytes) {
        if (!this.sendTimer.isRunning()) {
            this.statusBar.setSending(true);
            this.sendTimer.start();
        }
    }

    @Override
    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    @Override
    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void initVNC(InputStream in, OutputStream out, SshVNCOptions options) {
        log.info("Initialising VNC");
        try {
            this.vnc.init(in, out, this, options);
        }
        catch (EOFException e) {
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void closeVNC() {
        this.vnc.closeConnection();
    }

    public void run() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeConnection(boolean doDisconnect) {
        block9: {
            this.closing = true;
            this.closeVNC();
            try {
                String command = this.getCurrentConnectionProfile().getApplicationProperty(PROFILE_POST_VNC_COMMAND, null);
                if (command == null || command.trim().length() <= 0 || !this.manager.isConnected()) break block9;
                this.statusBar.setStatusText("Executing command: " + command);
                this.remove(this.vnc);
                this.add((Component)this.terminal, "Center");
                this.emulation.reset();
                this.emulation.clearScreen();
                this.emulation.setCursorPosition(0, 0);
                this.terminal.refresh();
                log.debug("Executing post VNC command " + command);
                this.sessionCloserSession.requestPseudoTerminal("vt100", 80, 24, 0, 0, "");
                if (this.sessionCloserSession.executeCommand(command)) {
                    this.sessionCloserSession.bindInputStream(this.emulation.getTerminalInputStream());
                    this.sessionCloserSession.bindOutputStream(this.emulation.getTerminalOutputStream());
                }
                try {
                    this.sessionCloserSession.getState().waitForState(3);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.remove(this.terminal);
                    this.add((Component)this.vnc, "Center");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.manager.isConnected()) {
            this.manager.requestDisconnect();
        }
        this.statusBar.setUser("");
        this.statusBar.setHost("");
        this.statusBar.setStatusText("Closed");
        this.statusBar.setConnected(false);
        this.setAvailableActions();
        this.closing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onOpenSession() throws IOException {
        this.statusBar.setStatusText("User Authenticated");
        int localPort = 0;
        String host = this.getCurrentConnectionProfile().getApplicationProperty(PROFILE_PROPERTY_VNC_HOST, "localhost");
        String port = this.getCurrentConnectionProfile().getApplicationProperty(PROFILE_PROPERTY_VNC_DISPLAY, "5900");
        VNCDisplay display = new VNCDisplay(host + ":" + port, 5900);
        String addr = "0.0.0.0";
        String command = this.getCurrentConnectionProfile().getApplicationProperty(PROFILE_PRE_VNC_COMMAND, null);
        if (command != null && command.trim().length() > 0) {
            this.statusBar.setStatusText("Executing command: " + command);
            this.remove(this.vnc);
            this.add((Component)this.terminal, "Center");
            this.emulation.reset();
            this.emulation.clearScreen();
            this.emulation.setCursorPosition(0, 0);
            this.terminal.refresh();
            log.debug("Executing pre VNC command " + command);
            SessionChannelClient session = this.manager.openSession();
            this.sessionCloserSession = this.manager.openSession();
            session.requestPseudoTerminal("vt100", 80, 24, 0, 0, "");
            if (session.executeCommand(command)) {
                IOStreamConnector ios = new IOStreamConnector(session.getStderrInputStream(), this.emulation.getTerminalOutputStream());
                session.bindInputStream(this.emulation.getTerminalInputStream());
                session.bindOutputStream(this.emulation.getTerminalOutputStream());
            }
            try {
                session.getState().waitForState(3);
            }
            catch (InterruptedException ex) {
            }
            finally {
                this.remove(this.terminal);
                this.add((Component)this.vnc, "Center");
            }
        }
        this.statusBar.setStatusText("Setting up VNC forwarding");
        if (log.isDebugEnabled()) {
            log.debug("Setting up forwarding on 0.0.0.0 (" + localPort + ") to " + display.getHost() + ":" + display.getPort());
        }
        SshVNCOptions options = new SshVNCOptions(this.getCurrentConnectionProfile());
        this.statusBar.setStatusText("Initialising VNC");
        ForwardingIOChannel channel = new ForwardingIOChannel("direct-tcpip", "VNC", display.getHost(), display.getPort(), "0.0.0.0", display.getPort());
        if (this.manager.openChannel(channel)) {
            channel.addEventListener(new DataNotificationListener(this.statusBar));
            if (this.eventListener != null) {
                channel.addEventListener(this.eventListener);
            }
        } else {
            this.closeConnection(true);
            throw new IOException("Could not connect to the vnc server");
        }
        this.vncThread = new VncThread(channel);
        this.vncThread.start();
        this.setAvailableActions();
        return true;
    }

    private void initActions() {
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("File", "File", 102, 0));
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("Edit", "Edit", 101, 10));
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("View", "View", 118, 20));
        this.vncTab = new VNCTab();
        this.closeAction = new VncCloseAction();
        this.registerAction(this.closeAction);
        this.refreshAction = new VncRefreshAction();
        this.registerAction(this.refreshAction);
        this.ctrlAltDelAction = new VncCtrlAltDelAction();
        this.registerAction(this.ctrlAltDelAction);
        this.clipboardAction = new VncClipboardAction();
        this.registerAction(this.clipboardAction);
        this.connectionPropertiesAction = new VncConnectionPropertiesAction();
        this.registerAction(this.connectionPropertiesAction);
        this.deregisterAction(this.getAction("Options"));
        this.setActionVisible("New Window", false);
        this.setActionVisible("About", false);
    }

    private void startRecording() {
    }

    private void stopRecording() {
    }

    public void refresh() {
        try {
            this.vnc.refresh();
        }
        catch (IOException ioe) {
            this.closeConnection(true);
            SshVncSessionPanel.showErrorMessage(this, "Error", ioe);
        }
    }

    @Override
    public void setAvailableActions() {
        boolean connected = this.isConnected();
        this.closeAction.setEnabled(connected);
        this.refreshAction.setEnabled(connected);
        this.ctrlAltDelAction.setEnabled(connected);
        this.clipboardAction.setEnabled(connected);
        String sessionFile = this.vnc.getRecordingStatus();
        this.closeAction.setEnabled(connected);
    }

    @Override
    public void close() {
        this.closeConnection(true);
    }

    private TerminalEmulation createEmulation() throws IOException {
        return new TerminalEmulation("vt320");
    }

    @Override
    public boolean canClose() {
        return !this.isConnected() || JOptionPane.showConfirmDialog(this, "Close the current session and exit?", "Exit Application", 0, 3) != 1;
    }

    public class DisplayErrorMessage
    implements Runnable {
        @Override
        public void run() {
            JOptionPane.showMessageDialog(SshVncSessionPanel.this, "SSHVnc failed to open a forwarding channel", "SSHVnc", 0);
        }
    }

    public class VncThread
    extends SshThread {
        ForwardingIOChannel channel;

        public VncThread(ForwardingIOChannel channel) {
            super("VNC", false);
            this.channel = channel;
        }

        public Channel getChannel() {
            return this.channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean localPort = false;
            String host = SshVncSessionPanel.this.getCurrentConnectionProfile().getApplicationProperty(SshVncSessionPanel.PROFILE_PROPERTY_VNC_HOST, "localhost");
            String port = SshVncSessionPanel.this.getCurrentConnectionProfile().getApplicationProperty(SshVncSessionPanel.PROFILE_PROPERTY_VNC_DISPLAY, "5900");
            VNCDisplay display = new VNCDisplay(host + ":" + port, 5900);
            String addr = "0.0.0.0";
            String command = SshVncSessionPanel.this.getCurrentConnectionProfile().getApplicationProperty(SshVncSessionPanel.PROFILE_PRE_VNC_COMMAND, null);
            if (command != null && command.trim().length() > 0) {
                try {
                    SshVncSessionPanel.this.statusBar.setStatusText("Executing command: " + command);
                    SshVncSessionPanel.this.remove(SshVncSessionPanel.this.vnc);
                    SshVncSessionPanel.this.add((Component)SshVncSessionPanel.this.terminal, "Center");
                    SshVncSessionPanel.this.emulation.reset();
                    SshVncSessionPanel.this.emulation.clearScreen();
                    SshVncSessionPanel.this.emulation.setCursorPosition(0, 0);
                    SshVncSessionPanel.this.terminal.refresh();
                    log.debug("Executing pre VNC command" + command);
                    SessionChannelClient session = SshVncSessionPanel.this.ssh.openSessionChannel();
                    session.requestPseudoTerminal("vt100", 80, 24, 0, 0, "");
                    if (session.executeCommand(command)) {
                        session.bindInputStream(SshVncSessionPanel.this.emulation.getTerminalInputStream());
                        session.bindOutputStream(SshVncSessionPanel.this.emulation.getTerminalOutputStream());
                    }
                    session.getState().waitForState(3);
                }
                catch (Exception iox) {
                }
                finally {
                    SshVncSessionPanel.this.remove(SshVncSessionPanel.this.terminal);
                    SshVncSessionPanel.this.add((Component)SshVncSessionPanel.this.vnc, "Center");
                }
            }
            SshVncSessionPanel.this.initVNC(this.channel.getInputStream(), this.channel.getOutputStream(), new SshVNCOptions(SshVncSessionPanel.this.getCurrentConnectionProfile()));
        }
    }

    public class VncConnectionPropertiesAction
    extends ConnectionPropertiesAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            SshVncSessionPanel.this.editSettings(SshVncSessionPanel.this.getCurrentConnectionProfile());
        }
    }

    public class VncClipboardAction
    extends ClipboardAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            SshVncSessionPanel.this.vnc.setClipboardVisible(!SshVncSessionPanel.this.vnc.isClipboardVisible());
        }
    }

    public class VncCtrlAltDelAction
    extends CtrlAltDelAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                SshVncSessionPanel.this.vnc.sendCtrlAltDel();
            }
            catch (IOException ioe) {
                SshVncSessionPanel.this.closeConnection(true);
                SshToolsApplicationPanel.showErrorMessage(SshVncSessionPanel.this, "Error", ioe);
            }
        }
    }

    public class VncRefreshAction
    extends RefreshAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            SshVncSessionPanel.this.refresh();
        }
    }

    public class VncCloseAction
    extends CloseAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            SshVncSessionPanel.this.closeConnection(true);
        }
    }

    public class IOConnector
    extends Thread {
        InputStream in;
        OutputStream out;

        public IOConnector(InputStream in, OutputStream out) {
            super("IOConnector");
            this.in = in;
            this.out = out;
            this.start();
        }

        @Override
        public void run() {
            IOStreamConnector con = new IOStreamConnector(this.in, this.out);
        }
    }

    public class ErrorTextBox
    extends JTextArea {
        public ErrorTextBox(String text) {
            super(text);
            this.setOpaque(false);
            this.setWrapStyleWord(true);
            this.setLineWrap(true);
            this.setEditable(false);
        }
    }
}

