/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshvnc;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.NumericTextField;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.ui.XTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VNCTab
extends JPanel
implements SshToolsConnectionTab,
ActionListener {
    static final String DEFAULT = "<Default>";
    static final ResourceIcon vncIcon = new ResourceIcon(VNCTab.class, "largevnc.png");
    static final String DEFAULT_HOST = "localhost";
    static final String DEFAULT_DISPLAY = "1";
    protected SshToolsConnectionProfile profile;
    protected XTextField vncHost;
    protected JTextField startCommand;
    protected JTextField stopCommand;
    protected JRadioButton nix;
    protected JRadioButton windows;
    protected ButtonGroup group;
    protected JLabel display;
    protected NumericTextField port;
    protected JCheckBox jChkScreenSize;

    public VNCTab() {
        Insets ins = new Insets(2, 24, 2, 2);
        JPanel a = new JPanel(new GridBagLayout());
        a.setBorder(BorderFactory.createEtchedBorder());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = ins;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        JPanel serverType = new JPanel(new GridBagLayout());
        serverType.setBorder(BorderFactory.createTitledBorder("The VNC server I want to connect to is a"));
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.fill = 2;
        gbc2.anchor = 11;
        gbc2.insets = ins;
        gbc2.weightx = 1.0;
        gbc2.weightx = 0.0;
        this.windows = new JRadioButton("Windows/Macintosh");
        UIUtil.jGridBagAdd(serverType, this.windows, gbc2, -1);
        this.nix = new JRadioButton("Linux/Unix Variant");
        UIUtil.jGridBagAdd(serverType, this.nix, gbc2, -1);
        JPanel hostPortPanel = new JPanel(new GridBagLayout());
        hostPortPanel.setBorder(BorderFactory.createTitledBorder("Or manually specify the SSH forwarding settings"));
        gbc.insets = new Insets(2, 16, 2, 2);
        UIUtil.jGridBagAdd(hostPortPanel, new JLabel("Host "), gbc, -1);
        this.vncHost = new XTextField(15);
        gbc.insets = new Insets(2, 2, 2, 10);
        UIUtil.jGridBagAdd(hostPortPanel, this.vncHost, gbc, 0);
        gbc.insets = new Insets(2, 16, 2, 2);
        this.display = new JLabel("Display ");
        UIUtil.jGridBagAdd(hostPortPanel, this.display, gbc, -1);
        gbc.insets = new Insets(2, 2, 2, 10);
        this.port = new NumericTextField(new Integer(0), new Integer(65535), new Integer(1));
        UIUtil.jGridBagAdd(hostPortPanel, this.port, gbc, 0);
        this.group = new ButtonGroup();
        this.group.add(this.nix);
        this.group.add(this.windows);
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VNCTab.this.display.setText(VNCTab.this.windows.isSelected() ? "Port    " : "Display ");
                VNCTab.this.port.setValue(VNCTab.this.windows.isSelected() ? new Integer(5900) : new Integer(1));
            }
        };
        this.nix.addChangeListener(listener);
        this.windows.addChangeListener(listener);
        this.nix.setSelected(true);
        JPanel serverCommands = new JPanel(new GridBagLayout());
        serverCommands.setBorder(BorderFactory.createTitledBorder("You may enter commands to start/stop your VNC server"));
        gbc.insets = new Insets(2, 16, 2, 2);
        UIUtil.jGridBagAdd(serverCommands, new JLabel("Start VNC Command"), gbc, -1);
        gbc.insets = new Insets(2, 2, 2, 10);
        this.startCommand = new JTextField();
        UIUtil.jGridBagAdd(serverCommands, this.startCommand, gbc, 0);
        gbc.insets = new Insets(2, 16, 2, 2);
        UIUtil.jGridBagAdd(serverCommands, new JLabel("Stop VNC Command"), gbc, -1);
        gbc.insets = new Insets(2, 2, 2, 10);
        this.stopCommand = new JTextField();
        UIUtil.jGridBagAdd(serverCommands, this.stopCommand, gbc, 0);
        gbc.insets = new Insets(2, 16, 2, 2);
        this.jChkScreenSize = new JCheckBox("Resize window to fit the screen", true);
        UIUtil.jGridBagAdd(serverCommands, this.jChkScreenSize, gbc, 0);
        Box box = new Box(1);
        box.add(serverType);
        box.add(hostPortPanel);
        box.add(serverCommands);
        IconWrapperPanel w = new IconWrapperPanel(vncIcon, box);
        this.setLayout(new BorderLayout());
        this.add((Component)w, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setConnectionProfile(null);
    }

    @Override
    public void setConnectionProfile(SshToolsConnectionProfile profile) {
        this.profile = profile;
        String host = profile == null ? "" : profile.getApplicationProperty("VNC_HOST", "");
        String portStr = profile == null ? "" : profile.getApplicationProperty("VNC_DISPLAY", "");
        boolean os = true;
        if (!os) {
            this.windows.setSelected(true);
        } else {
            this.nix.setSelected(true);
        }
        if (host.equals("") || portStr.equals("")) {
            host = DEFAULT_HOST;
            portStr = DEFAULT_DISPLAY;
        }
        this.port.setText(portStr);
        this.vncHost.setText(host);
        if (profile != null) {
            this.startCommand.setText(profile.getApplicationProperty("PRE_VNC_COMMAND", ""));
            this.stopCommand.setText(profile.getApplicationProperty("POST_VNC_COMMAND", ""));
        }
        this.jChkScreenSize.setSelected(true);
        this.setAvailableActions();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.setAvailableActions();
    }

    private void setAvailableActions() {
    }

    @Override
    public SshToolsConnectionProfile getConnectionProfile() {
        return this.profile;
    }

    @Override
    public String getTabContext() {
        return "Connection";
    }

    @Override
    public Icon getTabIcon() {
        return null;
    }

    @Override
    public String getTabTitle() {
        return "VNC Settings";
    }

    @Override
    public String getTabToolTipText() {
        return "Here you can specify your VNC settings for this connection.  You can also enter commands to stop/start your remote VNC server here.";
    }

    @Override
    public int getTabMnemonic() {
        return 118;
    }

    @Override
    public Component getTabComponent() {
        return this;
    }

    @Override
    public boolean validateTab() {
        return true;
    }

    @Override
    public void applyTab() {
        this.profile.setApplicationProperty("sshvnc.configured", true);
        this.profile.setApplicationProperty("VNC_HOST", this.vncHost.getText().equals("") ? DEFAULT_HOST : this.vncHost.getText());
        this.profile.setApplicationProperty("VNC_DISPLAY", this.port.getText().equals("") ? "5900" : this.port.getText());
        if (this.nix.isSelected()) {
            this.profile.setApplicationProperty("VNC_SERVER_OS", 1);
        } else if (this.windows.isSelected()) {
            this.profile.setApplicationProperty("VNC_SERVER_OS", 0);
        }
        this.profile.setApplicationProperty("PRE_VNC_COMMAND", this.startCommand.getText());
        this.profile.setApplicationProperty("POST_VNC_COMMAND", this.stopCommand.getText());
        this.profile.setApplicationProperty("VNC_SCREEN_SIZE", this.jChkScreenSize.isSelected() ? 1 : 0);
    }

    @Override
    public void tabSelected() {
    }
}

