/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.tunnel;

import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.j2ssh.forwarding.ForwardingChannel;
import com.sshtools.j2ssh.forwarding.ForwardingConfiguration;
import com.sshtools.j2ssh.forwarding.ForwardingConfigurationListener;
import com.sshtools.j2ssh.forwarding.ForwardingSocketChannel;
import com.sshtools.sshterm.FolderBar;
import com.sshtools.tunnel.ActiveChannelModel;
import com.sshtools.tunnel.ActiveChannelTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ActiveChannelPane
extends JPanel
implements ForwardingConfigurationListener {
    private ActiveChannelTable table;
    private ActiveChannelModel model;
    private Vector configurationsVector = new Vector();

    public ActiveChannelPane() {
        super(new BorderLayout());
        this.add((Component)new FolderBar("Active Connections", new ResourceIcon(ActiveChannelPane.class, "forward.png")), "North");
        this.model = new ActiveChannelModel();
        this.table = new ActiveChannelTable(this.model);
        JScrollPane scroller = new JScrollPane(this.table){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 128);
            }
        };
        this.add((Component)scroller, "Center");
        this.table.getColumnModel().getColumn(0).setMaxWidth(30);
        this.table.getColumnModel().getColumn(0).setMinWidth(30);
        this.table.getColumnModel().getColumn(1).setMaxWidth(30);
        this.table.getColumnModel().getColumn(1).setMinWidth(30);
        this.table.getColumnModel().getColumn(2).setMaxWidth(100);
        this.table.getColumnModel().getColumn(2).setMinWidth(50);
        this.table.setAutoResizeMode(2);
    }

    public ActiveChannelTable getActiveChannelTable() {
        return this.table;
    }

    @Override
    public void opened(ForwardingConfiguration config, ForwardingChannel channel) {
        this.model.addActiveChannel(channel);
    }

    @Override
    public void closed(ForwardingConfiguration config, ForwardingChannel channel) {
        this.model.removeActiveChannel(channel);
    }

    @Override
    public void dataReceived(ForwardingConfiguration config, ForwardingChannel channel, int bytes) {
        this.model.dataReceived(channel);
    }

    @Override
    public void dataSent(ForwardingConfiguration config, ForwardingChannel channel, int bytes) {
        this.model.dataSent(channel);
    }

    public void removeConfiguration(ForwardingConfiguration conf) {
        if (this.configurationsVector.contains(conf)) {
            List active = conf.getActiveForwardingSocketChannels();
            conf.removeForwardingConfigurationListener(this);
            for (ForwardingSocketChannel channel : active) {
                this.model.removeActiveChannel(channel);
            }
            conf.removeForwardingConfigurationListener(this);
            this.configurationsVector.remove(conf);
        }
    }

    public void addConfiguration(ForwardingConfiguration conf) {
        if (!this.configurationsVector.contains(conf)) {
            conf.addForwardingConfigurationListener(this);
            this.configurationsVector.add(conf);
        }
    }

    public void setConfiguration(Vector configurations) {
        this.configurationsVector.clear();
        this.model.clear();
        if (configurations == null) {
            return;
        }
        for (ForwardingConfiguration f : configurations) {
            List active = f.getActiveForwardingSocketChannels();
            f.addForwardingConfigurationListener(this);
            for (ForwardingSocketChannel channel : active) {
                this.model.addActiveChannel(channel);
            }
            this.configurationsVector.add(f);
        }
    }
}

