/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.tunnel;

import com.sshtools.common.ui.NumericTextField;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.ui.XTextField;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class TunnelEditorPane
extends JPanel
implements ActionListener {
    private static int id = 1000;
    private NumericTextField bindPort;
    private NumericTextField connectPort;
    private JComboBox bindAddress;
    private XTextField connectHost;
    private XTextField name;
    private CardLayout bindLayout;
    private JPanel bindPanel;
    private XTextField bindRemoteAddress;
    private boolean isLocal = true;

    public TunnelEditorPane() {
        super(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        Insets normal = new Insets(2, 2, 2, 2);
        Insets indented = new Insets(2, 26, 2, 2);
        gbc.insets = normal;
        gbc.fill = 2;
        ButtonGroup type = new ButtonGroup();
        gbc.weightx = 2.0;
        gbc.weightx = 0.0;
        UIUtil.jGridBagAdd(this, new JLabel("Name "), gbc, -1);
        gbc.weightx = 1.0;
        this.name = new XTextField(this.getNextAutoId(), 10);
        UIUtil.jGridBagAdd(this, this.name, gbc, 0);
        gbc.weightx = 0.0;
        UIUtil.jGridBagAdd(this, new JLabel("Connect port "), gbc, -1);
        gbc.weightx = 1.0;
        this.connectPort = new NumericTextField(new Integer(0), new Integer(65535), new Integer(0));
        UIUtil.jGridBagAdd(this, this.connectPort, gbc, 0);
        gbc.weightx = 0.0;
        UIUtil.jGridBagAdd(this, new JLabel("Connect host "), gbc, -1);
        gbc.weightx = 1.0;
        this.connectHost = new XTextField("localhost", 10);
        UIUtil.jGridBagAdd(this, this.connectHost, gbc, 0);
        gbc.weightx = 0.0;
        UIUtil.jGridBagAdd(this, new JLabel("Bind port "), gbc, -1);
        gbc.weightx = 1.0;
        this.bindPort = new NumericTextField(new Integer(0), new Integer(65535), new Integer(0));
        UIUtil.jGridBagAdd(this, this.bindPort, gbc, 0);
        Vector<Object> interaceList = new Vector<Object>();
        try {
            interaceList.add("0.0.0.0");
            interaceList.add(InetAddress.getByName("127.0.0.1"));
            interaceList.add(InetAddress.getLocalHost());
        }
        catch (UnknownHostException ex) {
            // empty catch block
        }
        try {
            this.getClass();
            Method method = Class.forName("java.net.NetworkInterface").getMethod("getNetworkInterfaces", new Class[]{null});
            Enumeration e = (Enumeration)method.invoke(null, new Object[]{null});
            while (e.hasMoreElements()) {
                Object ni = e.nextElement();
                Method method2 = ni.getClass().getMethod("getInetAddresses", new Class[]{null});
                Enumeration z = (Enumeration)method2.invoke(ni, new Object[]{null});
                while (z.hasMoreElements()) {
                    Object obj = z.nextElement();
                    if (interaceList.contains(obj)) continue;
                    interaceList.add(obj);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        gbc.weighty = 1.0;
        gbc.weightx = 0.0;
        this.bindAddress = new JComboBox(interaceList);
        this.bindAddress.setEditable(false);
        this.bindRemoteAddress = new XTextField("0.0.0.0", 10);
        this.bindPanel = new JPanel();
        this.bindLayout = new CardLayout();
        this.bindPanel.setLayout(this.bindLayout);
        this.bindPanel.add("local", this.bindAddress);
        this.bindPanel.add("remote", this.bindRemoteAddress);
        UIUtil.jGridBagAdd(this, new JLabel("Bind address "), gbc, -1);
        gbc.weightx = 1.0;
        UIUtil.jGridBagAdd(this, this.bindPanel, gbc, 0);
        this.bindAddress.setRenderer(new InetAddressRenderer());
        this.setBindPanel();
    }

    public void setMode(boolean isLocal) {
        this.isLocal = isLocal;
        this.setBindPanel();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.setBindPanel();
    }

    private void setBindPanel() {
        this.bindLayout.show(this.bindPanel, this.isLocal ? "local" : "remote");
    }

    protected String getNextAutoId() {
        return "#".concat(String.valueOf(++id));
    }

    public String getForwardName() {
        return this.name.getText();
    }

    public void setForwardName(String name) {
        this.name.setText(name);
    }

    public int getPortToBind() {
        return (Integer)this.bindPort.getValue();
    }

    public void setPortToBind(int port) {
        this.bindPort.setValue(new Integer(port));
    }

    public String getAddressToBind() {
        try {
            if (this.bindAddress.getSelectedItem() instanceof InetAddress) {
                return this.bindAddress.getSelectedItem() == null ? InetAddress.getLocalHost().getHostAddress() : ((InetAddress)this.bindAddress.getSelectedItem()).getHostAddress();
            }
            return this.bindAddress.getSelectedItem().toString();
        }
        catch (UnknownHostException uhe) {
            return "127.0.0.1";
        }
    }

    public void setAddressToBind(String address) {
        for (int i = 0; i < this.bindAddress.getModel().getSize(); ++i) {
            if (this.bindAddress.getModel().getElementAt(i) instanceof InetAddress) {
                if (!((InetAddress)this.bindAddress.getModel().getElementAt(i)).getHostAddress().equals(address)) continue;
                this.bindAddress.setSelectedIndex(i);
                continue;
            }
            if (!this.bindAddress.getModel().getElementAt(i).equals(address)) continue;
            this.bindAddress.setSelectedIndex(i);
        }
        if (this.bindAddress.getSelectedIndex() < 0) {
            this.bindAddress.setSelectedIndex(0);
        }
    }

    public int getPortToConnect() {
        return (Integer)this.connectPort.getValue();
    }

    public void setPortToConnect(int port) {
        this.connectPort.setValue(new Integer(port));
    }

    public String getHostToConnect() {
        return this.connectHost.getText();
    }

    public void setHostToConnect(String host) {
        this.connectHost.setText(host);
    }

    public class InetAddressRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof InetAddress) {
                InetAddress ni = (InetAddress)value;
                this.setText(ni.getHostAddress());
                this.setToolTipText(ni.getHostName());
            } else {
                this.setText(value.toString());
                this.setToolTipText(value.toString());
            }
            return this;
        }
    }
}

