/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.hep.dcapj;

import edu.caltech.hep.dcapj.PnfsUtil;
import edu.caltech.hep.dcapj.dCapLayer;
import edu.caltech.hep.dcapj.util.ControlCommandCallback;
import edu.caltech.hep.dcapj.util.ControlConnection;
import edu.caltech.hep.dcapj.util.DataConnectionCallback;
import edu.caltech.hep.dcapj.util.IOCallback;
import edu.caltech.hep.dcapj.util.InvalidConfigurationException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.SocketException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class dCacheFile
extends File
implements DataConnectionCallback,
ControlCommandCallback {
    protected SocketChannel _clientChannel = null;
    private Logger _logger = Logger.getLogger(dCacheFile.class.getName());
    private boolean _connected = false;
    private boolean _poolReplied = false;
    private boolean _doorReplied = false;
    private ByteBuffer _commandBuffer = null;
    private IOCallback _poolCallback = null;
    private ControlConnection _controlConnection = null;
    private String _pnfsID;
    private int _sessionID = -1;
    private int _commandID = -1;
    private Mode _openMode;
    private long _max_bytes = Long.MAX_VALUE;
    private boolean _writable = false;
    private long _filesize;
    private int _poolID = 0;
    private int _mode;
    private SelectionKey _selectionKey;
    private String[] _doorReply = null;

    public dCacheFile(String name, String openMode) throws FileNotFoundException, IOException, InvalidConfigurationException {
        this(name, openMode.equals("w") ? Mode.WRITE_ONLY : Mode.READ_ONLY);
    }

    /*
     * Enabled aggressive block sorting
     */
    public dCacheFile(String name, Mode openMode) throws FileNotFoundException, IOException, InvalidConfigurationException {
        super(name);
        if (!dCapLayer.isInitialized()) {
            throw new InvalidConfigurationException("dCap layer should be initialized by   making a call to dCapLayer.initialze()");
        }
        this._openMode = openMode;
        this._logger.fine("[" + name + "] mode " + (Object)((Object)this._openMode));
        this._poolCallback = dCapLayer.getDataConnectionCallback();
        this._controlConnection = dCapLayer.getControlConnection();
        this._sessionID = this._controlConnection.getNextSessionID();
        this._logger.fine("[" + name + "] sessionID = " + this._sessionID);
        this._controlConnection.registerCallback(this._sessionID, this);
        this._logger.finer("[" + name + "] registered callback with sessionID " + this._sessionID);
        if (!super.exists()) {
            if (this._openMode != Mode.WRITE_ONLY) {
                FileNotFoundException ex = new FileNotFoundException("File does not exist " + name);
                this._logger.throwing("dCacheFile", "dCacheFile(String)", ex);
                throw ex;
            }
            if (super.createNewFile()) {
                this._logger.fine("Created new file " + super.getName());
            }
        } else if (this._openMode == Mode.WRITE_ONLY) {
            IOException ex = new IOException("File already exists");
            this._logger.throwing("dCacheFile", "dCacheFile(String)", ex);
            throw ex;
        }
        this._pnfsID = PnfsUtil.getPnfsID(super.getAbsolutePath());
        if (this._openMode == Mode.READ_ONLY) {
            this.open();
            this.tell();
            this._connected = true;
            this.getPoolID();
        }
    }

    private void open() throws IOException {
        this._logger.log(Level.FINE, "Opening file " + this.getAbsolutePath());
        boolean result = false;
        result = this._poolCallback.registerCallback(this._sessionID, this);
        if (!result) {
            String emsg = "Open failed on file " + this.getName() + "; Unable to register  pool call back for session " + this._sessionID;
            this._logger.severe(emsg);
            throw new IOException(emsg);
        }
        String mode = this._openMode == Mode.READ_ONLY ? "\"r\"" : "\"w\"";
        String ip = dCapLayer.getConfig().getInterface();
        if (ip == null) {
            IOException ex = new IOException("Cannot get ip address for system.");
            this._logger.severe(ex.getMessage());
            this._logger.throwing("dCacheFile", "open", ex);
            throw ex;
        }
        this._doorReplied = false;
        String openCommand = this._sessionID + " " + ++this._commandID + " client open " + this._pnfsID + " " + mode + " " + ip + " " + this._poolCallback.getPort();
        this._controlConnection.sendCommand(openCommand);
        long t0 = System.currentTimeMillis();
        int poolTimeout = dCapLayer.getConfig().getPoolTimeout();
        this._logger.finest("Pool timeout value is set as " + poolTimeout + " secs");
        while (!this._doorReplied && System.currentTimeMillis() - t0 < (long)(poolTimeout * 1000) && !this._poolReplied) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                this._logger.finer("Thread was interrupted while waiting for door reply");
            }
            this._logger.finest("Waiting for a reply from pool for" + super.getName());
        }
        if (this._doorReplied) {
            String reply = "";
            for (String replyPart : this._doorReply) {
                reply = reply + replyPart + " ";
            }
            String errormsg = "dCapJ " + reply;
            this._logger.severe(errormsg);
            throw new IOException(errormsg);
        }
        this._doorReplied = false;
        this._logger.fine("Waiting for a data call back connection");
        long t1 = System.currentTimeMillis();
        while (!this._poolReplied) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                this._logger.finer("Thread was interrupted while waiting for pool reply");
            }
            this._logger.finest("Waiting for a reply from pool for" + super.getName());
            if (System.currentTimeMillis() - t1 <= (long)(poolTimeout * 1000)) continue;
            this._logger.severe("Pool wait timedout!");
            throw new IOException("No reply from pool within give time");
        }
        this._logger.info("Pool connected for file: " + super.getName());
        ByteBuffer commandBuffer = ByteBuffer.allocate(20);
        commandBuffer.limit(4);
        this._clientChannel.read(commandBuffer);
        commandBuffer.rewind();
        int nBytes = commandBuffer.getInt();
        if (nBytes > 0) {
            commandBuffer.limit(nBytes);
            commandBuffer.rewind();
            this._clientChannel.read(commandBuffer);
            byte[] utf = new byte[commandBuffer.remaining()];
            commandBuffer.get(utf);
            String reply = new String(utf);
            this._logger.severe("Error receiving HELLO BLOCK." + reply);
            throw new IOException("Unknown error receiving HELLO BLOCK");
        }
        this._logger.fine("Received HELLO BLOCK [sessionID = " + this._sessionID + ", nBytes = " + nBytes);
    }

    public long seek(long offset, boolean relative) throws IOException {
        if (this._openMode == Mode.WRITE_ONLY) {
            IOException ex = new IOException("Cannot seek in WRITE mode.");
            this._logger.throwing("dCacheFile", "seek", ex);
        }
        this._logger.fine("Sending SEEK command to pool [offset = " + offset + ", relative = " + relative + "]");
        ByteBuffer _commandBuffer = ByteBuffer.allocate(30);
        _commandBuffer.putInt(16);
        _commandBuffer.putInt(3);
        _commandBuffer.putLong(offset);
        _commandBuffer.flip();
        this._clientChannel.write(_commandBuffer);
        _commandBuffer.rewind();
        _commandBuffer.limit(4);
        if (offset >= 0L) {
            if (relative) {
                _commandBuffer.putInt(1);
            } else {
                _commandBuffer.putInt(0);
            }
        } else if (offset < 0L) {
            _commandBuffer.putInt(2);
        }
        this._clientChannel.write(_commandBuffer);
        _commandBuffer.clear();
        _commandBuffer.limit(16);
        this._clientChannel.read(_commandBuffer);
        _commandBuffer.rewind();
        int nBytes = _commandBuffer.getInt();
        int ack = _commandBuffer.getInt();
        int cmdCode = _commandBuffer.getInt();
        int success = _commandBuffer.getInt();
        if (success != 0) {
            byte[] utf = new byte[_commandBuffer.remaining()];
            _commandBuffer.get(utf);
            String detail = new String(utf);
            this._logger.severe("SEEK command failed [nBytes = " + nBytes + ", ack = " + ack + ", cmdCode = " + cmdCode + ", success = " + success + "]\nPool replied: " + detail);
            IOException ex = new IOException(detail);
            this._logger.throwing("dCacheFile", "seek", ex);
            throw ex;
        }
        this._logger.fine("SEEK succeeded [nBytes = " + nBytes + ", ack = " + ack + ", cmdCode = " + cmdCode + ", success = " + success + "]");
        _commandBuffer.rewind();
        _commandBuffer.limit(8);
        this._clientChannel.read(_commandBuffer);
        return _commandBuffer.getLong();
    }

    public long tell() throws IOException {
        if (this._openMode == Mode.WRITE_ONLY) {
            IOException ex = new IOException("Cannot get cursor position in WRITE mode");
            this._logger.throwing("dCacheFiles", "tell", ex);
            throw ex;
        }
        this._logger.fine("Sending LOCATE command to pool");
        ByteBuffer _commandBuffer = ByteBuffer.allocate(30);
        _commandBuffer.putInt(4);
        _commandBuffer.putInt(9);
        _commandBuffer.flip();
        this._clientChannel.write(_commandBuffer);
        _commandBuffer.clear();
        _commandBuffer.limit(4);
        this._clientChannel.read(_commandBuffer);
        _commandBuffer.rewind();
        int nBytes = _commandBuffer.getInt();
        _commandBuffer.rewind();
        _commandBuffer.limit(nBytes);
        this._clientChannel.read(_commandBuffer);
        _commandBuffer.rewind();
        int ack = _commandBuffer.getInt();
        int cmdCode = _commandBuffer.getInt();
        int success = _commandBuffer.getInt();
        if (success != 0) {
            byte[] utf = new byte[_commandBuffer.remaining()];
            _commandBuffer.get(utf);
            String detail = new String(utf);
            this._logger.severe("LOCATE command failed [nBytes = " + nBytes + ", ack = " + ack + ", cmdCode = " + cmdCode + ", success = " + success + "]\nPool replied: " + detail);
            IOException ex = new IOException(detail);
            this._logger.throwing("dCacheFile", "tell", ex);
            throw ex;
        }
        this._logger.fine("LOCATE succeeded [nBytes = " + nBytes + ", ack = " + ack + ", cmdCode = " + cmdCode + ", success = " + success + "]");
        this._filesize = _commandBuffer.getLong();
        return _commandBuffer.getLong();
    }

    public int read(ByteBuffer bytes, long off) throws IOException {
        int num_bytes;
        if (this._openMode != Mode.READ_ONLY) {
            IOException ex = new IOException("File not opened for reading");
            this._logger.throwing("dCacheFile", "read(byte[], long)", ex);
            throw ex;
        }
        ByteBuffer _commandBuffer = ByteBuffer.allocate(30);
        if (off == 0L) {
            _commandBuffer.putInt(12);
            _commandBuffer.putInt(2);
        } else {
            _commandBuffer.putInt(24);
            _commandBuffer.putInt(11);
            _commandBuffer.putLong(off);
            _commandBuffer.putInt(0);
        }
        _commandBuffer.putLong(bytes.remaining());
        _commandBuffer.flip();
        _commandBuffer.rewind();
        this._clientChannel.write(_commandBuffer);
        this._logger.fine("Sending READ request for " + bytes.remaining() + " bytes from " + super.getName() + ".");
        _commandBuffer.clear();
        _commandBuffer.limit(4);
        this._clientChannel.read(_commandBuffer);
        _commandBuffer.rewind();
        for (num_bytes = 0; num_bytes < 12; num_bytes += _commandBuffer.getInt()) {
        }
        _commandBuffer.rewind();
        _commandBuffer.limit(num_bytes);
        this._clientChannel.read(_commandBuffer);
        _commandBuffer.rewind();
        int ack = _commandBuffer.getInt();
        int cmdCode = _commandBuffer.getInt();
        int success = _commandBuffer.getInt();
        if (success != 0) {
            byte[] utf = new byte[_commandBuffer.remaining()];
            _commandBuffer.get(utf);
            String detail = new String(utf);
            this._logger.fine("READ request successful [num_bytes = " + num_bytes + ", ack = " + ack + ", cmdCode = " + cmdCode + ", success = " + success + "]\nServer replied: ");
            IOException ex = new IOException(detail);
            this._logger.throwing("dCacheFile", "read(byte[])", ex);
            throw ex;
        }
        this._logger.fine("READ request successful [num_bytes = " + num_bytes + ", ack = " + ack + ", cmdCode = " + cmdCode + ", success = " + success + "]");
        _commandBuffer.rewind();
        _commandBuffer.limit(8);
        this._clientChannel.read(_commandBuffer);
        _commandBuffer.rewind();
        num_bytes = _commandBuffer.getInt();
        int data = _commandBuffer.getInt();
        this._logger.fine("READ: Data header received [num_bytes = " + num_bytes + " data " + data + "]");
        int bytes_read = 0;
        int position = 0;
        block1: while (true) {
            _commandBuffer.rewind();
            _commandBuffer.limit(4);
            this._clientChannel.read(_commandBuffer);
            _commandBuffer.rewind();
            num_bytes = _commandBuffer.getInt();
            this._logger.finest("READ: Number of bytes available from pool " + num_bytes);
            if (num_bytes < 0) break;
            int restPacket = num_bytes;
            while (true) {
                int block;
                if (restPacket <= 0) continue block1;
                int rest = block = restPacket;
                while (rest > 0) {
                    bytes.position(position);
                    bytes.limit(position + rest);
                    int rc = this._clientChannel.read(bytes);
                    if (rc < 0) {
                        throw new IOException("Read operation terminted prematurely");
                    }
                    rest -= rc;
                    position += rc;
                }
                bytes_read += block;
                restPacket -= block;
            }
            break;
        }
        _commandBuffer.rewind();
        _commandBuffer.limit(16);
        this._clientChannel.read(_commandBuffer);
        _commandBuffer.rewind();
        num_bytes = _commandBuffer.getInt();
        int fin = _commandBuffer.getInt();
        cmdCode = _commandBuffer.getInt();
        success = _commandBuffer.getInt();
        if (success != 0) {
            byte[] utf = new byte[_commandBuffer.remaining()];
            _commandBuffer.get(utf);
            String detail = new String(utf);
            this._logger.severe("Failed while reading " + super.getName() + "[num_bytes = " + num_bytes + ", fin = " + fin + ", cmdCode = " + cmdCode + ", success = " + success + "]\nServer replied: " + detail);
            IOException ex = new IOException(detail);
            this._logger.throwing("dCacheFile", "read(byte[])", ex);
            throw ex;
        }
        this._logger.fine("Read " + bytes_read + " bytes from " + super.getName());
        return bytes_read == 0 ? -1 : bytes_read;
    }

    public int read(byte[] bytes) throws IOException {
        throw new IOException("Not Implemented Yet");
    }

    public int getPoolID() {
        if (!this._connected) {
            try {
                this.open();
                this.tell();
                this._connected = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this._logger.info("PoolID: " + this._poolID);
        return this._poolID;
    }

    private long makeWritable(long position) throws IOException {
        this._commandBuffer.clear();
        if (position == -1L) {
            this._commandBuffer.putInt(4);
            this._commandBuffer.putInt(1);
        } else {
            this._commandBuffer.putInt(16);
            this._commandBuffer.putInt(12);
            this._commandBuffer.putLong(position);
            this._commandBuffer.putInt(0);
        }
        this._commandBuffer.flip();
        this._clientChannel.write(this._commandBuffer);
        this._logger.fine("Sent WRITE request [position = " + position + "]");
        this._logger.fine("Receiving reply from pool");
        this._commandBuffer.clear();
        for (int bytes_read = 0; bytes_read < 12; bytes_read += this._clientChannel.read(this._commandBuffer)) {
        }
        this._commandBuffer.flip();
        int num_bytes = this._commandBuffer.getInt();
        int ack = this._commandBuffer.getInt();
        int cmdCode = this._commandBuffer.getInt();
        int success = this._commandBuffer.getInt();
        if (success != 0) {
            byte[] utf = new byte[this._commandBuffer.remaining()];
            this._commandBuffer.get(utf);
            String detail = new String(utf);
            this._logger.severe("WRITE failed for " + super.getName() + "[num_bytes = " + num_bytes + ", ack = " + ack + ", cmdCode = " + cmdCode + ", success = " + success + "]\nServer replied: " + detail + ".");
            IOException ex = new IOException(detail);
            this._logger.throwing("dCacheFile", "write(byte[], int, int, long)", ex);
            throw ex;
        }
        if (num_bytes != 12) {
            if (num_bytes == 24) {
                this._commandBuffer.position(this._commandBuffer.position() + 4);
                this._max_bytes = this._commandBuffer.getLong();
                this._logger.fine("WRITE request succeeded for " + super.getName() + ". Server limited write size. [num_bytes = " + num_bytes + ", ack = " + ack + ", cmdCode = " + cmdCode + ", success = " + success + ", max_bytes = " + this._max_bytes + "]");
            } else if (num_bytes == 16) {
                this._commandBuffer.position(this._commandBuffer.position() + 4);
                this._logger.fine("WRITE request succeeded for " + super.getName() + ". Server replied EXPECT_NEW_CONNECTION. [num_bytes = " + num_bytes + ", ack = " + ack + ", cmdCode = " + cmdCode + ", success = " + success + "]");
            }
        } else {
            this._logger.fine("WRITE request succeeded for " + super.getName() + " [num_bytes = " + num_bytes + ", ack = " + ack + ", cmdCode = " + cmdCode + ", success = " + success + "]");
        }
        this._writable = true;
        return this._max_bytes;
    }

    public int write(ByteBuffer buffer, long position) throws IOException {
        if (!this._connected) {
            this.open();
            this.tell();
            this._connected = true;
            this._logger.fine("PoolID: " + this.getPoolID());
        }
        try {
            if (this._commandBuffer == null) {
                this._commandBuffer = ByteBuffer.allocate(128);
            } else {
                this._commandBuffer.clear();
            }
            if (this._openMode != Mode.WRITE_ONLY) {
                IOException ex = new IOException("File not opened for writing");
                this._logger.throwing("dCacheFile", "write(byte[], int, int, long)", ex);
                throw ex;
            }
            if (this._max_bytes < (long)buffer.remaining()) {
                IOException ex = new IOException("Cannot write more than " + this._max_bytes + " to " + super.getName());
                this._logger.throwing("dCacheFile", "write(byte[], int, int, long)", ex);
                throw ex;
            }
            if (!this._writable) {
                this.makeWritable(position);
            }
            this._commandBuffer.clear();
            this._commandBuffer.putInt(4);
            this._commandBuffer.putInt(8);
            this._commandBuffer.putInt(buffer.remaining());
            this._logger.finest("Writing " + buffer.remaining() + " bytes to " + super.getName() + " starting...");
            this._commandBuffer.flip();
            while (this._commandBuffer.hasRemaining()) {
                this._clientChannel.write(this._commandBuffer);
            }
            int bytes_written = 0;
            while (buffer.hasRemaining()) {
                bytes_written += this._clientChannel.write(buffer);
            }
            this._logger.finest("File was opened write only, telling pool transfer is complete");
            this.finishedWriting();
            this._logger.finest("[" + super.getName() + "] Bytes written = " + bytes_written);
            this._max_bytes -= (long)bytes_written;
            return bytes_written;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    private void finishedWriting() throws IOException {
        int num_bytes;
        this._commandBuffer.clear();
        this._commandBuffer.putInt(-1);
        this._commandBuffer.flip();
        this._clientChannel.write(this._commandBuffer);
        this._commandBuffer.clear();
        for (num_bytes = 0; num_bytes < 12; num_bytes += this._clientChannel.read(this._commandBuffer)) {
        }
        this._logger.finest("Bytes read: " + num_bytes);
        this._commandBuffer.flip();
        num_bytes = this._commandBuffer.getInt();
        int fin = this._commandBuffer.getInt();
        int cmdCode = this._commandBuffer.getInt();
        int success = this._commandBuffer.getInt();
        if (success != 0) {
            byte[] utf = new byte[this._commandBuffer.remaining()];
            this._commandBuffer.get(utf);
            String detail = new String(utf);
            IOException ex = new IOException(detail);
            this._logger.info("Error writing file to pool [num_bytes = " + num_bytes + ", fin = " + fin + ", cmdCode = " + cmdCode + ", success = " + success + "]\nServer replied: " + detail);
            this._logger.throwing("dCacheFile", "close", ex);
            throw ex;
        }
        this._logger.fine("Success code received from the pool");
        this._writable = false;
    }

    public void close() throws IOException {
        int success;
        int cmdCode;
        int ack;
        int num_bytes;
        ByteBuffer _commandBuffer;
        block9: {
            _commandBuffer = ByteBuffer.allocate(30);
            this._logger.info("Close on " + super.getName());
            this._connected = false;
            num_bytes = 0;
            ack = 0;
            cmdCode = 0;
            success = -1;
            try {
                int numread;
                _commandBuffer.putInt(4);
                _commandBuffer.putInt(4);
                _commandBuffer.limit(8);
                _commandBuffer.rewind();
                this._logger.fine("Sending close command to pool");
                this._clientChannel.write(_commandBuffer);
                _commandBuffer.clear();
                _commandBuffer.limit(16);
                for (numread = 0; numread < 16; numread += this._clientChannel.read(_commandBuffer)) {
                }
                if (numread >= 16) {
                    _commandBuffer.rewind();
                    num_bytes = _commandBuffer.getInt();
                    ack = _commandBuffer.getInt();
                    cmdCode = _commandBuffer.getInt();
                    success = _commandBuffer.getInt();
                } else {
                    this._logger.warning("Close command read " + numread + " bytes expected 16");
                }
            }
            catch (BufferOverflowException of) {
                this._logger.fine("Closed() " + of.getMessage());
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.throwing("dCacheFile", "close", of);
                }
            }
            catch (BufferUnderflowException uf) {
                this._logger.fine("Closed() " + uf.getMessage());
                if (!this._logger.isLoggable(Level.FINE)) break block9;
                this._logger.throwing("dCacheFile", "close", uf);
            }
        }
        if (success != 0) {
            byte[] detail = new byte[_commandBuffer.remaining()];
            _commandBuffer.get(detail);
            IOException ex = new IOException(new String(detail));
            this._logger.info("Error writing file to pool [num_bytes = " + num_bytes + ", ack = " + ack + ", cmdCode = " + cmdCode + ", success = " + success + "]\nServer replied: " + new String(detail));
            this._logger.throwing("dCacheFile", "close", ex);
            throw ex;
        }
        this._poolCallback.unregisterCallback(this._sessionID);
        this._controlConnection.unregisterCallback(this._sessionID);
        if (this._logger.isLoggable(Level.FINE)) {
            Thread.dumpStack();
        }
        this._logger.info(super.getName() + " closed");
    }

    @Override
    public long length() {
        return this._filesize;
    }

    public int available() throws IOException {
        return Integer.MAX_VALUE;
    }

    public Mode mode() {
        return this._openMode;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void handleStreams(DataInputStream dataIn, DataOutputStream dataOut, String host, SocketChannel client) {
        this._clientChannel = client;
        try {
            this._clientChannel.socket().setSendBufferSize(800000);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        this._logger.info("Data connection callback for " + super.getAbsolutePath());
        if (host != null) {
            this._poolID = host.hashCode();
        }
        this._poolReplied = true;
    }

    @Override
    public void handleDoorCommand(String[] input) {
        this._doorReply = input;
        this._doorReplied = true;
    }

    public static enum Mode {
        READ_ONLY,
        WRITE_ONLY;

    }
}

