/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.hep.dcapj.util;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ServerNIO
implements Runnable {
    private static final Logger logger = Logger.getLogger(ServerNIO.class.getName());
    protected boolean accept;
    protected ServerSocketChannel _serverChannel = null;
    protected ServerSocket _server = null;
    protected int timeout = 300000;
    private Thread serverThread = null;
    private boolean secure = true;

    public ServerNIO() throws IOException {
        this(0);
    }

    public ServerNIO(int port) throws IOException {
        this.init(port);
    }

    protected void init(int port) throws IOException {
        this._serverChannel = ServerSocketChannel.open();
        this._server = this._serverChannel.socket();
        InetSocketAddress address = new InetSocketAddress(port);
        this._server.bind(address);
        logger.log(Level.INFO, "ServerNIO initialzed to listen on port " + this._server.getLocalPort());
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void shutdown() {
        this.accept = false;
        try {
            this._server.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.serverThread.join();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        this.serverThread = null;
        this._server = null;
    }

    protected void start() {
        if (this.serverThread == null) {
            this.accept = true;
            this.serverThread = new Thread(this);
            this.serverThread.setName("dCapIOCallbackServerNIO");
            this.serverThread.start();
        }
    }

    public int getPort() {
        return this._server.getLocalPort();
    }

    @Override
    public void run() {
        SocketChannel socketChannel = null;
        while (this.accept) {
            block4: {
                try {
                    socketChannel = this._serverChannel.accept();
                    if (!this.accept) {
                    }
                    break block4;
                }
                catch (IOException e) {
                    if (!this.accept) break;
                    logger.log(Level.WARNING, "ServerNIO died: " + e.getMessage(), e);
                }
                break;
            }
            this.handleConnection(socketChannel);
        }
    }

    protected abstract void handleConnection(SocketChannel var1);
}

