/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.BCGSS;

import edu.illinois.ncsa.BCGSS.GlobusTlsCipherFactory;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.DERObject;
import edu.illinois.ncsa.bouncycastle.asn1.x509.X509CertificateStructure;
import edu.illinois.ncsa.bouncycastle.crypto.tls.Certificate;
import edu.illinois.ncsa.bouncycastle.crypto.tls.CertificateRequest;
import edu.illinois.ncsa.bouncycastle.crypto.tls.DefaultTlsClient;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsAuthentication;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsCredentials;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsFatalAlert;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsSignerCredentials;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;
import org.globus.common.CoGProperties;
import org.globus.gsi.CredentialException;
import org.globus.gsi.X509Credential;
import org.globus.gsi.X509ProxyCertPathParameters;
import org.globus.gsi.provider.KeyStoreParametersFactory;
import org.globus.gsi.stores.ResourceCertStoreParameters;
import org.globus.gsi.stores.ResourceSigningPolicyStore;
import org.globus.gsi.stores.ResourceSigningPolicyStoreParameters;
import org.globus.gsi.trustmanager.X509ProxyCertPathValidator;
import org.globus.gsi.util.CertificateUtil;

public class GlobusTlsClient
extends DefaultTlsClient {
    private Certificate clientCert = new Certificate(new X509CertificateStructure[0]);
    private PrivateKey clientPrivateKey = null;
    private X509Certificate[] peerCerts = null;

    public X509Certificate[] getPeerCerts() {
        return this.peerCerts;
    }

    public GlobusTlsClient(X509Credential cred, GlobusTlsCipherFactory factory) throws IOException, CertificateException, CredentialException {
        super(factory);
        if (cred == null) {
            throw new IllegalArgumentException("'cred' cannot be null");
        }
        this.clientCert = new Certificate(GlobusTlsClient.X509CertArrayToStructArray(cred.getCertificateChain()));
        this.clientPrivateKey = cred.getPrivateKey();
        if (this.clientCert.getCerts().length == 0) {
            throw new IllegalArgumentException("'cred' contains no certificates");
        }
        if (this.clientPrivateKey == null) {
            throw new IllegalArgumentException("'clientPrivateKey' cannot be null");
        }
    }

    public TlsAuthentication getAuthentication() throws IOException {
        return new GlobusTlsAuth();
    }

    public int[] getCipherSuites() {
        return new int[]{53, 47, 10};
    }

    public static X509Certificate X509CertStructToCert(X509CertificateStructure struct) throws CertificateException, IOException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream is = new ByteArrayInputStream(struct.getEncoded());
        X509Certificate cert = (X509Certificate)cf.generateCertificate(is);
        ((InputStream)is).close();
        return cert;
    }

    public static X509Certificate[] X509CertStructArrayToCertArray(X509CertificateStructure[] structs) throws IOException, CertificateException {
        X509Certificate[] certChain = new X509Certificate[structs.length];
        for (int i = 0; i < structs.length; ++i) {
            certChain[i] = GlobusTlsClient.X509CertStructToCert(structs[i]);
        }
        return certChain;
    }

    public static X509CertificateStructure X509CertToStruct(X509Certificate c) throws CertificateException, IOException {
        ASN1InputStream is = new ASN1InputStream(c.getEncoded());
        DERObject o = is.readObject();
        return X509CertificateStructure.getInstance(o);
    }

    public static X509CertificateStructure[] X509CertArrayToStructArray(X509Certificate[] certs) throws CertificateException, IOException {
        X509CertificateStructure[] structs = new X509CertificateStructure[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            structs[i] = GlobusTlsClient.X509CertToStruct(certs[i]);
        }
        return structs;
    }

    static /* synthetic */ X509Certificate[] access$002(GlobusTlsClient x0, X509Certificate[] x1) {
        x0.peerCerts = x1;
        return x1;
    }

    public class GlobusTlsCred
    implements TlsSignerCredentials {
        public byte[] generateCertificateSignature(byte[] md5andsha1) throws IOException {
            try {
                Cipher cipher = Cipher.getInstance(GlobusTlsClient.this.clientPrivateKey.getAlgorithm());
                cipher.init(1, GlobusTlsClient.this.clientPrivateKey);
                return cipher.doFinal(md5andsha1);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException(e);
            }
        }

        public Certificate getCertificate() {
            return GlobusTlsClient.this.clientCert;
        }
    }

    public class GlobusTlsAuth
    implements TlsAuthentication {
        public void notifyServerCertificate(Certificate certificate) throws IOException {
            try {
                GlobusTlsClient.access$002(GlobusTlsClient.this, GlobusTlsClient.X509CertStructArrayToCertArray(certificate.getCerts()));
                String caCertsLocation = "file:" + CoGProperties.getDefault().getCaCertLocations();
                String crlPattern = caCertsLocation + "/*.r*";
                String sigPolPattern = caCertsLocation + "/*.signing_policy";
                KeyStore keyStore = KeyStore.getInstance("PEMFilebasedKeyStore", "Globus");
                CertStore crlStore = CertStore.getInstance("PEMFilebasedCertStore", new ResourceCertStoreParameters(null, crlPattern));
                ResourceSigningPolicyStore sigPolStore = new ResourceSigningPolicyStore(new ResourceSigningPolicyStoreParameters(sigPolPattern));
                keyStore.load(KeyStoreParametersFactory.createTrustStoreParameters(caCertsLocation));
                X509ProxyCertPathParameters parameters = new X509ProxyCertPathParameters(keyStore, crlStore, sigPolStore, false);
                X509ProxyCertPathValidator validator = new X509ProxyCertPathValidator();
                if (validator.engineValidate(CertificateUtil.getCertPath(GlobusTlsClient.this.peerCerts), parameters) == null) {
                    throw new Exception("X509ProxyCertPathValidator did not return a result");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new TlsFatalAlert(90);
            }
        }

        public TlsCredentials getClientCredentials(CertificateRequest request) throws IOException {
            return new GlobusTlsCred();
        }
    }
}

