/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.BCGSS;

import edu.illinois.ncsa.BCGSS.CircularByteBuffer;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsClient;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsProtocolHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class TlsHandlerUtil {
    private TlsProtocolHandler tlsHandler;
    private TlsClient tlsClient;
    private CircularByteBuffer netInStream;
    private ByteArrayOutputStream netOutStream;
    private boolean connectionThreadStarted = false;
    private IOException connectionThreadException = null;

    public TlsHandlerUtil(TlsClient client) {
        this.tlsClient = client;
        this.netInStream = new CircularByteBuffer(-1);
        this.netOutStream = new ByteArrayOutputStream();
        this.tlsHandler = new TlsProtocolHandler(this.netInStream.getInputStream(), this.netOutStream);
    }

    public byte[] nextHandshakeToken(byte[] inNetBuf) throws IOException {
        return this.nextHandshakeToken(inNetBuf, 0, inNetBuf.length);
    }

    public byte[] nextHandshakeToken(byte[] inNetBuf, int off, int len) throws IOException {
        if (this.isHandshakeFinished()) {
            return null;
        }
        if (!this.isConnectionThreadStarted()) {
            new ConnectionThread().start();
        }
        if (this.tlsHandler.getHandshakeBlocking() > 0) {
            this.tlsHandler.decHandshakeBlocking(inNetBuf.length);
        }
        this.netInStream.getOutputStream().write(inNetBuf, off, len);
        while (this.tlsHandler.getHandshakeBlocking() == 0 && !this.isHandshakeFinished()) {
            IOException e = this.getConnectionThreadException();
            if (e != null) {
                throw new IOException("TLS connection thread exception", e);
            }
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException e1) {
                throw new IOException("Handshake interrupted while waiting for new network data to be processed", e1);
            }
        }
        byte[] token = this.drainNetOutStream();
        if (token.length > 0) {
            return token;
        }
        if (this.tlsHandler.getHandshakeBlocking() > 0) {
            return null;
        }
        if (this.isHandshakeFinished()) {
            return null;
        }
        throw new IOException("No handshake data available, but the record stream is not blocking and wasn't interrupted");
    }

    public byte[] wrap(byte[] appData) throws IOException {
        return this.wrap(appData, 0, appData.length);
    }

    public byte[] wrap(byte[] appData, int off, int len) throws IOException {
        if (!this.isHandshakeFinished()) {
            return null;
        }
        this.tlsHandler.getOutputStream().write(appData, off, len);
        return this.drainNetOutStream();
    }

    public byte[] unwrap(byte[] netData) throws IOException {
        return this.unwrap(netData, 0, netData.length);
    }

    public byte[] unwrap(byte[] netData, int off, int len) throws IOException {
        if (!this.isHandshakeFinished()) {
            return null;
        }
        if (netData.length == 0) {
            return null;
        }
        this.netInStream.getOutputStream().write(netData, off, len);
        byte[] tmp = new byte[1];
        this.tlsHandler.getInputStream().read(tmp, 0, 1);
        int avail = this.tlsHandler.getApplicationDataQueueSize();
        if (avail == 0) {
            return tmp;
        }
        byte[] appBuf = new byte[avail + 1];
        appBuf[0] = tmp[0];
        this.tlsHandler.getInputStream().read(appBuf, 1, avail);
        return appBuf;
    }

    public byte[] close() throws IOException {
        this.tlsHandler.close();
        return this.drainNetOutStream();
    }

    public boolean isHandshakeFinished() {
        return this.tlsHandler.isHandshakeFinished();
    }

    private byte[] drainNetOutStream() {
        byte[] rval = this.netOutStream.toByteArray();
        this.netOutStream.reset();
        return rval;
    }

    private synchronized void setConnectionThreadStarted(boolean b) {
        this.connectionThreadStarted = b;
    }

    private synchronized boolean isConnectionThreadStarted() {
        return this.connectionThreadStarted;
    }

    private IOException getConnectionThreadException() {
        return this.connectionThreadException;
    }

    private void setConnectionThreadException(IOException e) {
        this.connectionThreadException = e;
    }

    private class ConnectionThread
    extends Thread {
        private ConnectionThread() {
        }

        public void run() {
            TlsHandlerUtil.this.setConnectionThreadStarted(true);
            try {
                TlsHandlerUtil.this.tlsHandler.connect(TlsHandlerUtil.this.tlsClient);
            }
            catch (IOException e) {
                TlsHandlerUtil.this.setConnectionThreadException(e);
            }
        }
    }
}

