/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1Object;
import edu.illinois.ncsa.bouncycastle.asn1.DERBitString;
import edu.illinois.ncsa.bouncycastle.asn1.x509.KeyUsage;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTestResult;
import edu.illinois.ncsa.bouncycastle.util.test.Test;
import edu.illinois.ncsa.bouncycastle.util.test.TestResult;
import java.io.IOException;

public class BitStringTest
implements Test {
    public TestResult perform() {
        KeyUsage keyUsage = new KeyUsage(128);
        if (keyUsage.getBytes()[0] != -128 || keyUsage.getPadBits() != 7) {
            return new SimpleTestResult(false, this.getName() + ": failed digitalSignature");
        }
        keyUsage = new KeyUsage(64);
        if (keyUsage.getBytes()[0] != 64 || keyUsage.getPadBits() != 6) {
            return new SimpleTestResult(false, this.getName() + ": failed nonRepudiation");
        }
        keyUsage = new KeyUsage(32);
        if (keyUsage.getBytes()[0] != 32 || keyUsage.getPadBits() != 5) {
            return new SimpleTestResult(false, this.getName() + ": failed keyEncipherment");
        }
        keyUsage = new KeyUsage(2);
        if (keyUsage.getBytes()[0] != 2 || keyUsage.getPadBits() != 1) {
            return new SimpleTestResult(false, this.getName() + ": failed cRLSign");
        }
        keyUsage = new KeyUsage(32768);
        if (keyUsage.getBytes()[1] != -128 || keyUsage.getPadBits() != 7) {
            return new SimpleTestResult(false, this.getName() + ": failed decipherOnly");
        }
        try {
            ASN1Object.fromByteArray(new DERBitString(new byte[0], 0).getEncoded());
        }
        catch (IOException iOException) {
            return new SimpleTestResult(false, this.getName() + ": " + iOException);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public String getName() {
        return "BitString";
    }

    public static void main(String[] stringArray) {
        BitStringTest bitStringTest = new BitStringTest();
        TestResult testResult = bitStringTest.perform();
        System.out.println(testResult);
    }
}

