/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.DEROctetString;
import edu.illinois.ncsa.bouncycastle.asn1.DERUTF8String;
import edu.illinois.ncsa.bouncycastle.util.Arrays;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTestResult;
import edu.illinois.ncsa.bouncycastle.util.test.Test;
import edu.illinois.ncsa.bouncycastle.util.test.TestResult;

public class DERUTF8StringTest
implements Test {
    private static final char[] glyph1_utf16 = new char[]{'\ud801', '\udc00'};
    private static final byte[] glyph1_utf8 = new byte[]{-16, -112, -112, -128};
    private static final char[] glyph2_utf16 = new char[]{'\u6771'};
    private static final byte[] glyph2_utf8 = new byte[]{-26, -99, -79};
    private static final char[] glyph3_utf16 = new char[]{'\u00df'};
    private static final byte[] glyph3_utf8 = new byte[]{-61, -97};
    private static final char[] glyph4_utf16 = new char[]{'A'};
    private static final byte[] glyph4_utf8 = new byte[]{65};
    private static final byte[][] glyphs_utf8 = new byte[][]{glyph1_utf8, glyph2_utf8, glyph3_utf8, glyph4_utf8};
    private static final char[][] glyphs_utf16 = new char[][]{glyph1_utf16, glyph2_utf16, glyph3_utf16, glyph4_utf16};

    public TestResult perform() {
        try {
            for (int i = 0; i < glyphs_utf16.length; ++i) {
                String string = new String(glyphs_utf16[i]);
                byte[] byArray = new DERUTF8String(string).getEncoded();
                byte[] byArray2 = new byte[byArray.length - 2];
                System.arraycopy(byArray, 2, byArray2, 0, byArray.length - 2);
                byte[] byArray3 = new DERUTF8String(new DEROctetString(byArray2).getOctets()).getEncoded();
                if (!Arrays.areEqual(byArray, byArray3)) {
                    return new SimpleTestResult(false, this.getName() + ": failed UTF-8 encoding and decoding");
                }
                if (Arrays.areEqual(byArray2, glyphs_utf8[i])) continue;
                return new SimpleTestResult(false, this.getName() + ": failed UTF-8 encoding and decoding");
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": failed with Exception " + exception.getMessage());
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public String getName() {
        return "DERUTF8String";
    }

    public static void main(String[] stringArray) {
        DERUTF8StringTest dERUTF8StringTest = new DERUTF8StringTest();
        TestResult testResult = dERUTF8StringTest.perform();
        System.out.println(testResult);
    }
}

